#!/usr/bin/python

import os
import sys, os.path
sys.path.insert(0, os.path.realpath(os.path.join(os.path.dirname(__file__), "..")))

import unittest
from lpltk                import LaunchpadService

class TestBugTask(unittest.TestCase):

    # setUp
    #
    def setUp(self):
        self.configuration = {}
        self.configuration['launchpad_services_root'] = 'staging'

    def test_to_dict(self):
        ls    = LaunchpadService(self.configuration)
        bug   = ls.get_bug(3)
        bug_task = bug.tasks[0]
        d = bug_task.to_dict()
        self.assertEqual(d['target'], "Launchpad itself")
        self.assertEqual(d['date_created'], "2004-12-21T16:33:36.359671+00:00")
        self.assertEqual(len(d.keys()), 8)

if __name__ == '__main__':
    unittest.main()

# vi:set ts=4 sw=4 expandtab:
