import pytest

import helpers
import meshio


@pytest.mark.parametrize(
    "mesh",
    [helpers.tri_mesh, helpers.quad_mesh, helpers.tri_quad_mesh, helpers.tet_mesh],
)
def test_io(mesh):
    helpers.write_read(meshio._permas.write, meshio._permas.read, mesh, 1.0e-15)
    return


def test_generic_io():
    helpers.generic_io("test.post")
    helpers.generic_io("test.post.gz")
    # With additional, insignificant suffix:
    helpers.generic_io("test.0.post")
    helpers.generic_io("test.0.post.gz")
    return
