#include "CORBAmodule.h"

/* Generic CORBA.Object */
PyTypeObject CORBA_TypeCode_PyObject_Type = {
	PyObject_HEAD_INIT(NULL)
	0,       /*ob_size*/
	"CORBA.TypeCode",         /*tp_name*/
	sizeof(CORBA_TypeCode_PyObject),   /*tp_basicsize*/
	0,       /*tp_itemsize*/
	/* methods */
	(destructor)CORBA_TypeCode_PyObject__dealloc, /*tp_dealloc*/
	0,       /*tp_print*/
	(getattrfunc)CORBA_TypeCode_PyObject__getattr, /*tp_getattr*/
	(setattrfunc)CORBA_TypeCode_PyObject__setattr, /*tp_setattr*/
	0,       /*tp_compare*/
	(reprfunc)CORBA_TypeCode_PyObject__repr, /*tp_repr*/
	0,       /*tp_as_number*/
	0,       /*tp_as_sequence*/
	0,       /*tp_as_mapping*/
	0,       /*tp_hash*/
};

CORBA_TypeCode_PyObject *CORBA_TypeCode_PyObject__new(CORBA_TypeCode tc)
{
	CORBA_TypeCode_PyObject *self;


	self = PyObject_NEW(CORBA_TypeCode_PyObject, &CORBA_TypeCode_PyObject_Type);
	if (self) {
		self->tc = (CORBA_TypeCode)CORBA_Object_duplicate((CORBA_Object)tc, NULL);
		self->repo_id = find_repo_id_from_typecode(tc);
		if (self->repo_id)
			self->repo_id = g_strdup(self->repo_id);
		//self->repo_id = g_strdup(repo_id); // This is more narrow than the above
	}
		
	return self;
}


void CORBA_TypeCode_PyObject__dealloc(CORBA_TypeCode_PyObject *self)
{	
	if (self->repo_id)
		g_free(self->repo_id);
	CORBA_Object_release((CORBA_Object)self->tc, NULL);
	PyMem_DEL(self);
}

PyObject *CORBA_TypeCode_PyObject__getattr(CORBA_TypeCode_PyObject *self, 
                                           char *name)
{
	return NULL;
}

int CORBA_TypeCode_PyObject__setattr(CORBA_TypeCode_PyObject *self, 
                                     char *name, PyObject *v)
{
	return -1;
}

PyObject *CORBA_TypeCode_PyObject__repr (CORBA_TypeCode_PyObject *self)
{
	gchar    *repo_id;
	PyObject *retval;
	
	d_assert (self->repo_id != NULL);
	
	repo_id = g_strdup_printf ("<CORBA.TypeCode object at %x of type '%s'>",
		                   (int)self,
			           self->repo_id);
	
	retval = PyString_FromString (repo_id);
	g_free (repo_id);
	return retval;
}
