#
# Copyright (C) 2000-2005 by Yasushi Saito (yasushi.saito@gmail.com)
# 
# Jockey is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
#
# Jockey is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
import string
import doc_support
import sys
import re
import os

import area
import arrow
import axis
import bar_plot
import line_plot
import pie_plot
import color
import error_bar
import fill_style
import font
import text_box
import line_style
import legend
import range_plot
import tick_mark

indent = 4
max_line_len = 64

def format_paragraph(fp, str):
    line_len = indent
    fp.write(" " * indent)
    for word in str.split():
        if line_len >= max_line_len:
            fp.write("\n")
            fp.write(" " * indent)
            line_len = indent
        fp.write(word + " ")
        line_len += len(word) + 1
        
def format_string(fp, str):
    str = re.sub("<<([^>]+)>>", "See also pychart.\\1", str)

    str2 = ""
    in_example = 0
    for l in str.split("\n"):
        if re.match("@example", l):
            in_example = 1
        if re.match("@end example", l):
            in_example = 0
        if in_example:
            str2 += l
        else:
            l = re.sub("^[ \t]*", "", l)
            str2 += l
        str2 += "\n"    
    fname = os.tempnam()
    out_fp = open(fname, "w")
    out_fp.write(str2)
    out_fp.close()
    
    in_fp = os.popen("makeinfo --fill-column=64 --no-headers " + fname, "r")
    for l in in_fp.readlines():
        print "GOT", l
        fp.write(" " * indent)
        fp.write(l)
    in_fp.close()
    os.remove(fname)
    
def generate_doc(c, name, suffix="", append = 0):
    if append:
        fp = open(name + "_doc.py", "a+")
    else:
        fp = open(name + "_doc.py", "w")
        fp.write("# automatically generated by generate_docs.py.\n")
        
    fp.write("doc" + suffix + "=\"\"\"Attributes supported by this class are:\n")
    for key in c.keys.keys():
            val=c.keys[key]
            desc = ""
            defaultValDesc = None
            if len(val) > 3:
                desc = val[3]
            if len(val) > 4:
                defaultValDesc = val[4]
                
            fp.write(key + "(type:" + doc_support.stringify_type(val[0]))
            if defaultValDesc:
                fp.write(") default:" + defaultValDesc)
            else:
                fp.write(") default=" + str(doc_support.stringify_value(val[2])) + ".\n")
            format_string(fp, desc)
    fp.write("\"\"\"\n\n")           
    fp.close()


generate_doc(arrow.T, "arrow")
generate_doc(area.T, "area")
generate_doc(axis.X, "axis", "_x")
generate_doc(axis.Y, "axis", "_y", 1)
generate_doc(bar_plot.T, "bar_plot")
generate_doc(line_plot.T, "line_plot")
generate_doc(pie_plot.T, "pie_plot")
generate_doc(color.T, "color")
generate_doc(error_bar.error_bar1, "error_bar","_1")
generate_doc(error_bar.error_bar2, "error_bar", "_2", 1)
generate_doc(error_bar.error_bar3, "error_bar", "_3", 1)
generate_doc(error_bar.error_bar4, "error_bar", "_4", 1)
generate_doc(error_bar.error_bar5, "error_bar", "_5", 1)
generate_doc(error_bar.error_bar6, "error_bar", "_6", 1)
generate_doc(fill_style.T, "fill_style")
generate_doc(text_box.T, "text_box")
generate_doc(range_plot.T, "range_plot")
generate_doc(legend.T, "legend")
generate_doc(legend.Entry, "legend", "_entry", 1)
generate_doc(line_style.T, "line_style")
generate_doc(tick_mark.T, "tick_mark")
