# PySNMP SMI module. Autogenerated from smidump -f python APPN-MIB
# by libsmi2pysnmp-0.0.6-alpha at Thu Apr  6 13:19:08 2006,
# Python version (2, 4, 0, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( IANAifType, ) = mibBuilder.importSymbols("IANAifType-MIB", "IANAifType")
( snanauMIB, ) = mibBuilder.importSymbols("SNA-NAU-MIB", "snanauMIB")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32")
( DateAndTime, DisplayString, RowPointer, TextualConvention, TimeStamp, TruthValue, VariablePointer, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "DisplayString", "RowPointer", "TextualConvention", "TimeStamp", "TruthValue", "VariablePointer")

# Types

class AppnLinkStationCounter(Counter32):
    pass

class AppnNodeCounter(Counter32):
    pass

class AppnPortCounter(Counter32):
    pass

class AppnTgDelay(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(1,1)
    pass

class AppnTgDlcData(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,64)
    pass

class AppnTgEffectiveCapacity(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(1,1)
    pass

class AppnTgSecurity(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(192,128,160,64,32,96,1,)
    namedValues = namedval.NamedValues(("nonsecure", 1), ("guardedConduit", 128), ("encrypted", 160), ("guardedRadiation", 192), ("publicSwitchedNetwork", 32), ("undergroundCable", 64), ("secureConduit", 96), )
    pass

class AppnTopologyEntryTimeLeft(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,15)
    pass

class DisplayableDlcAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,64)
    pass

class SnaClassOfServiceName(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,8)
    pass

class SnaControlPointName(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(3,17)
    pass

class SnaModeName(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,8)
    pass

class SnaNodeIdentification(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(8,8)
    pass

class SnaSenseData(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(8,8)
    pass


# Objects

appnMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 34, 4)).setRevisions(("1998-07-15 18:00","1998-05-26 18:00","1997-07-31 18:00","1997-03-31 18:00","1997-03-20 12:00",))
appnObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1))
appnNode = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1))
appnGeneralInfoAndCaps = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1))
appnNodeCpName = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 1), SnaControlPointName()).setMaxAccess("readonly")
appnNodeMibVersion = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 2), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(11, 11))).setMaxAccess("readonly")
appnNodeId = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 3), SnaNodeIdentification()).setMaxAccess("readonly")
appnNodeType = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,4,)).subtype(namedValues=namedval.NamedValues(("networkNode", 1), ("endNode", 2), ("t21len", 4), ))).setMaxAccess("readonly")
appnNodeUpTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 5), TimeTicks()).setMaxAccess("readonly").setUnits("hundredths of a second")
appnNodeParallelTg = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 6), TruthValue()).setMaxAccess("readonly")
appnNodeAdaptiveBindPacing = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 7), TruthValue()).setMaxAccess("readonly")
appnNodeHprSupport = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,4,)).subtype(namedValues=namedval.NamedValues(("noHprSupport", 1), ("hprBaseOnly", 2), ("rtpTower", 3), ("controlFlowsOverRtpTower", 4), ))).setMaxAccess("readonly")
appnNodeMaxSessPerRtpConn = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 9), Gauge32()).setMaxAccess("readonly")
appnNodeHprIntRteSetups = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 10), AppnNodeCounter()).setMaxAccess("readonly")
appnNodeHprIntRteRejects = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 11), AppnNodeCounter()).setMaxAccess("readonly")
appnNodeHprOrgRteSetups = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 12), AppnNodeCounter()).setMaxAccess("readonly")
appnNodeHprOrgRteRejects = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 13), AppnNodeCounter()).setMaxAccess("readonly")
appnNodeHprEndRteSetups = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 14), AppnNodeCounter()).setMaxAccess("readonly")
appnNodeHprEndRteRejects = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 15), AppnNodeCounter()).setMaxAccess("readonly")
appnNodeCounterDisconTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 16), TimeStamp()).setMaxAccess("readonly")
appnNodeLsCounterType = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 17), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,4,1,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("noAnr", 2), ("anrForLocalNces", 3), ("allAnr", 4), ))).setMaxAccess("readonly")
appnNodeBrNn = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 18), TruthValue()).setMaxAccess("readonly")
appnNnUniqueInfoAndCaps = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2))
appnNodeNnCentralDirectory = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 1), TruthValue()).setMaxAccess("readonly")
appnNodeNnTreeCache = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("noCache", 1), ("cacheNoIncrUpdate", 2), ("cacheWithIncrUpdate", 3), ))).setMaxAccess("readonly")
appnNodeNnRouteAddResist = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnNodeNnIsr = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 4), TruthValue()).setMaxAccess("readonly")
appnNodeNnFrsn = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 5), Unsigned32()).setMaxAccess("readonly")
appnNodeNnPeriBorderSup = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 6), TruthValue()).setMaxAccess("readonly")
appnNodeNnInterchangeSup = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 7), TruthValue()).setMaxAccess("readonly")
appnNodeNnExteBorderSup = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 8), TruthValue()).setMaxAccess("readonly")
appnNodeNnSafeStoreFreq = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32767))).setMaxAccess("readwrite").setUnits("TDUs")
appnNodeNnRsn = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 10), Unsigned32()).setMaxAccess("readonly")
appnNodeNnCongested = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 11), TruthValue()).setMaxAccess("readonly")
appnNodeNnIsrDepleted = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 12), TruthValue()).setMaxAccess("readonly")
appnNodeNnQuiescing = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 13), TruthValue()).setMaxAccess("readonly")
appnNodeNnGateway = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 14), TruthValue()).setMaxAccess("readonly")
appnEnUniqueCaps = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 3))
appnNodeEnModeCosMap = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 3, 1), TruthValue()).setMaxAccess("readonly")
appnNodeEnNnServer = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 3, 2), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(3, 17))).setMaxAccess("readonly")
appnNodeEnLuSearch = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 3, 3), TruthValue()).setMaxAccess("readonly")
appnPortInformation = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4))
appnPortTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1))
appnPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1)).setIndexNames((0, "APPN-MIB", "appnPortName"))
appnPortName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 1), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 10))).setMaxAccess("noaccess")
appnPortCommand = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,4,2,)).subtype(namedValues=namedval.NamedValues(("deactivate", 1), ("activate", 2), ("recycle", 3), ("ready", 4), ))).setMaxAccess("readwrite")
appnPortOperState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,4,)).subtype(namedValues=namedval.NamedValues(("inactive", 1), ("pendactive", 2), ("active", 3), ("pendinact", 4), ))).setMaxAccess("readonly")
appnPortDlcType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 4), IANAifType()).setMaxAccess("readonly")
appnPortPortType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,)).subtype(namedValues=namedval.NamedValues(("leased", 1), ("switched", 2), ("sharedAccessFacilities", 3), ))).setMaxAccess("readonly")
appnPortSIMRIM = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 6), TruthValue()).setMaxAccess("readonly")
appnPortLsRole = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,2,1,3,)).subtype(namedValues=namedval.NamedValues(("primary", 1), ("secondary", 2), ("negotiable", 3), ("abm", 4), ))).setMaxAccess("readonly")
appnPortNegotLs = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 8), TruthValue()).setMaxAccess("readonly")
appnPortDynamicLinkSupport = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 9), TruthValue()).setMaxAccess("readonly")
appnPortMaxRcvBtuSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(99, 32767))).setMaxAccess("readonly")
appnPortMaxIframeWindow = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 11), Gauge32()).setMaxAccess("readonly")
appnPortDefLsGoodXids = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 12), AppnPortCounter()).setMaxAccess("readonly")
appnPortDefLsBadXids = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 13), AppnPortCounter()).setMaxAccess("readonly")
appnPortDynLsGoodXids = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 14), AppnPortCounter()).setMaxAccess("readonly")
appnPortDynLsBadXids = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 15), AppnPortCounter()).setMaxAccess("readonly")
appnPortSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 16), RowPointer()).setMaxAccess("readonly")
appnPortDlcLocalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 17), DisplayableDlcAddress()).setMaxAccess("readonly")
appnPortCounterDisconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 18), TimeStamp()).setMaxAccess("readonly")
appnLinkStationInformation = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5))
appnLsTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1))
appnLsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1)).setIndexNames((0, "APPN-MIB", "appnLsName"))
appnLsName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 1), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 10))).setMaxAccess("noaccess")
appnLsCommand = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,4,2,)).subtype(namedValues=namedval.NamedValues(("deactivate", 1), ("activate", 2), ("recycle", 3), ("ready", 4), ))).setMaxAccess("readwrite")
appnLsOperState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(10,3,8,9,1,5,6,7,4,2,11,)).subtype(namedValues=namedval.NamedValues(("inactive", 1), ("sentDiscImmed", 10), ("otherPendingInact", 11), ("sentConnectOut", 2), ("pendXidExch", 3), ("sendActAs", 4), ("sendSetMode", 5), ("otherPendingActive", 6), ("active", 7), ("sentDeactAsOrd", 8), ("sentDiscOrd", 9), ))).setMaxAccess("readonly")
appnLsPortName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 4), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 10))).setMaxAccess("readonly")
appnLsDlcType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 5), IANAifType()).setMaxAccess("readonly")
appnLsDynamic = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 6), TruthValue()).setMaxAccess("readonly")
appnLsAdjCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 7), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(3, 17))).setMaxAccess("readonly")
appnLsAdjNodeType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,255,1,4,)).subtype(namedValues=namedval.NamedValues(("networkNode", 1), ("endNode", 2), ("unknown", 255), ("t21len", 4), ))).setMaxAccess("readonly")
appnLsTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 256))).setMaxAccess("readonly")
appnLsLimResource = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 10), TruthValue()).setMaxAccess("readonly")
appnLsActOnDemand = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 11), TruthValue()).setMaxAccess("readonly")
appnLsMigration = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 12), TruthValue()).setMaxAccess("readonly")
appnLsPartnerNodeId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 13), SnaNodeIdentification()).setMaxAccess("readonly")
appnLsCpCpSessionSupport = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 14), TruthValue()).setMaxAccess("readonly")
appnLsMaxSendBtuSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 15), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(99, 32767))).setMaxAccess("readonly")
appnLsInXidBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 16), AppnLinkStationCounter()).setMaxAccess("readonly")
appnLsInMsgBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 17), AppnLinkStationCounter()).setMaxAccess("readonly")
appnLsInXidFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 18), AppnLinkStationCounter()).setMaxAccess("readonly")
appnLsInMsgFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 19), AppnLinkStationCounter()).setMaxAccess("readonly")
appnLsOutXidBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 20), AppnLinkStationCounter()).setMaxAccess("readonly")
appnLsOutMsgBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 21), AppnLinkStationCounter()).setMaxAccess("readonly")
appnLsOutXidFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 22), AppnLinkStationCounter()).setMaxAccess("readonly")
appnLsOutMsgFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 23), AppnLinkStationCounter()).setMaxAccess("readonly")
appnLsEchoRsps = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 24), AppnLinkStationCounter()).setMaxAccess("readonly")
appnLsCurrentDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 25), Gauge32()).setMaxAccess("readonly")
appnLsMaxDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 26), Gauge32()).setMaxAccess("readonly")
appnLsMinDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 27), Gauge32()).setMaxAccess("readonly")
appnLsMaxDelayTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 28), DateAndTime()).setMaxAccess("readonly")
appnLsGoodXids = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 29), AppnLinkStationCounter()).setMaxAccess("readonly")
appnLsBadXids = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 30), AppnLinkStationCounter()).setMaxAccess("readonly")
appnLsSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 31), RowPointer()).setMaxAccess("readonly")
appnLsActiveTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 32), Unsigned32()).setMaxAccess("readonly")
appnLsCurrentStateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 33), TimeTicks()).setMaxAccess("readonly")
appnLsHprSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 34), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,4,)).subtype(namedValues=namedval.NamedValues(("noHprSupport", 1), ("hprBaseOnly", 2), ("rtpTower", 3), ("controlFlowsOverRtpTower", 4), ))).setMaxAccess("readonly")
appnLsErrRecoSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 35), TruthValue()).setMaxAccess("readonly")
appnLsForAnrLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 36), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
appnLsRevAnrLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 37), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
appnLsCpCpNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 38), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
appnLsRouteNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 39), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
appnLsBfNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 40), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
appnLsLocalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 41), DisplayableDlcAddress()).setMaxAccess("readonly")
appnLsRemoteAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 42), DisplayableDlcAddress()).setMaxAccess("readonly")
appnLsRemoteLsName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 43), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 10))).setMaxAccess("readonly")
appnLsCounterDisconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 44), TimeStamp()).setMaxAccess("readonly")
appnLsMltgMember = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 45), TruthValue()).setMaxAccess("readonly")
appnLsStatusTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2))
appnLsStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1)).setIndexNames((0, "APPN-MIB", "appnLsStatusIndex"))
appnLsStatusIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647L))).setMaxAccess("noaccess")
appnLsStatusTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 2), DateAndTime()).setMaxAccess("readonly")
appnLsStatusLsName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 3), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 10))).setMaxAccess("readonly")
appnLsStatusCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 4), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(3, 17))).setMaxAccess("readonly")
appnLsStatusPartnerId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 5), SnaNodeIdentification()).setMaxAccess("readonly")
appnLsStatusTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 256))).setMaxAccess("readonly")
appnLsStatusGeneralSense = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 7), SnaSenseData()).setMaxAccess("readonly")
appnLsStatusRetry = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 8), TruthValue()).setMaxAccess("readonly")
appnLsStatusEndSense = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 9), SnaSenseData()).setMaxAccess("readonly")
appnLsStatusXidLocalSense = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 10), SnaSenseData()).setMaxAccess("readonly")
appnLsStatusXidRemoteSense = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 11), SnaSenseData()).setMaxAccess("readonly")
appnLsStatusXidByteInError = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65536))).setMaxAccess("readonly")
appnLsStatusXidBitInError = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 8))).setMaxAccess("readonly")
appnLsStatusDlcType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 14), IANAifType()).setMaxAccess("readonly")
appnLsStatusLocalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 15), DisplayableDlcAddress()).setMaxAccess("readonly")
appnLsStatusRemoteAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 16), DisplayableDlcAddress()).setMaxAccess("readonly")
appnVrnInfo = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 6))
appnVrnTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 6, 1))
appnVrnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 6, 1, 1)).setIndexNames((0, "APPN-MIB", "appnVrnName"), (0, "APPN-MIB", "appnVrnTgNum"), (0, "APPN-MIB", "appnVrnPortName"))
appnVrnName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 6, 1, 1, 1), SnaControlPointName()).setMaxAccess("noaccess")
appnVrnTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 6, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
appnVrnPortName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 6, 1, 1, 3), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 10))).setMaxAccess("readonly")
appnNn = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 2))
appnNnTopo = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 1))
appnNnTopoMaxNodes = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 1, 1), Gauge32()).setMaxAccess("readonly").setUnits("node entries")
appnNnTopoCurNumNodes = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 1, 2), Gauge32()).setMaxAccess("readonly").setUnits("node entries")
appnNnTopoNodePurges = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 1, 3), AppnNodeCounter()).setMaxAccess("readonly").setUnits("node entries")
appnNnTopoTgPurges = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 1, 4), AppnNodeCounter()).setMaxAccess("readonly").setUnits("TG entries")
appnNnTopoTotalTduWars = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 1, 5), AppnNodeCounter()).setMaxAccess("readonly").setUnits("TDU wars")
appnNnTopology = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2))
appnNnTopologyFRTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3))
appnNnTopologyFREntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1)).setIndexNames((0, "APPN-MIB", "appnNnNodeFRFrsn"), (0, "APPN-MIB", "appnNnNodeFRName"))
appnNnNodeFRFrsn = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 1), Unsigned32()).setMaxAccess("noaccess")
appnNnNodeFRName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 2), SnaControlPointName()).setMaxAccess("noaccess")
appnNnNodeFREntryTimeLeft = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 3), AppnTopologyEntryTimeLeft()).setMaxAccess("readonly")
appnNnNodeFRType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,)).subtype(namedValues=namedval.NamedValues(("networkNode", 1), ("virtualRoutingNode", 3), ))).setMaxAccess("readonly")
appnNnNodeFRRsn = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 5), Unsigned32()).setMaxAccess("readonly")
appnNnNodeFRRouteAddResist = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnNnNodeFRCongested = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 7), TruthValue()).setMaxAccess("readonly")
appnNnNodeFRIsrDepleted = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 8), TruthValue()).setMaxAccess("readonly")
appnNnNodeFRQuiescing = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 9), TruthValue()).setMaxAccess("readonly")
appnNnNodeFRGateway = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 10), TruthValue()).setMaxAccess("readonly")
appnNnNodeFRCentralDirectory = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 11), TruthValue()).setMaxAccess("readonly")
appnNnNodeFRIsr = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 12), TruthValue()).setMaxAccess("readonly")
appnNnNodeFRGarbageCollect = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 13), TruthValue()).setMaxAccess("readonly")
appnNnNodeFRHprSupport = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 14), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,4,)).subtype(namedValues=namedval.NamedValues(("noHprSupport", 1), ("hprBaseOnly", 2), ("rtpTower", 3), ("controlFlowsOverRtpTower", 4), ))).setMaxAccess("readonly")
appnNnNodeFRPeriBorderSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 15), TruthValue()).setMaxAccess("readonly")
appnNnNodeFRInterchangeSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 16), TruthValue()).setMaxAccess("readonly")
appnNnNodeFRExteBorderSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 17), TruthValue()).setMaxAccess("readonly")
appnNnNodeFRBranchAwareness = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 18), TruthValue()).setMaxAccess("readonly")
appnNnTgTopologyFRTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4))
appnNnTgTopologyFREntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1)).setIndexNames((0, "APPN-MIB", "appnNnTgFRFrsn"), (0, "APPN-MIB", "appnNnTgFROwner"), (0, "APPN-MIB", "appnNnTgFRDest"), (0, "APPN-MIB", "appnNnTgFRNum"))
appnNnTgFRFrsn = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 1), Unsigned32()).setMaxAccess("noaccess")
appnNnTgFROwner = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 2), SnaControlPointName()).setMaxAccess("noaccess")
appnNnTgFRDest = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 3), SnaControlPointName()).setMaxAccess("noaccess")
appnNnTgFRNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
appnNnTgFREntryTimeLeft = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 5), AppnTopologyEntryTimeLeft()).setMaxAccess("readonly")
appnNnTgFRDestVirtual = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 6), TruthValue()).setMaxAccess("readonly")
appnNnTgFRDlcData = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 7), AppnTgDlcData()).setMaxAccess("readonly")
appnNnTgFRRsn = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 8), Unsigned32()).setMaxAccess("readonly")
appnNnTgFROperational = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 9), TruthValue()).setMaxAccess("readonly")
appnNnTgFRQuiescing = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 10), TruthValue()).setMaxAccess("readonly")
appnNnTgFRCpCpSession = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,4,)).subtype(namedValues=namedval.NamedValues(("supportedUnknownStatus", 1), ("supportedActive", 2), ("notSupported", 3), ("supportedNotActive", 4), ))).setMaxAccess("readonly")
appnNnTgFREffCap = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 12), AppnTgEffectiveCapacity()).setMaxAccess("readonly")
appnNnTgFRConnCost = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnNnTgFRByteCost = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnNnTgFRSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 15), AppnTgSecurity()).setMaxAccess("readonly")
appnNnTgFRDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 16), AppnTgDelay()).setMaxAccess("readonly")
appnNnTgFRUsr1 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 17), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnNnTgFRUsr2 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 18), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnNnTgFRUsr3 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 19), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnNnTgFRGarbageCollect = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 20), TruthValue()).setMaxAccess("readonly")
appnNnTgFRSubareaNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 21), Unsigned32()).setMaxAccess("readonly")
appnNnTgFRHprSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 22), TruthValue()).setMaxAccess("readonly")
appnNnTgFRDestHprTrans = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 23), TruthValue()).setMaxAccess("readonly")
appnNnTgFRTypeIndicator = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 24), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,4,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("appnOrBfTg", 2), ("interchangeTg", 3), ("virtualRouteTg", 4), ))).setMaxAccess("readonly")
appnNnTgFRIntersubnet = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 25), TruthValue()).setMaxAccess("readonly")
appnNnTgFRMltgLinkType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 26), TruthValue()).setMaxAccess("readonly")
appnNnTgFRBranchTg = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 27), TruthValue()).setMaxAccess("readonly")
appnLocalTopology = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 3))
appnLocalTgTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1))
appnLocalTgEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1)).setIndexNames((0, "APPN-MIB", "appnLocalTgDest"), (0, "APPN-MIB", "appnLocalTgNum"))
appnLocalTgDest = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 1), SnaControlPointName()).setMaxAccess("noaccess")
appnLocalTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
appnLocalTgDestVirtual = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 3), TruthValue()).setMaxAccess("readonly")
appnLocalTgDlcData = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 4), AppnTgDlcData()).setMaxAccess("readonly")
appnLocalTgPortName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 5), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 10))).setMaxAccess("readonly")
appnLocalTgQuiescing = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 6), TruthValue()).setMaxAccess("readonly")
appnLocalTgOperational = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 7), TruthValue()).setMaxAccess("readonly")
appnLocalTgCpCpSession = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,4,)).subtype(namedValues=namedval.NamedValues(("supportedUnknownStatus", 1), ("supportedActive", 2), ("notSupported", 3), ("supportedNotActive", 4), ))).setMaxAccess("readonly")
appnLocalTgEffCap = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 9), AppnTgEffectiveCapacity()).setMaxAccess("readonly")
appnLocalTgConnCost = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnLocalTgByteCost = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 11), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnLocalTgSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 12), AppnTgSecurity()).setMaxAccess("readonly")
appnLocalTgDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 13), AppnTgDelay()).setMaxAccess("readonly")
appnLocalTgUsr1 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnLocalTgUsr2 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 15), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnLocalTgUsr3 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 16), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnLocalTgHprSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 17), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,4,)).subtype(namedValues=namedval.NamedValues(("noHprSupport", 1), ("hprBaseOnly", 2), ("rtpTower", 3), ("controlFlowsOverRtpTower", 4), ))).setMaxAccess("readonly")
appnLocalTgIntersubnet = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 18), TruthValue()).setMaxAccess("readonly")
appnLocalTgMltgLinkType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 19), TruthValue()).setMaxAccess("readonly")
appnLocalTgBranchLinkType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 20), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,255,3,1,4,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("uplink", 2), ("unknown", 255), ("downlink", 3), ("downlinkToBranchNetworkNode", 4), ("none", 5), ))).setMaxAccess("readonly")
appnLocalEnTgTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2))
appnLocalEnTgEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1)).setIndexNames((0, "APPN-MIB", "appnLocalEnTgOrigin"), (0, "APPN-MIB", "appnLocalEnTgDest"), (0, "APPN-MIB", "appnLocalEnTgNum"))
appnLocalEnTgOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 1), SnaControlPointName()).setMaxAccess("noaccess")
appnLocalEnTgDest = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 2), SnaControlPointName()).setMaxAccess("noaccess")
appnLocalEnTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
appnLocalEnTgEntryTimeLeft = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 4), AppnTopologyEntryTimeLeft()).setMaxAccess("readonly")
appnLocalEnTgDestVirtual = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 5), TruthValue()).setMaxAccess("readonly")
appnLocalEnTgDlcData = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 6), AppnTgDlcData()).setMaxAccess("readonly")
appnLocalEnTgOperational = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 7), TruthValue()).setMaxAccess("readonly")
appnLocalEnTgCpCpSession = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,4,)).subtype(namedValues=namedval.NamedValues(("supportedUnknownStatus", 1), ("supportedActive", 2), ("notSupported", 3), ("supportedNotActive", 4), ))).setMaxAccess("readonly")
appnLocalEnTgEffCap = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 9), AppnTgEffectiveCapacity()).setMaxAccess("readonly")
appnLocalEnTgConnCost = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnLocalEnTgByteCost = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 11), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnLocalEnTgSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 12), AppnTgSecurity()).setMaxAccess("readonly")
appnLocalEnTgDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 13), AppnTgDelay()).setMaxAccess("readonly")
appnLocalEnTgUsr1 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnLocalEnTgUsr2 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 15), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnLocalEnTgUsr3 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 16), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnLocalEnTgMltgLinkType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 17), TruthValue()).setMaxAccess("readonly")
appnDir = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 4))
appnDirPerf = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1))
appnDirMaxCaches = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 1), Unsigned32()).setMaxAccess("readonly").setUnits("directory entries")
appnDirCurCaches = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 2), Gauge32()).setMaxAccess("readonly").setUnits("directory entries")
appnDirCurHomeEntries = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 3), Gauge32()).setMaxAccess("readonly").setUnits("directory entries")
appnDirRegEntries = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 4), Gauge32()).setMaxAccess("readonly").setUnits("directory entries")
appnDirInLocates = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 5), AppnNodeCounter()).setMaxAccess("readonly").setUnits("Locate messages")
appnDirInBcastLocates = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 6), AppnNodeCounter()).setMaxAccess("readonly").setUnits("Locate messages")
appnDirOutLocates = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 7), AppnNodeCounter()).setMaxAccess("readonly").setUnits("Locate messages")
appnDirOutBcastLocates = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 8), AppnNodeCounter()).setMaxAccess("readonly").setUnits("Locate messages")
appnDirNotFoundLocates = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 9), AppnNodeCounter()).setMaxAccess("readonly").setUnits("Locate messages")
appnDirNotFoundBcastLocates = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 10), AppnNodeCounter()).setMaxAccess("readonly").setUnits("Locate messages")
appnDirLocateOutstands = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 11), Gauge32()).setMaxAccess("readonly").setUnits("Locate messages")
appnDirTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2))
appnDirEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1)).setIndexNames((0, "APPN-MIB", "appnDirLuName"))
appnDirLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1, 1), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
appnDirNnServerName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1, 2), SnaControlPointName()).setMaxAccess("readonly")
appnDirLuOwnerName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1, 3), SnaControlPointName()).setMaxAccess("readonly")
appnDirLuLocation = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("local", 1), ("domain", 2), ("xdomain", 3), ))).setMaxAccess("readonly")
appnDirType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("home", 1), ("cache", 2), ("registered", 3), ))).setMaxAccess("readonly")
appnDirApparentLuOwnerName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1, 6), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(3, 17))).setMaxAccess("readonly")
appnCos = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 5))
appnCosModeTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 1))
appnCosModeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 1, 1)).setIndexNames((0, "APPN-MIB", "appnCosModeName"))
appnCosModeName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 1, 1, 1), SnaModeName()).setMaxAccess("noaccess")
appnCosModeCosName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 1, 1, 2), SnaClassOfServiceName()).setMaxAccess("readonly")
appnCosNameTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 2))
appnCosNameEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 2, 1)).setIndexNames((0, "APPN-MIB", "appnCosName"))
appnCosName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 2, 1, 1), SnaClassOfServiceName()).setMaxAccess("noaccess")
appnCosTransPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 2, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,4,2,1,)).subtype(namedValues=namedval.NamedValues(("low", 1), ("medium", 2), ("high", 3), ("network", 4), ))).setMaxAccess("readonly")
appnCosNodeRowTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3))
appnCosNodeRowEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1)).setIndexNames((0, "APPN-MIB", "appnCosNodeRowName"), (0, "APPN-MIB", "appnCosNodeRowIndex"))
appnCosNodeRowName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 1), SnaClassOfServiceName()).setMaxAccess("noaccess")
appnCosNodeRowIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
appnCosNodeRowWgt = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 3), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 64))).setMaxAccess("readonly")
appnCosNodeRowResistMin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnCosNodeRowResistMax = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnCosNodeRowMinCongestAllow = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1))).setMaxAccess("readonly")
appnCosNodeRowMaxCongestAllow = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1))).setMaxAccess("readonly")
appnCosTgRowTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4))
appnCosTgRowEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1)).setIndexNames((0, "APPN-MIB", "appnCosTgRowName"), (0, "APPN-MIB", "appnCosTgRowIndex"))
appnCosTgRowName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 1), SnaClassOfServiceName()).setMaxAccess("noaccess")
appnCosTgRowIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
appnCosTgRowWgt = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 3), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 64))).setMaxAccess("readonly")
appnCosTgRowEffCapMin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 4), AppnTgEffectiveCapacity()).setMaxAccess("readonly")
appnCosTgRowEffCapMax = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 5), AppnTgEffectiveCapacity()).setMaxAccess("readonly")
appnCosTgRowConnCostMin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnCosTgRowConnCostMax = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnCosTgRowByteCostMin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnCosTgRowByteCostMax = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnCosTgRowSecurityMin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 10), AppnTgSecurity()).setMaxAccess("readonly")
appnCosTgRowSecurityMax = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 11), AppnTgSecurity()).setMaxAccess("readonly")
appnCosTgRowDelayMin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 12), AppnTgDelay()).setMaxAccess("readonly")
appnCosTgRowDelayMax = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 13), AppnTgDelay()).setMaxAccess("readonly")
appnCosTgRowUsr1Min = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnCosTgRowUsr1Max = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 15), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnCosTgRowUsr2Min = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 16), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnCosTgRowUsr2Max = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 17), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnCosTgRowUsr3Min = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 18), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnCosTgRowUsr3Max = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 19), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
appnSessIntermediate = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 6))
appnIsInGlobal = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1))
appnIsInGlobeCtrAdminStatus = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("notActive", 1), ("active", 2), ("ready", 3), ))).setMaxAccess("readwrite")
appnIsInGlobeCtrOperStatus = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("notActive", 1), ("active", 2), ))).setMaxAccess("readonly")
appnIsInGlobeCtrStatusTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 3), TimeTicks()).setMaxAccess("readonly").setUnits("hundredths of a second")
appnIsInGlobeRscv = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("notActive", 1), ("active", 2), ))).setMaxAccess("readwrite")
appnIsInGlobeRscvTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 5), TimeTicks()).setMaxAccess("readonly").setUnits("hundredths of a second")
appnIsInGlobeActSess = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 6), Gauge32()).setMaxAccess("readonly").setUnits("sessions")
appnIsInGlobeHprBfActSess = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 7), Gauge32()).setMaxAccess("readonly").setUnits("sessions")
appnIsInTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2))
appnIsInEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1)).setIndexNames((0, "APPN-MIB", "appnIsInFqCpName"), (0, "APPN-MIB", "appnIsInPcid"))
appnIsInFqCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 1), SnaControlPointName()).setMaxAccess("noaccess")
appnIsInPcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 2), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(8, 8))).setMaxAccess("noaccess")
appnIsInSessState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,4,)).subtype(namedValues=namedval.NamedValues(("inactive", 1), ("pendactive", 2), ("active", 3), ("pendinact", 4), ))).setMaxAccess("readwrite")
appnIsInPriLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 4), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 17))).setMaxAccess("readonly")
appnIsInSecLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 5), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 17))).setMaxAccess("readonly")
appnIsInModeName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 6), SnaModeName()).setMaxAccess("readonly")
appnIsInCosName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 7), SnaClassOfServiceName()).setMaxAccess("readonly")
appnIsInTransPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,4,2,1,)).subtype(namedValues=namedval.NamedValues(("low", 1), ("medium", 2), ("high", 3), ("network", 4), ))).setMaxAccess("readonly")
appnIsInSessType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,1,3,2,5,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("lu62", 2), ("lu0thru3", 3), ("lu62dlur", 4), ("lu0thru3dlur", 5), ))).setMaxAccess("readonly")
appnIsInSessUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 10), TimeTicks()).setMaxAccess("readonly")
appnIsInCtrUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 11), TimeTicks()).setMaxAccess("readonly")
appnIsInP2SFmdPius = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 12), Unsigned32()).setMaxAccess("readonly")
appnIsInS2PFmdPius = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 13), Unsigned32()).setMaxAccess("readonly")
appnIsInP2SNonFmdPius = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 14), Unsigned32()).setMaxAccess("readonly")
appnIsInS2PNonFmdPius = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 15), Unsigned32()).setMaxAccess("readonly")
appnIsInP2SFmdBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 16), Unsigned32()).setMaxAccess("readonly")
appnIsInS2PFmdBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 17), Unsigned32()).setMaxAccess("readonly")
appnIsInP2SNonFmdBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 18), Unsigned32()).setMaxAccess("readonly")
appnIsInS2PNonFmdBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 19), Unsigned32()).setMaxAccess("readonly")
appnIsInPsAdjCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 20), SnaControlPointName()).setMaxAccess("readonly")
appnIsInPsAdjTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 21), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 300))).setMaxAccess("readonly")
appnIsInPsSendMaxBtuSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 22), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(99, 32767))).setMaxAccess("readonly")
appnIsInPsSendPacingType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 23), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("fixed", 1), ("adaptive", 2), ))).setMaxAccess("readonly")
appnIsInPsSendRpc = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 24), Gauge32()).setMaxAccess("readonly")
appnIsInPsSendNxWndwSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 25), Gauge32()).setMaxAccess("readonly")
appnIsInPsRecvPacingType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 26), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("fixed", 1), ("adaptive", 2), ))).setMaxAccess("readonly")
appnIsInPsRecvRpc = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 27), Gauge32()).setMaxAccess("readonly")
appnIsInPsRecvNxWndwSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 28), Gauge32()).setMaxAccess("readonly")
appnIsInSsAdjCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 29), SnaControlPointName()).setMaxAccess("readonly")
appnIsInSsAdjTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 30), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 300))).setMaxAccess("readonly")
appnIsInSsSendMaxBtuSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 31), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(99, 32767))).setMaxAccess("readonly")
appnIsInSsSendPacingType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 32), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("fixed", 1), ("adaptive", 2), ))).setMaxAccess("readonly")
appnIsInSsSendRpc = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 33), Gauge32()).setMaxAccess("readonly")
appnIsInSsSendNxWndwSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 34), Gauge32()).setMaxAccess("readonly")
appnIsInSsRecvPacingType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 35), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("fixed", 1), ("adaptive", 2), ))).setMaxAccess("readonly")
appnIsInSsRecvRpc = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 36), Gauge32()).setMaxAccess("readonly")
appnIsInSsRecvNxWndwSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 37), Gauge32()).setMaxAccess("readonly")
appnIsInRouteInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 38), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
appnIsInRtpNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 39), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 8))).setMaxAccess("readonly")
appnIsInRtpTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 40), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(8, 8))).setMaxAccess("readonly")
appnIsRtpTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 3))
appnIsRtpEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 3, 1)).setIndexNames((0, "APPN-MIB", "appnIsRtpNceId"), (0, "APPN-MIB", "appnIsRtpTcid"))
appnIsRtpNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 3, 1, 1), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 8))).setMaxAccess("noaccess")
appnIsRtpTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 3, 1, 2), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(8, 8))).setMaxAccess("noaccess")
appnIsRtpSessions = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 3, 1, 3), Gauge32()).setMaxAccess("readonly")
appnTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 2))
alertIdNumber = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 2, 2), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 4))).setMaxAccess("notifyonly")
affectedObject = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 2, 3), VariablePointer()).setMaxAccess("notifyonly")
appnConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 3))
appnCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 3, 1))
appnGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 3, 2))

# Augmentions

# Notifications

alertTrap = NotificationType((1, 3, 6, 1, 2, 1, 34, 4, 2, 1)).setObjects(("APPN-MIB", "alertIdNumber"), ("APPN-MIB", "affectedObject"), )

# Groups

appnTrapNotifGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 19)).setObjects(("APPN-MIB", "alertTrap"), )
appnGeneralConfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 26)).setObjects(("APPN-MIB", "appnNodeAdaptiveBindPacing"), ("APPN-MIB", "appnNodeType"), ("APPN-MIB", "appnNodeCpName"), ("APPN-MIB", "appnNodeBrNn"), ("APPN-MIB", "appnNodeId"), ("APPN-MIB", "appnNodeLsCounterType"), ("APPN-MIB", "appnNodeParallelTg"), ("APPN-MIB", "appnNodeHprSupport"), ("APPN-MIB", "appnNodeUpTime"), ("APPN-MIB", "appnNodeCounterDisconTime"), )
appnLocalTgConfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 28)).setObjects(("APPN-MIB", "appnLocalTgOperational"), ("APPN-MIB", "appnLocalTgQuiescing"), ("APPN-MIB", "appnLocalTgPortName"), ("APPN-MIB", "appnLocalTgUsr3"), ("APPN-MIB", "appnLocalTgIntersubnet"), ("APPN-MIB", "appnLocalTgDlcData"), ("APPN-MIB", "appnLocalTgEffCap"), ("APPN-MIB", "appnLocalTgMltgLinkType"), ("APPN-MIB", "appnLocalTgUsr2"), ("APPN-MIB", "appnLocalTgConnCost"), ("APPN-MIB", "appnLocalTgHprSup"), ("APPN-MIB", "appnLocalTgByteCost"), ("APPN-MIB", "appnLocalTgDestVirtual"), ("APPN-MIB", "appnLocalTgCpCpSession"), ("APPN-MIB", "appnLocalTgSecurity"), ("APPN-MIB", "appnLocalTgDelay"), ("APPN-MIB", "appnLocalTgUsr1"), )
appnCosConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 12)).setObjects(("APPN-MIB", "appnCosTgRowEffCapMin"), ("APPN-MIB", "appnCosTgRowUsr3Min"), ("APPN-MIB", "appnCosTgRowSecurityMax"), ("APPN-MIB", "appnCosTransPriority"), ("APPN-MIB", "appnCosTgRowConnCostMax"), ("APPN-MIB", "appnCosTgRowSecurityMin"), ("APPN-MIB", "appnCosTgRowUsr2Max"), ("APPN-MIB", "appnCosNodeRowWgt"), ("APPN-MIB", "appnCosTgRowConnCostMin"), ("APPN-MIB", "appnCosTgRowUsr1Min"), ("APPN-MIB", "appnCosTgRowDelayMin"), ("APPN-MIB", "appnCosNodeRowMaxCongestAllow"), ("APPN-MIB", "appnCosNodeRowResistMax"), ("APPN-MIB", "appnCosTgRowByteCostMin"), ("APPN-MIB", "appnCosTgRowUsr2Min"), ("APPN-MIB", "appnCosNodeRowResistMin"), ("APPN-MIB", "appnCosModeCosName"), ("APPN-MIB", "appnCosTgRowDelayMax"), ("APPN-MIB", "appnCosTgRowUsr1Max"), ("APPN-MIB", "appnCosTgRowEffCapMax"), ("APPN-MIB", "appnCosTgRowUsr3Max"), ("APPN-MIB", "appnCosTgRowByteCostMax"), ("APPN-MIB", "appnCosNodeRowMinCongestAllow"), ("APPN-MIB", "appnCosTgRowWgt"), )
appnEnUniqueConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 7)).setObjects(("APPN-MIB", "appnNodeEnModeCosMap"), ("APPN-MIB", "appnNodeEnLuSearch"), ("APPN-MIB", "appnNodeEnNnServer"), )
appnNnTopoConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 9)).setObjects(("APPN-MIB", "appnNnNodeFRRouteAddResist"), ("APPN-MIB", "appnNnTgFRRsn"), ("APPN-MIB", "appnNnTgFRHprSup"), ("APPN-MIB", "appnNnTgFREffCap"), ("APPN-MIB", "appnNnTopoCurNumNodes"), ("APPN-MIB", "appnNnTgFRSecurity"), ("APPN-MIB", "appnNnNodeFRIsrDepleted"), ("APPN-MIB", "appnNnTgFRTypeIndicator"), ("APPN-MIB", "appnNnTgFRDlcData"), ("APPN-MIB", "appnNnNodeFRRsn"), ("APPN-MIB", "appnNnTgFRGarbageCollect"), ("APPN-MIB", "appnNnNodeFRGarbageCollect"), ("APPN-MIB", "appnNnTgFROperational"), ("APPN-MIB", "appnNnTgFRUsr2"), ("APPN-MIB", "appnNnTgFRUsr3"), ("APPN-MIB", "appnNnTgFRUsr1"), ("APPN-MIB", "appnNnTgFRConnCost"), ("APPN-MIB", "appnNnTgFRDestVirtual"), ("APPN-MIB", "appnNnTgFRSubareaNum"), ("APPN-MIB", "appnNnTgFRDelay"), ("APPN-MIB", "appnNnNodeFRType"), ("APPN-MIB", "appnNnNodeFRIsr"), ("APPN-MIB", "appnNnTgFRQuiescing"), ("APPN-MIB", "appnNnTgFRDestHprTrans"), ("APPN-MIB", "appnNnTgFREntryTimeLeft"), ("APPN-MIB", "appnNnNodeFRInterchangeSup"), ("APPN-MIB", "appnNnNodeFRQuiescing"), ("APPN-MIB", "appnNnNodeFRCentralDirectory"), ("APPN-MIB", "appnNnTopoTgPurges"), ("APPN-MIB", "appnNnNodeFRGateway"), ("APPN-MIB", "appnNnNodeFRHprSupport"), ("APPN-MIB", "appnNnNodeFRPeriBorderSup"), ("APPN-MIB", "appnNnTopoMaxNodes"), ("APPN-MIB", "appnNnTgFRByteCost"), ("APPN-MIB", "appnNnTgFRCpCpSession"), ("APPN-MIB", "appnNnTopoNodePurges"), ("APPN-MIB", "appnNnTopoTotalTduWars"), ("APPN-MIB", "appnNnNodeFREntryTimeLeft"), ("APPN-MIB", "appnNnTgFRIntersubnet"), ("APPN-MIB", "appnNnNodeFRCongested"), ("APPN-MIB", "appnNnNodeFRExteBorderSup"), )
appnGeneralConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 1)).setObjects(("APPN-MIB", "appnNodeAdaptiveBindPacing"), ("APPN-MIB", "appnNodeType"), ("APPN-MIB", "appnNodeCpName"), ("APPN-MIB", "appnNodeMibVersion"), ("APPN-MIB", "appnNodeId"), ("APPN-MIB", "appnNodeParallelTg"), ("APPN-MIB", "appnNodeHprSupport"), ("APPN-MIB", "appnNodeUpTime"), ("APPN-MIB", "appnNodeCounterDisconTime"), )
appnVrnConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 8)).setObjects(("APPN-MIB", "appnVrnPortName"), )
appnNnTopoConfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 30)).setObjects(("APPN-MIB", "appnNnNodeFRRouteAddResist"), ("APPN-MIB", "appnNnTgFRRsn"), ("APPN-MIB", "appnNnTgFRHprSup"), ("APPN-MIB", "appnNnTgFRBranchTg"), ("APPN-MIB", "appnNnTgFREffCap"), ("APPN-MIB", "appnNnTopoCurNumNodes"), ("APPN-MIB", "appnNnTgFRSecurity"), ("APPN-MIB", "appnNnNodeFRIsrDepleted"), ("APPN-MIB", "appnNnTgFRTypeIndicator"), ("APPN-MIB", "appnNnTgFRMltgLinkType"), ("APPN-MIB", "appnNnTgFRDlcData"), ("APPN-MIB", "appnNnNodeFRRsn"), ("APPN-MIB", "appnNnTgFRGarbageCollect"), ("APPN-MIB", "appnNnNodeFRGarbageCollect"), ("APPN-MIB", "appnNnTgFROperational"), ("APPN-MIB", "appnNnTgFRUsr2"), ("APPN-MIB", "appnNnTgFRUsr3"), ("APPN-MIB", "appnNnTgFRUsr1"), ("APPN-MIB", "appnNnTgFRConnCost"), ("APPN-MIB", "appnNnTgFRDestVirtual"), ("APPN-MIB", "appnNnTgFRSubareaNum"), ("APPN-MIB", "appnNnTgFRDelay"), ("APPN-MIB", "appnNnNodeFRType"), ("APPN-MIB", "appnNnNodeFRIsr"), ("APPN-MIB", "appnNnTgFRQuiescing"), ("APPN-MIB", "appnNnTgFRDestHprTrans"), ("APPN-MIB", "appnNnTgFREntryTimeLeft"), ("APPN-MIB", "appnNnNodeFRInterchangeSup"), ("APPN-MIB", "appnNnNodeFRQuiescing"), ("APPN-MIB", "appnNnNodeFRCentralDirectory"), ("APPN-MIB", "appnNnTopoTgPurges"), ("APPN-MIB", "appnNnNodeFRGateway"), ("APPN-MIB", "appnNnNodeFRHprSupport"), ("APPN-MIB", "appnNnNodeFRPeriBorderSup"), ("APPN-MIB", "appnNnTopoMaxNodes"), ("APPN-MIB", "appnNnTgFRByteCost"), ("APPN-MIB", "appnNnTgFRCpCpSession"), ("APPN-MIB", "appnNnTopoNodePurges"), ("APPN-MIB", "appnNnTopoTotalTduWars"), ("APPN-MIB", "appnNnNodeFREntryTimeLeft"), ("APPN-MIB", "appnNnNodeFRBranchAwareness"), ("APPN-MIB", "appnNnTgFRIntersubnet"), ("APPN-MIB", "appnNnNodeFRCongested"), ("APPN-MIB", "appnNnNodeFRExteBorderSup"), )
appnLocalEnTopoConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 10)).setObjects(("APPN-MIB", "appnLocalEnTgDestVirtual"), ("APPN-MIB", "appnLocalEnTgDlcData"), ("APPN-MIB", "appnLocalEnTgUsr3"), ("APPN-MIB", "appnLocalEnTgUsr2"), ("APPN-MIB", "appnLocalEnTgUsr1"), ("APPN-MIB", "appnLocalEnTgEffCap"), ("APPN-MIB", "appnLocalEnTgByteCost"), ("APPN-MIB", "appnLocalEnTgDelay"), ("APPN-MIB", "appnLocalEnTgOperational"), ("APPN-MIB", "appnLocalEnTgCpCpSession"), ("APPN-MIB", "appnLocalEnTgConnCost"), ("APPN-MIB", "appnLocalEnTgEntryTimeLeft"), ("APPN-MIB", "appnLocalEnTgSecurity"), )
appnDirTableConfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 29)).setObjects(("APPN-MIB", "appnDirType"), ("APPN-MIB", "appnDirNnServerName"), ("APPN-MIB", "appnDirApparentLuOwnerName"), ("APPN-MIB", "appnDirLuOwnerName"), ("APPN-MIB", "appnDirLuLocation"), )
appnHprBaseConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 14)).setObjects(("APPN-MIB", "appnNodeHprIntRteRejects"), ("APPN-MIB", "appnLsRevAnrLabel"), ("APPN-MIB", "appnLsErrRecoSup"), ("APPN-MIB", "appnNodeHprIntRteSetups"), ("APPN-MIB", "appnLsForAnrLabel"), )
appnTrapConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 18)).setObjects(("APPN-MIB", "alertIdNumber"), ("APPN-MIB", "affectedObject"), )
appnIntSessConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 13)).setObjects(("APPN-MIB", "appnIsInGlobeCtrOperStatus"), ("APPN-MIB", "appnIsInSsAdjCpName"), ("APPN-MIB", "appnIsInGlobeCtrStatusTime"), ("APPN-MIB", "appnIsInP2SNonFmdPius"), ("APPN-MIB", "appnIsInP2SFmdBytes"), ("APPN-MIB", "appnIsInSecLuName"), ("APPN-MIB", "appnIsInP2SNonFmdBytes"), ("APPN-MIB", "appnIsInPsSendPacingType"), ("APPN-MIB", "appnIsInModeName"), ("APPN-MIB", "appnIsInPsRecvNxWndwSize"), ("APPN-MIB", "appnIsInSsRecvPacingType"), ("APPN-MIB", "appnIsInS2PNonFmdPius"), ("APPN-MIB", "appnIsInSsSendNxWndwSize"), ("APPN-MIB", "appnIsInGlobeRscvTime"), ("APPN-MIB", "appnIsInPsRecvRpc"), ("APPN-MIB", "appnIsInPsSendNxWndwSize"), ("APPN-MIB", "appnIsInPsRecvPacingType"), ("APPN-MIB", "appnIsInCosName"), ("APPN-MIB", "appnIsInSessUpTime"), ("APPN-MIB", "appnIsInSsSendRpc"), ("APPN-MIB", "appnIsInGlobeRscv"), ("APPN-MIB", "appnIsInRouteInfo"), ("APPN-MIB", "appnIsInTransPriority"), ("APPN-MIB", "appnIsInGlobeActSess"), ("APPN-MIB", "appnIsInSessType"), ("APPN-MIB", "appnIsInGlobeCtrAdminStatus"), ("APPN-MIB", "appnIsInSsRecvRpc"), ("APPN-MIB", "appnIsInSsAdjTgNum"), ("APPN-MIB", "appnIsInPriLuName"), ("APPN-MIB", "appnIsInPsSendMaxBtuSize"), ("APPN-MIB", "appnIsInCtrUpTime"), ("APPN-MIB", "appnIsInP2SFmdPius"), ("APPN-MIB", "appnIsInS2PNonFmdBytes"), ("APPN-MIB", "appnIsInS2PFmdBytes"), ("APPN-MIB", "appnIsInS2PFmdPius"), ("APPN-MIB", "appnIsInSsRecvNxWndwSize"), ("APPN-MIB", "appnIsInPsSendRpc"), ("APPN-MIB", "appnIsInSsSendPacingType"), ("APPN-MIB", "appnIsInPsAdjTgNum"), ("APPN-MIB", "appnIsInSsSendMaxBtuSize"), ("APPN-MIB", "appnIsInSessState"), ("APPN-MIB", "appnIsInPsAdjCpName"), )
appnHprRtpConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 15)).setObjects(("APPN-MIB", "appnNodeHprOrgRteRejects"), ("APPN-MIB", "appnNodeHprOrgRteSetups"), ("APPN-MIB", "appnLsBfNceId"), ("APPN-MIB", "appnNodeHprEndRteRejects"), ("APPN-MIB", "appnNodeHprEndRteSetups"), ("APPN-MIB", "appnNodeMaxSessPerRtpConn"), )
appnBrNnConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 20)).setObjects(("APPN-MIB", "appnNodeEnLuSearch"), ("APPN-MIB", "appnLocalTgBranchLinkType"), ("APPN-MIB", "appnNodeEnNnServer"), )
appnLinkConfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 27)).setObjects(("APPN-MIB", "appnLsOutXidBytes"), ("APPN-MIB", "appnLsMltgMember"), ("APPN-MIB", "appnLsBadXids"), ("APPN-MIB", "appnLsMaxDelay"), ("APPN-MIB", "appnLsCurrentStateTime"), ("APPN-MIB", "appnLsCurrentDelay"), ("APPN-MIB", "appnLsStatusXidLocalSense"), ("APPN-MIB", "appnLsStatusEndSense"), ("APPN-MIB", "appnLsStatusPartnerId"), ("APPN-MIB", "appnLsLocalAddr"), ("APPN-MIB", "appnLsRemoteAddr"), ("APPN-MIB", "appnLsStatusLsName"), ("APPN-MIB", "appnLsRemoteLsName"), ("APPN-MIB", "appnLsMigration"), ("APPN-MIB", "appnLsStatusRemoteAddr"), ("APPN-MIB", "appnLsCounterDisconTime"), ("APPN-MIB", "appnLsLimResource"), ("APPN-MIB", "appnLsPartnerNodeId"), ("APPN-MIB", "appnLsOperState"), ("APPN-MIB", "appnLsStatusTime"), ("APPN-MIB", "appnLsStatusTgNum"), ("APPN-MIB", "appnLsMaxDelayTime"), ("APPN-MIB", "appnLsOutXidFrames"), ("APPN-MIB", "appnLsActiveTime"), ("APPN-MIB", "appnLsStatusXidBitInError"), ("APPN-MIB", "appnLsAdjCpName"), ("APPN-MIB", "appnLsStatusXidRemoteSense"), ("APPN-MIB", "appnLsMinDelay"), ("APPN-MIB", "appnLsStatusRetry"), ("APPN-MIB", "appnLsAdjNodeType"), ("APPN-MIB", "appnLsStatusLocalAddr"), ("APPN-MIB", "appnLsCpCpSessionSupport"), ("APPN-MIB", "appnLsInXidBytes"), ("APPN-MIB", "appnLsStatusCpName"), ("APPN-MIB", "appnLsInXidFrames"), ("APPN-MIB", "appnLsMaxSendBtuSize"), ("APPN-MIB", "appnLsEchoRsps"), ("APPN-MIB", "appnLsCommand"), ("APPN-MIB", "appnLsHprSup"), ("APPN-MIB", "appnLsSpecific"), ("APPN-MIB", "appnLsStatusDlcType"), ("APPN-MIB", "appnLsDynamic"), ("APPN-MIB", "appnLsTgNum"), ("APPN-MIB", "appnLsStatusXidByteInError"), ("APPN-MIB", "appnLsStatusGeneralSense"), ("APPN-MIB", "appnLsInMsgBytes"), ("APPN-MIB", "appnLsDlcType"), ("APPN-MIB", "appnLsActOnDemand"), ("APPN-MIB", "appnLsInMsgFrames"), ("APPN-MIB", "appnLsOutMsgBytes"), ("APPN-MIB", "appnLsPortName"), ("APPN-MIB", "appnLsOutMsgFrames"), ("APPN-MIB", "appnLsGoodXids"), )
appnLocalEnTopoConfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 31)).setObjects(("APPN-MIB", "appnLocalEnTgDestVirtual"), ("APPN-MIB", "appnLocalEnTgMltgLinkType"), ("APPN-MIB", "appnLocalEnTgDlcData"), ("APPN-MIB", "appnLocalEnTgUsr3"), ("APPN-MIB", "appnLocalEnTgUsr2"), ("APPN-MIB", "appnLocalEnTgUsr1"), ("APPN-MIB", "appnLocalEnTgEffCap"), ("APPN-MIB", "appnLocalEnTgByteCost"), ("APPN-MIB", "appnLocalEnTgDelay"), ("APPN-MIB", "appnLocalEnTgOperational"), ("APPN-MIB", "appnLocalEnTgCpCpSession"), ("APPN-MIB", "appnLocalEnTgConnCost"), ("APPN-MIB", "appnLocalEnTgEntryTimeLeft"), ("APPN-MIB", "appnLocalEnTgSecurity"), )
appnPortConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 2)).setObjects(("APPN-MIB", "appnPortMaxIframeWindow"), ("APPN-MIB", "appnPortOperState"), ("APPN-MIB", "appnPortCommand"), ("APPN-MIB", "appnPortLsRole"), ("APPN-MIB", "appnPortSIMRIM"), ("APPN-MIB", "appnPortDynamicLinkSupport"), ("APPN-MIB", "appnPortDlcType"), ("APPN-MIB", "appnPortDynLsBadXids"), ("APPN-MIB", "appnPortDefLsGoodXids"), ("APPN-MIB", "appnPortNegotLs"), ("APPN-MIB", "appnPortSpecific"), ("APPN-MIB", "appnPortDefLsBadXids"), ("APPN-MIB", "appnPortPortType"), ("APPN-MIB", "appnPortMaxRcvBtuSize"), ("APPN-MIB", "appnPortDlcLocalAddr"), ("APPN-MIB", "appnPortDynLsGoodXids"), ("APPN-MIB", "appnPortCounterDisconTime"), )
appnDirTableConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 5)).setObjects(("APPN-MIB", "appnDirType"), ("APPN-MIB", "appnDirNnServerName"), ("APPN-MIB", "appnDirLuOwnerName"), ("APPN-MIB", "appnDirLuLocation"), )
appnLocalDirPerfConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 11)).setObjects(("APPN-MIB", "appnDirNotFoundLocates"), ("APPN-MIB", "appnDirInBcastLocates"), ("APPN-MIB", "appnDirCurHomeEntries"), ("APPN-MIB", "appnDirInLocates"), ("APPN-MIB", "appnDirMaxCaches"), ("APPN-MIB", "appnDirRegEntries"), ("APPN-MIB", "appnDirNotFoundBcastLocates"), ("APPN-MIB", "appnDirCurCaches"), ("APPN-MIB", "appnDirLocateOutstands"), ("APPN-MIB", "appnDirOutBcastLocates"), ("APPN-MIB", "appnDirOutLocates"), )
appnHprBfConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 17)).setObjects(("APPN-MIB", "appnIsInGlobeHprBfActSess"), ("APPN-MIB", "appnIsRtpSessions"), ("APPN-MIB", "appnIsInRtpTcid"), ("APPN-MIB", "appnIsInRtpNceId"), )
appnLinkConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 3)).setObjects(("APPN-MIB", "appnLsOutXidBytes"), ("APPN-MIB", "appnLsBadXids"), ("APPN-MIB", "appnLsMaxDelay"), ("APPN-MIB", "appnLsCurrentStateTime"), ("APPN-MIB", "appnLsCurrentDelay"), ("APPN-MIB", "appnLsStatusXidLocalSense"), ("APPN-MIB", "appnLsStatusEndSense"), ("APPN-MIB", "appnLsStatusPartnerId"), ("APPN-MIB", "appnLsLocalAddr"), ("APPN-MIB", "appnLsRemoteAddr"), ("APPN-MIB", "appnLsStatusLsName"), ("APPN-MIB", "appnLsRemoteLsName"), ("APPN-MIB", "appnLsMigration"), ("APPN-MIB", "appnLsStatusRemoteAddr"), ("APPN-MIB", "appnLsCounterDisconTime"), ("APPN-MIB", "appnLsLimResource"), ("APPN-MIB", "appnLsPartnerNodeId"), ("APPN-MIB", "appnLsOperState"), ("APPN-MIB", "appnLsStatusTime"), ("APPN-MIB", "appnLsStatusTgNum"), ("APPN-MIB", "appnLsMaxDelayTime"), ("APPN-MIB", "appnLsOutXidFrames"), ("APPN-MIB", "appnLsActiveTime"), ("APPN-MIB", "appnLsStatusXidBitInError"), ("APPN-MIB", "appnLsAdjCpName"), ("APPN-MIB", "appnLsStatusXidRemoteSense"), ("APPN-MIB", "appnLsMinDelay"), ("APPN-MIB", "appnLsStatusRetry"), ("APPN-MIB", "appnLsAdjNodeType"), ("APPN-MIB", "appnLsStatusLocalAddr"), ("APPN-MIB", "appnLsCpCpSessionSupport"), ("APPN-MIB", "appnLsInXidBytes"), ("APPN-MIB", "appnLsStatusCpName"), ("APPN-MIB", "appnLsInXidFrames"), ("APPN-MIB", "appnLsMaxSendBtuSize"), ("APPN-MIB", "appnLsEchoRsps"), ("APPN-MIB", "appnLsCommand"), ("APPN-MIB", "appnLsHprSup"), ("APPN-MIB", "appnLsSpecific"), ("APPN-MIB", "appnLsStatusDlcType"), ("APPN-MIB", "appnLsDynamic"), ("APPN-MIB", "appnLsTgNum"), ("APPN-MIB", "appnLsStatusXidByteInError"), ("APPN-MIB", "appnLsStatusGeneralSense"), ("APPN-MIB", "appnLsInMsgBytes"), ("APPN-MIB", "appnLsDlcType"), ("APPN-MIB", "appnLsActOnDemand"), ("APPN-MIB", "appnLsInMsgFrames"), ("APPN-MIB", "appnLsOutMsgBytes"), ("APPN-MIB", "appnLsPortName"), ("APPN-MIB", "appnLsOutMsgFrames"), ("APPN-MIB", "appnLsGoodXids"), )
appnLocalTgConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 4)).setObjects(("APPN-MIB", "appnLocalTgOperational"), ("APPN-MIB", "appnLocalTgQuiescing"), ("APPN-MIB", "appnLocalTgPortName"), ("APPN-MIB", "appnLocalTgUsr3"), ("APPN-MIB", "appnLocalTgIntersubnet"), ("APPN-MIB", "appnLocalTgDlcData"), ("APPN-MIB", "appnLocalTgEffCap"), ("APPN-MIB", "appnLocalTgUsr2"), ("APPN-MIB", "appnLocalTgConnCost"), ("APPN-MIB", "appnLocalTgHprSup"), ("APPN-MIB", "appnLocalTgByteCost"), ("APPN-MIB", "appnLocalTgDestVirtual"), ("APPN-MIB", "appnLocalTgCpCpSession"), ("APPN-MIB", "appnLocalTgSecurity"), ("APPN-MIB", "appnLocalTgDelay"), ("APPN-MIB", "appnLocalTgUsr1"), )
appnNnUniqueConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 6)).setObjects(("APPN-MIB", "appnNodeNnSafeStoreFreq"), ("APPN-MIB", "appnNodeNnIsr"), ("APPN-MIB", "appnNodeNnTreeCache"), ("APPN-MIB", "appnNodeNnCentralDirectory"), ("APPN-MIB", "appnNodeNnIsrDepleted"), ("APPN-MIB", "appnNodeNnGateway"), ("APPN-MIB", "appnNodeNnRsn"), ("APPN-MIB", "appnNodeNnInterchangeSup"), ("APPN-MIB", "appnNodeNnFrsn"), ("APPN-MIB", "appnNodeNnPeriBorderSup"), ("APPN-MIB", "appnNodeNnCongested"), ("APPN-MIB", "appnNodeNnRouteAddResist"), ("APPN-MIB", "appnNodeNnExteBorderSup"), ("APPN-MIB", "appnNodeNnQuiescing"), )
appnHprCtrlFlowsRtpConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 16)).setObjects(("APPN-MIB", "appnLsCpCpNceId"), ("APPN-MIB", "appnLsRouteNceId"), )

# Exports

# Module identity
mibBuilder.exportSymbols("APPN-MIB", PYSNMP_MODULE_ID=appnMIB)

# Types
mibBuilder.exportSymbols("APPN-MIB", AppnLinkStationCounter=AppnLinkStationCounter, AppnNodeCounter=AppnNodeCounter, AppnPortCounter=AppnPortCounter, AppnTgDelay=AppnTgDelay, AppnTgDlcData=AppnTgDlcData, AppnTgEffectiveCapacity=AppnTgEffectiveCapacity, AppnTgSecurity=AppnTgSecurity, AppnTopologyEntryTimeLeft=AppnTopologyEntryTimeLeft, DisplayableDlcAddress=DisplayableDlcAddress, SnaClassOfServiceName=SnaClassOfServiceName, SnaControlPointName=SnaControlPointName, SnaModeName=SnaModeName, SnaNodeIdentification=SnaNodeIdentification, SnaSenseData=SnaSenseData)

# Objects
mibBuilder.exportSymbols("APPN-MIB", appnMIB=appnMIB, appnObjects=appnObjects, appnNode=appnNode, appnGeneralInfoAndCaps=appnGeneralInfoAndCaps, appnNodeCpName=appnNodeCpName, appnNodeMibVersion=appnNodeMibVersion, appnNodeId=appnNodeId, appnNodeType=appnNodeType, appnNodeUpTime=appnNodeUpTime, appnNodeParallelTg=appnNodeParallelTg, appnNodeAdaptiveBindPacing=appnNodeAdaptiveBindPacing, appnNodeHprSupport=appnNodeHprSupport, appnNodeMaxSessPerRtpConn=appnNodeMaxSessPerRtpConn, appnNodeHprIntRteSetups=appnNodeHprIntRteSetups, appnNodeHprIntRteRejects=appnNodeHprIntRteRejects, appnNodeHprOrgRteSetups=appnNodeHprOrgRteSetups, appnNodeHprOrgRteRejects=appnNodeHprOrgRteRejects, appnNodeHprEndRteSetups=appnNodeHprEndRteSetups, appnNodeHprEndRteRejects=appnNodeHprEndRteRejects, appnNodeCounterDisconTime=appnNodeCounterDisconTime, appnNodeLsCounterType=appnNodeLsCounterType, appnNodeBrNn=appnNodeBrNn, appnNnUniqueInfoAndCaps=appnNnUniqueInfoAndCaps, appnNodeNnCentralDirectory=appnNodeNnCentralDirectory, appnNodeNnTreeCache=appnNodeNnTreeCache, appnNodeNnRouteAddResist=appnNodeNnRouteAddResist, appnNodeNnIsr=appnNodeNnIsr, appnNodeNnFrsn=appnNodeNnFrsn, appnNodeNnPeriBorderSup=appnNodeNnPeriBorderSup, appnNodeNnInterchangeSup=appnNodeNnInterchangeSup, appnNodeNnExteBorderSup=appnNodeNnExteBorderSup, appnNodeNnSafeStoreFreq=appnNodeNnSafeStoreFreq, appnNodeNnRsn=appnNodeNnRsn, appnNodeNnCongested=appnNodeNnCongested, appnNodeNnIsrDepleted=appnNodeNnIsrDepleted, appnNodeNnQuiescing=appnNodeNnQuiescing, appnNodeNnGateway=appnNodeNnGateway, appnEnUniqueCaps=appnEnUniqueCaps, appnNodeEnModeCosMap=appnNodeEnModeCosMap, appnNodeEnNnServer=appnNodeEnNnServer, appnNodeEnLuSearch=appnNodeEnLuSearch, appnPortInformation=appnPortInformation, appnPortTable=appnPortTable, appnPortEntry=appnPortEntry, appnPortName=appnPortName, appnPortCommand=appnPortCommand, appnPortOperState=appnPortOperState, appnPortDlcType=appnPortDlcType, appnPortPortType=appnPortPortType, appnPortSIMRIM=appnPortSIMRIM, appnPortLsRole=appnPortLsRole, appnPortNegotLs=appnPortNegotLs, appnPortDynamicLinkSupport=appnPortDynamicLinkSupport, appnPortMaxRcvBtuSize=appnPortMaxRcvBtuSize, appnPortMaxIframeWindow=appnPortMaxIframeWindow, appnPortDefLsGoodXids=appnPortDefLsGoodXids, appnPortDefLsBadXids=appnPortDefLsBadXids, appnPortDynLsGoodXids=appnPortDynLsGoodXids, appnPortDynLsBadXids=appnPortDynLsBadXids, appnPortSpecific=appnPortSpecific, appnPortDlcLocalAddr=appnPortDlcLocalAddr, appnPortCounterDisconTime=appnPortCounterDisconTime, appnLinkStationInformation=appnLinkStationInformation, appnLsTable=appnLsTable, appnLsEntry=appnLsEntry, appnLsName=appnLsName, appnLsCommand=appnLsCommand, appnLsOperState=appnLsOperState, appnLsPortName=appnLsPortName, appnLsDlcType=appnLsDlcType, appnLsDynamic=appnLsDynamic, appnLsAdjCpName=appnLsAdjCpName, appnLsAdjNodeType=appnLsAdjNodeType, appnLsTgNum=appnLsTgNum, appnLsLimResource=appnLsLimResource, appnLsActOnDemand=appnLsActOnDemand, appnLsMigration=appnLsMigration, appnLsPartnerNodeId=appnLsPartnerNodeId, appnLsCpCpSessionSupport=appnLsCpCpSessionSupport, appnLsMaxSendBtuSize=appnLsMaxSendBtuSize, appnLsInXidBytes=appnLsInXidBytes, appnLsInMsgBytes=appnLsInMsgBytes, appnLsInXidFrames=appnLsInXidFrames, appnLsInMsgFrames=appnLsInMsgFrames, appnLsOutXidBytes=appnLsOutXidBytes, appnLsOutMsgBytes=appnLsOutMsgBytes, appnLsOutXidFrames=appnLsOutXidFrames, appnLsOutMsgFrames=appnLsOutMsgFrames, appnLsEchoRsps=appnLsEchoRsps, appnLsCurrentDelay=appnLsCurrentDelay, appnLsMaxDelay=appnLsMaxDelay, appnLsMinDelay=appnLsMinDelay, appnLsMaxDelayTime=appnLsMaxDelayTime, appnLsGoodXids=appnLsGoodXids, appnLsBadXids=appnLsBadXids, appnLsSpecific=appnLsSpecific, appnLsActiveTime=appnLsActiveTime, appnLsCurrentStateTime=appnLsCurrentStateTime, appnLsHprSup=appnLsHprSup, appnLsErrRecoSup=appnLsErrRecoSup, appnLsForAnrLabel=appnLsForAnrLabel, appnLsRevAnrLabel=appnLsRevAnrLabel, appnLsCpCpNceId=appnLsCpCpNceId, appnLsRouteNceId=appnLsRouteNceId, appnLsBfNceId=appnLsBfNceId, appnLsLocalAddr=appnLsLocalAddr, appnLsRemoteAddr=appnLsRemoteAddr, appnLsRemoteLsName=appnLsRemoteLsName, appnLsCounterDisconTime=appnLsCounterDisconTime, appnLsMltgMember=appnLsMltgMember, appnLsStatusTable=appnLsStatusTable, appnLsStatusEntry=appnLsStatusEntry, appnLsStatusIndex=appnLsStatusIndex, appnLsStatusTime=appnLsStatusTime, appnLsStatusLsName=appnLsStatusLsName, appnLsStatusCpName=appnLsStatusCpName, appnLsStatusPartnerId=appnLsStatusPartnerId, appnLsStatusTgNum=appnLsStatusTgNum, appnLsStatusGeneralSense=appnLsStatusGeneralSense, appnLsStatusRetry=appnLsStatusRetry, appnLsStatusEndSense=appnLsStatusEndSense, appnLsStatusXidLocalSense=appnLsStatusXidLocalSense, appnLsStatusXidRemoteSense=appnLsStatusXidRemoteSense, appnLsStatusXidByteInError=appnLsStatusXidByteInError, appnLsStatusXidBitInError=appnLsStatusXidBitInError, appnLsStatusDlcType=appnLsStatusDlcType)
mibBuilder.exportSymbols("APPN-MIB", appnLsStatusLocalAddr=appnLsStatusLocalAddr, appnLsStatusRemoteAddr=appnLsStatusRemoteAddr, appnVrnInfo=appnVrnInfo, appnVrnTable=appnVrnTable, appnVrnEntry=appnVrnEntry, appnVrnName=appnVrnName, appnVrnTgNum=appnVrnTgNum, appnVrnPortName=appnVrnPortName, appnNn=appnNn, appnNnTopo=appnNnTopo, appnNnTopoMaxNodes=appnNnTopoMaxNodes, appnNnTopoCurNumNodes=appnNnTopoCurNumNodes, appnNnTopoNodePurges=appnNnTopoNodePurges, appnNnTopoTgPurges=appnNnTopoTgPurges, appnNnTopoTotalTduWars=appnNnTopoTotalTduWars, appnNnTopology=appnNnTopology, appnNnTopologyFRTable=appnNnTopologyFRTable, appnNnTopologyFREntry=appnNnTopologyFREntry, appnNnNodeFRFrsn=appnNnNodeFRFrsn, appnNnNodeFRName=appnNnNodeFRName, appnNnNodeFREntryTimeLeft=appnNnNodeFREntryTimeLeft, appnNnNodeFRType=appnNnNodeFRType, appnNnNodeFRRsn=appnNnNodeFRRsn, appnNnNodeFRRouteAddResist=appnNnNodeFRRouteAddResist, appnNnNodeFRCongested=appnNnNodeFRCongested, appnNnNodeFRIsrDepleted=appnNnNodeFRIsrDepleted, appnNnNodeFRQuiescing=appnNnNodeFRQuiescing, appnNnNodeFRGateway=appnNnNodeFRGateway, appnNnNodeFRCentralDirectory=appnNnNodeFRCentralDirectory, appnNnNodeFRIsr=appnNnNodeFRIsr, appnNnNodeFRGarbageCollect=appnNnNodeFRGarbageCollect, appnNnNodeFRHprSupport=appnNnNodeFRHprSupport, appnNnNodeFRPeriBorderSup=appnNnNodeFRPeriBorderSup, appnNnNodeFRInterchangeSup=appnNnNodeFRInterchangeSup, appnNnNodeFRExteBorderSup=appnNnNodeFRExteBorderSup, appnNnNodeFRBranchAwareness=appnNnNodeFRBranchAwareness, appnNnTgTopologyFRTable=appnNnTgTopologyFRTable, appnNnTgTopologyFREntry=appnNnTgTopologyFREntry, appnNnTgFRFrsn=appnNnTgFRFrsn, appnNnTgFROwner=appnNnTgFROwner, appnNnTgFRDest=appnNnTgFRDest, appnNnTgFRNum=appnNnTgFRNum, appnNnTgFREntryTimeLeft=appnNnTgFREntryTimeLeft, appnNnTgFRDestVirtual=appnNnTgFRDestVirtual, appnNnTgFRDlcData=appnNnTgFRDlcData, appnNnTgFRRsn=appnNnTgFRRsn, appnNnTgFROperational=appnNnTgFROperational, appnNnTgFRQuiescing=appnNnTgFRQuiescing, appnNnTgFRCpCpSession=appnNnTgFRCpCpSession, appnNnTgFREffCap=appnNnTgFREffCap, appnNnTgFRConnCost=appnNnTgFRConnCost, appnNnTgFRByteCost=appnNnTgFRByteCost, appnNnTgFRSecurity=appnNnTgFRSecurity, appnNnTgFRDelay=appnNnTgFRDelay, appnNnTgFRUsr1=appnNnTgFRUsr1, appnNnTgFRUsr2=appnNnTgFRUsr2, appnNnTgFRUsr3=appnNnTgFRUsr3, appnNnTgFRGarbageCollect=appnNnTgFRGarbageCollect, appnNnTgFRSubareaNum=appnNnTgFRSubareaNum, appnNnTgFRHprSup=appnNnTgFRHprSup, appnNnTgFRDestHprTrans=appnNnTgFRDestHprTrans, appnNnTgFRTypeIndicator=appnNnTgFRTypeIndicator, appnNnTgFRIntersubnet=appnNnTgFRIntersubnet, appnNnTgFRMltgLinkType=appnNnTgFRMltgLinkType, appnNnTgFRBranchTg=appnNnTgFRBranchTg, appnLocalTopology=appnLocalTopology, appnLocalTgTable=appnLocalTgTable, appnLocalTgEntry=appnLocalTgEntry, appnLocalTgDest=appnLocalTgDest, appnLocalTgNum=appnLocalTgNum, appnLocalTgDestVirtual=appnLocalTgDestVirtual, appnLocalTgDlcData=appnLocalTgDlcData, appnLocalTgPortName=appnLocalTgPortName, appnLocalTgQuiescing=appnLocalTgQuiescing, appnLocalTgOperational=appnLocalTgOperational, appnLocalTgCpCpSession=appnLocalTgCpCpSession, appnLocalTgEffCap=appnLocalTgEffCap, appnLocalTgConnCost=appnLocalTgConnCost, appnLocalTgByteCost=appnLocalTgByteCost, appnLocalTgSecurity=appnLocalTgSecurity, appnLocalTgDelay=appnLocalTgDelay, appnLocalTgUsr1=appnLocalTgUsr1, appnLocalTgUsr2=appnLocalTgUsr2, appnLocalTgUsr3=appnLocalTgUsr3, appnLocalTgHprSup=appnLocalTgHprSup, appnLocalTgIntersubnet=appnLocalTgIntersubnet, appnLocalTgMltgLinkType=appnLocalTgMltgLinkType, appnLocalTgBranchLinkType=appnLocalTgBranchLinkType, appnLocalEnTgTable=appnLocalEnTgTable, appnLocalEnTgEntry=appnLocalEnTgEntry, appnLocalEnTgOrigin=appnLocalEnTgOrigin, appnLocalEnTgDest=appnLocalEnTgDest, appnLocalEnTgNum=appnLocalEnTgNum, appnLocalEnTgEntryTimeLeft=appnLocalEnTgEntryTimeLeft, appnLocalEnTgDestVirtual=appnLocalEnTgDestVirtual, appnLocalEnTgDlcData=appnLocalEnTgDlcData, appnLocalEnTgOperational=appnLocalEnTgOperational, appnLocalEnTgCpCpSession=appnLocalEnTgCpCpSession, appnLocalEnTgEffCap=appnLocalEnTgEffCap, appnLocalEnTgConnCost=appnLocalEnTgConnCost, appnLocalEnTgByteCost=appnLocalEnTgByteCost, appnLocalEnTgSecurity=appnLocalEnTgSecurity, appnLocalEnTgDelay=appnLocalEnTgDelay, appnLocalEnTgUsr1=appnLocalEnTgUsr1, appnLocalEnTgUsr2=appnLocalEnTgUsr2, appnLocalEnTgUsr3=appnLocalEnTgUsr3, appnLocalEnTgMltgLinkType=appnLocalEnTgMltgLinkType, appnDir=appnDir, appnDirPerf=appnDirPerf, appnDirMaxCaches=appnDirMaxCaches, appnDirCurCaches=appnDirCurCaches, appnDirCurHomeEntries=appnDirCurHomeEntries, appnDirRegEntries=appnDirRegEntries, appnDirInLocates=appnDirInLocates, appnDirInBcastLocates=appnDirInBcastLocates, appnDirOutLocates=appnDirOutLocates, appnDirOutBcastLocates=appnDirOutBcastLocates, appnDirNotFoundLocates=appnDirNotFoundLocates, appnDirNotFoundBcastLocates=appnDirNotFoundBcastLocates, appnDirLocateOutstands=appnDirLocateOutstands, appnDirTable=appnDirTable, appnDirEntry=appnDirEntry, appnDirLuName=appnDirLuName, appnDirNnServerName=appnDirNnServerName, appnDirLuOwnerName=appnDirLuOwnerName, appnDirLuLocation=appnDirLuLocation, appnDirType=appnDirType)
mibBuilder.exportSymbols("APPN-MIB", appnDirApparentLuOwnerName=appnDirApparentLuOwnerName, appnCos=appnCos, appnCosModeTable=appnCosModeTable, appnCosModeEntry=appnCosModeEntry, appnCosModeName=appnCosModeName, appnCosModeCosName=appnCosModeCosName, appnCosNameTable=appnCosNameTable, appnCosNameEntry=appnCosNameEntry, appnCosName=appnCosName, appnCosTransPriority=appnCosTransPriority, appnCosNodeRowTable=appnCosNodeRowTable, appnCosNodeRowEntry=appnCosNodeRowEntry, appnCosNodeRowName=appnCosNodeRowName, appnCosNodeRowIndex=appnCosNodeRowIndex, appnCosNodeRowWgt=appnCosNodeRowWgt, appnCosNodeRowResistMin=appnCosNodeRowResistMin, appnCosNodeRowResistMax=appnCosNodeRowResistMax, appnCosNodeRowMinCongestAllow=appnCosNodeRowMinCongestAllow, appnCosNodeRowMaxCongestAllow=appnCosNodeRowMaxCongestAllow, appnCosTgRowTable=appnCosTgRowTable, appnCosTgRowEntry=appnCosTgRowEntry, appnCosTgRowName=appnCosTgRowName, appnCosTgRowIndex=appnCosTgRowIndex, appnCosTgRowWgt=appnCosTgRowWgt, appnCosTgRowEffCapMin=appnCosTgRowEffCapMin, appnCosTgRowEffCapMax=appnCosTgRowEffCapMax, appnCosTgRowConnCostMin=appnCosTgRowConnCostMin, appnCosTgRowConnCostMax=appnCosTgRowConnCostMax, appnCosTgRowByteCostMin=appnCosTgRowByteCostMin, appnCosTgRowByteCostMax=appnCosTgRowByteCostMax, appnCosTgRowSecurityMin=appnCosTgRowSecurityMin, appnCosTgRowSecurityMax=appnCosTgRowSecurityMax, appnCosTgRowDelayMin=appnCosTgRowDelayMin, appnCosTgRowDelayMax=appnCosTgRowDelayMax, appnCosTgRowUsr1Min=appnCosTgRowUsr1Min, appnCosTgRowUsr1Max=appnCosTgRowUsr1Max, appnCosTgRowUsr2Min=appnCosTgRowUsr2Min, appnCosTgRowUsr2Max=appnCosTgRowUsr2Max, appnCosTgRowUsr3Min=appnCosTgRowUsr3Min, appnCosTgRowUsr3Max=appnCosTgRowUsr3Max, appnSessIntermediate=appnSessIntermediate, appnIsInGlobal=appnIsInGlobal, appnIsInGlobeCtrAdminStatus=appnIsInGlobeCtrAdminStatus, appnIsInGlobeCtrOperStatus=appnIsInGlobeCtrOperStatus, appnIsInGlobeCtrStatusTime=appnIsInGlobeCtrStatusTime, appnIsInGlobeRscv=appnIsInGlobeRscv, appnIsInGlobeRscvTime=appnIsInGlobeRscvTime, appnIsInGlobeActSess=appnIsInGlobeActSess, appnIsInGlobeHprBfActSess=appnIsInGlobeHprBfActSess, appnIsInTable=appnIsInTable, appnIsInEntry=appnIsInEntry, appnIsInFqCpName=appnIsInFqCpName, appnIsInPcid=appnIsInPcid, appnIsInSessState=appnIsInSessState, appnIsInPriLuName=appnIsInPriLuName, appnIsInSecLuName=appnIsInSecLuName, appnIsInModeName=appnIsInModeName, appnIsInCosName=appnIsInCosName, appnIsInTransPriority=appnIsInTransPriority, appnIsInSessType=appnIsInSessType, appnIsInSessUpTime=appnIsInSessUpTime, appnIsInCtrUpTime=appnIsInCtrUpTime, appnIsInP2SFmdPius=appnIsInP2SFmdPius, appnIsInS2PFmdPius=appnIsInS2PFmdPius, appnIsInP2SNonFmdPius=appnIsInP2SNonFmdPius, appnIsInS2PNonFmdPius=appnIsInS2PNonFmdPius, appnIsInP2SFmdBytes=appnIsInP2SFmdBytes, appnIsInS2PFmdBytes=appnIsInS2PFmdBytes, appnIsInP2SNonFmdBytes=appnIsInP2SNonFmdBytes, appnIsInS2PNonFmdBytes=appnIsInS2PNonFmdBytes, appnIsInPsAdjCpName=appnIsInPsAdjCpName, appnIsInPsAdjTgNum=appnIsInPsAdjTgNum, appnIsInPsSendMaxBtuSize=appnIsInPsSendMaxBtuSize, appnIsInPsSendPacingType=appnIsInPsSendPacingType, appnIsInPsSendRpc=appnIsInPsSendRpc, appnIsInPsSendNxWndwSize=appnIsInPsSendNxWndwSize, appnIsInPsRecvPacingType=appnIsInPsRecvPacingType, appnIsInPsRecvRpc=appnIsInPsRecvRpc, appnIsInPsRecvNxWndwSize=appnIsInPsRecvNxWndwSize, appnIsInSsAdjCpName=appnIsInSsAdjCpName, appnIsInSsAdjTgNum=appnIsInSsAdjTgNum, appnIsInSsSendMaxBtuSize=appnIsInSsSendMaxBtuSize, appnIsInSsSendPacingType=appnIsInSsSendPacingType, appnIsInSsSendRpc=appnIsInSsSendRpc, appnIsInSsSendNxWndwSize=appnIsInSsSendNxWndwSize, appnIsInSsRecvPacingType=appnIsInSsRecvPacingType, appnIsInSsRecvRpc=appnIsInSsRecvRpc, appnIsInSsRecvNxWndwSize=appnIsInSsRecvNxWndwSize, appnIsInRouteInfo=appnIsInRouteInfo, appnIsInRtpNceId=appnIsInRtpNceId, appnIsInRtpTcid=appnIsInRtpTcid, appnIsRtpTable=appnIsRtpTable, appnIsRtpEntry=appnIsRtpEntry, appnIsRtpNceId=appnIsRtpNceId, appnIsRtpTcid=appnIsRtpTcid, appnIsRtpSessions=appnIsRtpSessions, appnTraps=appnTraps, alertIdNumber=alertIdNumber, affectedObject=affectedObject, appnConformance=appnConformance, appnCompliances=appnCompliances, appnGroups=appnGroups)

# Notifications
mibBuilder.exportSymbols("APPN-MIB", alertTrap=alertTrap)

# Groups
mibBuilder.exportSymbols("APPN-MIB", appnTrapNotifGroup=appnTrapNotifGroup, appnGeneralConfGroup2=appnGeneralConfGroup2, appnLocalTgConfGroup2=appnLocalTgConfGroup2, appnCosConfGroup=appnCosConfGroup, appnEnUniqueConfGroup=appnEnUniqueConfGroup, appnNnTopoConfGroup=appnNnTopoConfGroup, appnGeneralConfGroup=appnGeneralConfGroup, appnVrnConfGroup=appnVrnConfGroup, appnNnTopoConfGroup2=appnNnTopoConfGroup2, appnLocalEnTopoConfGroup=appnLocalEnTopoConfGroup, appnDirTableConfGroup2=appnDirTableConfGroup2, appnHprBaseConfGroup=appnHprBaseConfGroup, appnTrapConfGroup=appnTrapConfGroup, appnIntSessConfGroup=appnIntSessConfGroup, appnHprRtpConfGroup=appnHprRtpConfGroup, appnBrNnConfGroup=appnBrNnConfGroup, appnLinkConfGroup2=appnLinkConfGroup2, appnLocalEnTopoConfGroup2=appnLocalEnTopoConfGroup2, appnPortConfGroup=appnPortConfGroup, appnDirTableConfGroup=appnDirTableConfGroup, appnLocalDirPerfConfGroup=appnLocalDirPerfConfGroup, appnHprBfConfGroup=appnHprBfConfGroup, appnLinkConfGroup=appnLinkConfGroup, appnLocalTgConfGroup=appnLocalTgConfGroup, appnNnUniqueConfGroup=appnNnUniqueConfGroup, appnHprCtrlFlowsRtpConfGroup=appnHprCtrlFlowsRtpConfGroup)
