from scikits.openopt import *
v0 = oovar('v0', [-4, -15]) # 2nd arg (if provided) is start value
v1 = oovar('v1', [1, 2], ub=[0.1, 0.2]) # ub is upper bound (optional)
v2 = oovar('v2', (3, 4), lb=[-2, 0], ub=[-1.5, 1]) # lb is lower bound (optional)

f0 = oofun(lambda z: z[0]**2 + z[0]  + 2*z[1]**2 , input = v0)
f1 = oofun(lambda z: (z-1).sum() ** 2, input = v1)
f2 = oofun(lambda z: z.sum() ** 2, input = v2)

f4 = oolin([1, 2, 3], input=[f0, f1, f2])
"""
this is same to
f4 = oofun(lambda z0, z1, z2: z0 + 2*z1 + 3*z2] , input = [f0, f1, f2], d = lambda x: [1,2,3])
or
f3 = oofun(lambda z0, z1, z2: [z0,  z1,  z2] , input = [f0, f1, f2])
f4 = oolin([1, 2, 3], input=f3)
"""

p = NLP(f4)
r = p.solve('ralg')
#r = p.solve('ipopt')
print 'solution:', r.xf
print 'optim value:', r.ff
"""
solution: {'v0': array([ -5.00000010e-01,  -8.98087407e-09]), 'v1': array([ 0.1,  0.2]), 'v2': array([-1.5,  1. ])}
optim value: 6.28
"""
