#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
DVER=$(dpkg-parsechangelog | egrep '^Version:' | cut -f 2 -d ' ' | sed 's/\-[^-]*$//')
TAR=python-scipy_$DVER.orig.tar.gz
DIR=scipy-$2.orig
SRC=https://github.com/scipy/scipy/raw/v$2

# extract upstream tar ball
tar xzf $3
mv scipy-$2 $DIR
rm $3

# add cython source files, should be unecessary for > 0.11 see ticket 1780
for f in \
scipy/sparse/sparsetools/numpy.i \
scipy/sparse/sparsetools/sparsetools.i \
scipy/sparse/sparsetools/dia.i \
scipy/sparse/sparsetools/csr.i \
scipy/sparse/sparsetools/csgraph.i \
scipy/sparse/sparsetools/csc.i \
scipy/sparse/sparsetools/coo.i \
scipy/sparse/sparsetools/bsr.i \
scipy/cluster/_vq_rewrite.pyx \
scipy/interpolate/interpnd.pyx.in \
scipy/io/matlab/mio5_utils.pyx \
scipy/io/matlab/mio_utils.pyx \
scipy/io/matlab/pyalloc.pxd \
scipy/io/matlab/streams.pxd \
scipy/io/matlab/streams.pyx \
scipy/signal/spectral.pyx \
scipy/sparse/csgraph/_min_spanning_tree.pyx \
scipy/sparse/csgraph/parameters.pxi \
scipy/sparse/csgraph/_shortest_path.pyx \
scipy/sparse/csgraph/_tools.pyx \
scipy/sparse/csgraph/_traversal.pyx \
scipy/spatial/ckdtree.pyx \
scipy/spatial/qhull.pxd \
scipy/spatial/qhull.pyx \
scipy/special/lambertw.pyx \
scipy/special/orthogonal_eval.pyx \
scipy/stats/_rank.pyx \
scipy/stats/vonmises_cython.pyx; do
echo $f
(cd $DIR/$(dirname $f);\
wget $SRC/$f)
done

# create tar ball
GZIP=--best tar czf $TAR $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi
