#!/usr/bin/env python
""" bank10: Simulate customers arriving
    at random, using a Source, requesting service
    from two counters each with their own queue
    random servicetime
"""
from __future__ import generators
from SimPy.Simulation  import *
from random import Random

class Source(Process):
    """ Source generates customers randomly"""
    def __init__(self,seed=333):
        Process.__init__(self)
        self.SEED = seed

    def generate(self,number,interval):       
        rv = Random(self.SEED)
        for i in range(number):
            c = Customer(name = "Customer%02d"%(i,))
            activate(c,c.visit(timeInBank=12.0))
            t = rv.expovariate(1.0/interval)
            yield hold,self,t

def NoInSystem(R):                                   
    """ The number of customers in the resource R
    in waitQ and active Q"""
    return (len(R.waitQ)+len(R.activeQ))             

class Customer(Process):
    """ Customer arrives, is served and leaves """
    def __init__(self,name):
        Process.__init__(self)
        self.name = name
        
    def visit(self,timeInBank=0):       
        arrive=now()
        Qlength = [NoInSystem(counter[i]) for i in range(Nc)]              
        print "%7.4f %s: Here I am. %s   "%(now(),self.name,Qlength)       
        for i in range(Nc):                                                
            if Qlength[i] ==0 or Qlength[i]==min(Qlength): join =i ; break 
        yield request,self,counter[join]
        wait=now()-arrive
        print "%7.4f %s: Waited %6.3f"%(now(),self.name,wait)
        tib = counterRV.expovariate(1.0/timeInBank)
        yield hold,self,tib
        yield release,self,counter[join]
        print "%7.4f %s: Finished    "%(now(),self.name)

def model(counterseed=393939):
    global Nc,counter,counterRV
    Nc = 2
    counter = [Resource(name="Clerk0"),Resource(name="Clerk1")]
    counterRV = Random(counterseed)
    initialize()
    sourceseed = 99999
    source = Source(seed = sourceseed)
    activate(source,source.generate(5,10.0),0.0)
    simulate(until=400.0)

model()
