#!/usr/bin/env python                      
""" bank01: Simulate a single customer """ 
from __future__ import generators          
from SimPy.Simulation  import *            

class Customer(Process):                                 
    """ Customer arrives, looks around and leaves """
    def __init__(self,name):
        Process.__init__(self)                           
        self.name = name
        
    def visit(self,timeInBank=0):                        
        print "%7.4f %s: Here I am"%(now(),self.name)    
        yield hold,self,timeInBank                       
        print "%7.4f %s: I must leave"%(now(),self.name) 

def model():                  
    initialize()              
    c=Customer(name="Klaus")  
    activate(c,c.visit(timeInBank=10.0),delay=5.0) 
    simulate(until=100.0)     

model()                       
