r"""
    This code was generated by
   ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
    |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
    |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \

    Bulk Messaging and Broadcast
    Bulk Sending is a public Twilio REST API for 1:Many Message creation up to 100 recipients. Broadcast is a public Twilio REST API for 1:Many Message creation up to 10,000 recipients via file upload.

    NOTE: This class is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
    Do not edit the class manually.
"""

from datetime import datetime
from typing import Any, Dict, Optional, Union
from twilio.base import deserialize, values

from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.version import Version


class BroadcastInstance(InstanceResource):
    """
    :ivar broadcast_sid: Numeric ID indentifying individual Broadcast requests
    :ivar created_date: Timestamp of when the Broadcast was created
    :ivar updated_date: Timestamp of when the Broadcast was last updated
    :ivar broadcast_status: Status of the Broadcast request. Valid values are None, Pending-Upload, Uploaded, Queued, Executing, Execution-Failure, Execution-Completed, Cancelation-Requested, and Canceled
    :ivar execution_details:
    :ivar results_file: Path to a file detailing successful requests and errors from Broadcast execution
    """

    def __init__(self, version: Version, payload: Dict[str, Any]):
        super().__init__(version)

        self.broadcast_sid: Optional[str] = payload.get("broadcast_sid")
        self.created_date: Optional[datetime] = deserialize.iso8601_datetime(
            payload.get("created_date")
        )
        self.updated_date: Optional[datetime] = deserialize.iso8601_datetime(
            payload.get("updated_date")
        )
        self.broadcast_status: Optional[str] = payload.get("broadcast_status")
        self.execution_details: Optional[str] = payload.get("execution_details")
        self.results_file: Optional[str] = payload.get("results_file")

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """

        return "<Twilio.PreviewMessaging.V1.BroadcastInstance>"


class BroadcastList(ListResource):

    def __init__(self, version: Version):
        """
        Initialize the BroadcastList

        :param version: Version that contains the resource

        """
        super().__init__(version)

        self._uri = "/Broadcasts"

    def create(
        self, x_twilio_request_key: Union[str, object] = values.unset
    ) -> BroadcastInstance:
        """
        Create the BroadcastInstance

        :param x_twilio_request_key: Idempotency key provided by the client

        :returns: The created BroadcastInstance
        """

        data = values.of({})
        headers = values.of(
            {
                "X-Twilio-Request-Key": x_twilio_request_key,
            }
        )

        payload = self._version.create(
            method="POST", uri=self._uri, data=data, headers=headers
        )

        return BroadcastInstance(self._version, payload)

    async def create_async(
        self, x_twilio_request_key: Union[str, object] = values.unset
    ) -> BroadcastInstance:
        """
        Asynchronously create the BroadcastInstance

        :param x_twilio_request_key: Idempotency key provided by the client

        :returns: The created BroadcastInstance
        """

        data = values.of({})
        headers = values.of(
            {
                "X-Twilio-Request-Key": x_twilio_request_key,
            }
        )

        payload = await self._version.create_async(
            method="POST", uri=self._uri, data=data, headers=headers
        )

        return BroadcastInstance(self._version, payload)

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.PreviewMessaging.V1.BroadcastList>"
