
"""
__version__ = "$Revision: 1.8 $"
__date__ = "$Date: 2002/12/27 08:56:04 $"
"""

from wxPython import wx, html

import sys
from PythonCardPrototype import binding, event, log, registry, widget

class HtmlWindowSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'HtmlWindow'
        self.parent = 'Widget'
        self.parentName = self.parent
        self._attributes.update({
            'text' : { 'presence' : 'optional', 'default' : '' },
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()
       

class HtmlWindow(widget.Widget, html.wxHtmlWindow):
    """
    An HTML window.
    """

    _spec = HtmlWindowSpec()

    def __init__(self, aParent, aResource):
        attributes = ['_addressField']
        self._createAttributes(attributes)
        widget.Widget.__init__(self, aParent, aResource)

        self._addressField = None

        html.wxHtmlWindow.__init__(
            self,
            aParent, 
            self.getId(), 
            wx.wxPoint(aResource.position[0], aResource.position[1]), 
            wx.wxSize(aResource.size[0], aResource.size[1]),
            #style = wx.wxHW_SCROLLBAR_AUTO | wx.wxCLIP_SIBLINGS,
            name = aResource.name 
        )

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

        self._setText(aResource.text)

    def _bindEvents(self):
        adapter = binding.wxPython_EventBinding(self)
        adapter.bindEvents()

    def setAddressField(self, field):
        self._addressField = field

    def _getText(self) :
        return self.GetOpenedPage()

    def _setText(self, aString):
        if aString == '' or aString[0] == '<':
            self.SetPage(aString)
        else:
            # filename
            self.LoadPage(aString)
        #self._delegate.Refresh()

    def base_LoadPage(self, url):
        log.debug("base_LoadPage " + url)
        if self._addressField is not None:
            self._addressField.text = url
            log.debug("loaded")
        html.wxHtmlWindow.base_LoadPage(self, url)

    def LoadPage(self, url):
        log.debug("LoadPage " + url)
        if self._addressField is not None:
            self._addressField.text = url
            log.debug("loaded")
        html.wxHtmlWindow.LoadPage(self, url)

    def SetPage(self, text):
        log.debug("SetPage " + text)
        #if self._addressField is not None:
        #    self._addressField.text = text
        #    log.debug("set")
        html.wxHtmlWindow.SetPage(self, text)

    def OnLinkClicked(self, link):
        log.debug("OnLinkClicked " + str(link))
        if self._addressField is not None:
            url = self.GetOpenedPage()
            log.debug("url: " + url)
            baseURL = url[:url.rfind('/')]
            log.debug("baseURL: " + baseURL)
            href = link.GetHref()
            log.debug("href: " + href)
            if href.find('://') != -1:
                self._addressField.text = href
            else:
                self._addressField.text = baseURL + '/' + href
            log.debug("full url: " + self._addressField.text)
        # Virtuals in the base class have been renamed with base_ on the front.
        html.wxHtmlWindow.base_OnLinkClicked(self, link)


registry.getRegistry().register( sys.modules[__name__].HtmlWindow )

