# -*- coding: ISO-8859-1 -*-

# Copyright (C) 2002, 2003 Jrg Lehmann <joerg@luga.de>
#
# This file is part of PyTone (http://www.luga.de/pytone/)
#
# PyTone is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# PyTone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PyX; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import config
import events, hub
import item
import slist

class filelist(slist.slist):

    def __init__(self, win, songdbids):
        slist.slist.__init__(self, win, config.filelistwindow.scrollmode=="page")

        self.basedir = item.basedir(songdbids, win.ih,
                                    config.filelistwindow.virtualdirectoriesattop)
        self.dir = [self.basedir]
        self.shistory = []
        self.readdir()

        self.win.channel.subscribe(events.artistaddedtosongdb,
                                   self.artistaddedtosongdb)
        self.win.channel.subscribe(events.albumaddedtosongdb,
                                   self.albumaddedtosongdb)

    def set(self, items):
        slist.slist.set(self, items)

    def isdirselected(self):
        return isinstance(self.getselected(), item.diritem)

    def issongselected(self):
        return isinstance(self.getselected(), item.song)
        
    def getselectedsubdir(self):
        return self.dir + [self.getselected()]

    def readdir(self):
        self.set(self.dir[-1].getcontents())
        return 1

    def dirdown(self):
        self.shistory.append((self.dir, self.selected, self.top))
        self.dir = self.getselectedsubdir()
        
        if self.readdir() is None:
            self.dir, self.selected, self.top = self.shistory.pop()
            self.readdir()

    def dirup(self):
        if len(self.shistory)>0:
            dir, selected, top = self.shistory.pop()
            self.dir = dir
            self.readdir()
            self.selected = selected
            self.top = top
            hub.hub.notify(events.selectionchanged(self.getselected()))

    def jumptorandomlist(self):
        if self.dir != [self.basedir, self.basedir.randomlist]:
            self.shistory.append((self.dir, self.selected, self.top))
        self.dir = [self.basedir, self.basedir.randomlist]
        self.readdir()

    def jumptofilesystembase(self):
        if self.dir != [self.basedir, self.basedir.filesystembase]:
            self.shistory.append((self.dir, self.selected, self.top))
        self.dir = [self.basedir, self.basedir.filesystembase]
        self.readdir()
        
    def selectionpath(self):
        return self.dir[-1].getheader(self.getselected())
        
    def insertrecursiveselection(self):
        if self.isdirselected():
            songs = self.getselected().getcontentsrecursivesorted()
            hub.hub.notify(events.playlistaddsongs(songs))
        elif elf.issongselected():
            hub.hub.notify(events.playlistaddsongs([self.getselected()]))

    def randominsertrecursiveselection(self):
        if self.isdirselected():
            songs = self.getselected().getcontentsrecursiverandom()
            hub.hub.notify(events.playlistaddsongs(songs))
        elif self.issongselected():
            hub.hub.notify(events.playlistaddsongs([self.getselected()]))

    def rateselection(self, rating):
        assert 0<=rating<=5, "only ratings between 0 and 5 are allowed"
        if (isinstance(self.getselected(), item.song) or
            isinstance(self.getselected(), item.album) or
            isinstance(self.getselected(), item.artist)):
            self.getselected().rate(rating)
        hub.hub.notify(events.selectionchanged(self.getselected()))

    def rescanselection(self):
        if self.isdirselected():
            # instead of rescanning of a whole filesystem we start the autoregisterer
            if isinstance(self.getselected(), item.basedir):
                hub.hub.notify(events.autoregistersongs(self.getselected().songdbid))
            else:
                songs = self.getselected().getcontentsrecursive()
                if songs:
                    hub.hub.notify(events.rescansongs(songs[0].songdbid, songs))
        else:
            self.getselected().rescan()

    # event handler

    def artistaddedtosongdb(self, event):
        if isinstance(self.dir[-1], item.basedir) and event.songdbid==self.dir[-1].songdbid:
            newartist = item.artist(event.songdbid, event.artist.name)
            self.insertitem(newartist, self.dir[-1].cmpitem)
            self.win.update()

    def albumaddedtosongdb(self, event):
        if (isinstance(self.dir[-1], item.artist) and
            self.dir[-1].songdbid==event.songdbid and
            self.dir[-1].name in event.album.artists):
            newalbum = item.album(event.songdbid,
                                  event.album.id, self.dir[-1].name, event.album.name)
            self.insertitem(newalbum, self.dir[-1].cmpitem)
            self.win.update()
