# -*- coding: ISO-8859-1 -*-

# Copyright (C) 2004 Jrg Lehmann <joerg@luga.de>
#
# This file is part of PyTone (http://www.luga.de/pytone/)
#
# PyTone is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# PyTone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PyX; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import helper
import time

_DEBUG   = 0
_INFO    = 1
_WARNING = 2
_ERROR   = 3

_desc = { _DEBUG:   "debug",
          _INFO:    "info",
          _WARNING: "warning",
          _ERROR:   "error" }

# minimal level of log messages that should be stored in the buffer
LOGLEVEL = _INFO
# LOGLEVEL = _DEBUG

# log buffer consisting of tuples (loglevel, time, logmessage)
items = []

# maximal length of log buffer
maxitems = 100

def log(s, level):
    helper.debug("%s: %s\n" % (_desc[level], s))
    if level>=LOGLEVEL:
        items.append((level, time.time(), s))
        if len(items)>maxitems:
            items.pop(0)

def debug(s):
    log(s, _DEBUG)

def info(s):
    log(s, _INFO)

def warning(s):
    log(s, _WARNING)

def error(s):
    log(s, _ERROR)

info(_("PyTone startup"))
