/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qalculatepreferencesdialog.h"
#include "qalculate_kde_utils.h"

#include <klocale.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <kdeversion.h>
#if KDE_VERSION_MAJOR > 3 || KDE_VERSION_MINOR > 1
#include <kfontrequester.h>
#endif
#if KDE_VERSION_MAJOR < 4 && KDE_VERSION_MINOR < 2
#include <qtabwidget.h>
#else
#include <ktabwidget.h>
#endif
#include <qpushbutton.h>
#include <qfont.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <kcolorbutton.h>
#include "kqalculate.h"

extern KQalculate *mainWin;
extern PrintOptions printops;
extern bool fetch_exchange_rates_at_startup, save_mode_on_exit, save_defs_on_exit;
extern bool use_custom_result_font, use_custom_expression_font, use_custom_status_font;
extern QString custom_result_font, custom_expression_font, custom_status_font;
extern QWidget *expressionWidget, *resultWidget, *statusWidget_l;
extern bool close_to_systray;
extern bool display_expression_status;
extern QColor status_error_color;
extern QColor status_warning_color;
extern int use_icon_buttons;

#if KDE_VERSION_MAJOR < 4 && KDE_VERSION_MINOR < 2
#include <kfontdialog.h>

class KFontRequester : public QWidget
{
  Q_OBJECT

  public:

    KFontRequester( QWidget *parent=0L, const char *name=0L,
        bool onlyFixed=false );

    QFont font() const { return m_selFont; }
    virtual void setFont( const QFont &font, bool onlyFixed=false );

  protected:

    void displaySampleText();

  protected slots:

    virtual void buttonClicked();

  protected:

    bool m_onlyFixed;
    QString m_sampleText, m_title;
    QLabel *m_sampleLabel;
    QPushButton *m_button;
    QFont m_selFont;

};


KFontRequester::KFontRequester( QWidget *parent, const char *name,
    bool onlyFixed ) : QWidget( parent, name ),
    m_onlyFixed( onlyFixed )
{
  QHBoxLayout *layout = new QHBoxLayout( this, 0, KDialog::spacingHint() );

  m_sampleLabel = new QLabel( this, "m_sampleLabel" );
  m_button = new QPushButton( i18n( "Choose..." ), this, "m_button" );

  m_sampleLabel->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
  setFocusProxy( m_button );

  layout->addWidget( m_sampleLabel, 1 );
  layout->addWidget( m_button );

  connect( m_button, SIGNAL( clicked() ), SLOT( buttonClicked() ) );

  displaySampleText();

}

void KFontRequester::setFont( const QFont &font, bool onlyFixed )
{
  m_selFont = font;
  m_onlyFixed = onlyFixed;

  displaySampleText();
}
void KFontRequester::buttonClicked()
{
  int result = KFontDialog::getFont( m_selFont, m_onlyFixed, parentWidget() );

  if ( result == KDialog::Accepted )
  {
    displaySampleText();
  }
}

void KFontRequester::displaySampleText()
{
  m_sampleLabel->setFont( m_selFont );

  int size = m_selFont.pointSize();
  if(size == -1)
    size = m_selFont.pixelSize();

  if ( m_sampleText.isEmpty() )
    m_sampleLabel->setText( QString( "%1 %2" ).arg( m_selFont.family() )
      .arg( size ) );
  else
    m_sampleLabel->setText( m_sampleText );
}
#endif

QalculatePreferencesDialog::QalculatePreferencesDialog(QWidget *parent, const char *name) : KDialogBase(parent, name, true, i18n("Preferences"), Ok | Apply | Cancel, Ok, false) {

#if KDE_VERSION_MAJOR < 4 && KDE_VERSION_MINOR < 2
	QTabWidget *tabs = new QTabWidget(this);
#else
	QTabWidget *tabs = new KTabWidget(this);
#endif
	setMainWidget(tabs);
	QWidget *page1 = new QWidget(this);
	QWidget *page2 = new QWidget(this);
	tabs->addTab(page1, i18n("General"));
	tabs->addTab(page2, i18n("Fonts"));

	QVBoxLayout *vbox = new QVBoxLayout(page1, spacingHint());
	systrayButton = new QCheckBox(i18n("Close to system tray"), page1);
	vbox->addWidget(systrayButton);
	statusButton = new QCheckBox(i18n("Display expression status"), page1);
	vbox->addWidget(statusButton);
	iconsButton = new QCheckBox(i18n("Use icon buttons"), page1);
	iconsButton->setTristate(true);
	vbox->addWidget(iconsButton);
	fetchExchangeRatesButton = new QCheckBox(i18n("Update exchange rates on start"), page1);
	vbox->addWidget(fetchExchangeRatesButton);
	saveModeButton = new QCheckBox(i18n("Save mode on exit"), page1);
	vbox->addWidget(saveModeButton);
	saveDefsButton = new QCheckBox(i18n("Save definitions on exit"), page1);
	vbox->addWidget(saveDefsButton);
	unicodeButton = new QCheckBox(i18n("Enable unicode signs"), page1);
	vbox->addWidget(unicodeButton);
	lowerCaseButton = new QCheckBox(i18n("Use lower case in numbers"), page1);
	vbox->addWidget(lowerCaseButton);
	lowerCaseEButton = new QCheckBox(i18n("Use lower case \"e\""), page1);
	vbox->addWidget(lowerCaseEButton);
	spellOutLogicalOperatorsButton = new QCheckBox(i18n("Spell out logical operators"), page1);
	vbox->addWidget(spellOutLogicalOperatorsButton);
	QGridLayout *grid = new QGridLayout(vbox);
	multiplicationLabel = new QLabel(i18n("Multiplication sign:"), page1);
	grid->addWidget(multiplicationLabel, 0, 0);
	QButtonGroup *group = new QButtonGroup();
	dotButton = new QRadioButton(SIGN_MULTIDOT, page1);
	group->insert(dotButton, 0);
	grid->addWidget(dotButton, 0, 1);
	exButton = new QRadioButton(SIGN_MULTIPLICATION, page1);
	group->insert(exButton, 1);
	grid->addWidget(exButton, 0, 2);
	asteriskButton = new QRadioButton("*", page1);
	group->insert(asteriskButton, 2);
	grid->addWidget(asteriskButton, 0, 3);
	divisionLabel = new QLabel(i18n("Division sign:"), page1);
	grid->addWidget(divisionLabel, 1, 0);
	group = new QButtonGroup();
	divisionSlashButton = new QRadioButton(" " SIGN_DIVISION_SLASH " ", page1);
	group->insert(divisionSlashButton, 0);
	grid->addWidget(divisionSlashButton, 1, 1);
	divisionButton = new QRadioButton(SIGN_DIVISION, page1);
	group->insert(divisionButton, 1);
	grid->addWidget(divisionButton, 1, 2);
	slashButton = new QRadioButton("/", page1);
	group->insert(slashButton, 2);
	grid->addWidget(slashButton, 1, 3);
	vbox->addItem(new QSpacerItem(0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding));
	
	vbox = new QVBoxLayout(page2, spacingHint());
	useCustomResultFontButton = new QCheckBox(i18n("Custom result font"), page2);
	vbox->addWidget(useCustomResultFontButton);
	resultFontEdit = new KFontRequester(page2);
	vbox->addWidget(resultFontEdit);
	useCustomExpressionFontButton = new QCheckBox(i18n("Custom expression font"), page2);
	vbox->addWidget(useCustomExpressionFontButton);
	expressionFontEdit = new KFontRequester(page2);
	vbox->addWidget(expressionFontEdit);
	useCustomStatusFontButton = new QCheckBox(i18n("Custom status font"), page2);
	vbox->addWidget(useCustomStatusFontButton);
	statusFontEdit = new KFontRequester(page2);
	vbox->addWidget(statusFontEdit);
	grid = new QGridLayout(vbox);
	grid->addWidget(new QLabel(i18n("Status error color:"), page2), 0, 0);
#if KDE_VERSION_MAJOR == 3 && KDE_VERSION_MINOR < 1	
	statusErrorColorButton = new KColorButton(page2);
#else
	statusErrorColorButton = new KColorButton("red", "red", page2);
#endif
	grid->addWidget(statusErrorColorButton, 0, 1);
	grid->addWidget(new QLabel(i18n("Status warning color:"), page2), 1, 0);
#if KDE_VERSION_MAJOR == 3 && KDE_VERSION_MINOR < 1	
	statusWarningColorButton = new KColorButton(page2);
#else
	statusWarningColorButton = new KColorButton("blue", "blue", page2);
#endif	
	grid->addWidget(statusWarningColorButton, 1, 1);
	vbox->addItem(new QSpacerItem(0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding));
	

	connect(useCustomResultFontButton, SIGNAL(toggled(bool)), resultFontEdit, SLOT(setEnabled(bool)));
	connect(useCustomExpressionFontButton, SIGNAL(toggled(bool)), expressionFontEdit, SLOT(setEnabled(bool)));
	connect(useCustomStatusFontButton, SIGNAL(toggled(bool)), statusFontEdit, SLOT(setEnabled(bool)));
	connect(unicodeButton, SIGNAL(toggled(bool)), multiplicationLabel, SLOT(setEnabled(bool)));
	connect(unicodeButton, SIGNAL(toggled(bool)), dotButton, SLOT(setEnabled(bool)));
	connect(unicodeButton, SIGNAL(toggled(bool)), exButton, SLOT(setEnabled(bool)));
	connect(unicodeButton, SIGNAL(toggled(bool)), asteriskButton, SLOT(setEnabled(bool)));
	connect(unicodeButton, SIGNAL(toggled(bool)), divisionLabel, SLOT(setEnabled(bool)));
	connect(unicodeButton, SIGNAL(toggled(bool)), divisionSlashButton, SLOT(setEnabled(bool)));
	connect(unicodeButton, SIGNAL(toggled(bool)), divisionButton, SLOT(setEnabled(bool)));
	connect(unicodeButton, SIGNAL(toggled(bool)), slashButton, SLOT(setEnabled(bool)));

}

QalculatePreferencesDialog::~QalculatePreferencesDialog() {}

void QalculatePreferencesDialog::slotApply() {
	close_to_systray = systrayButton->isChecked();
	display_expression_status = statusButton->isChecked();
	switch(iconsButton->state()) {
		case QButton::Off: {
			use_icon_buttons = 0;
			break;
		}
		case QButton::On: {
			use_icon_buttons = 1;
			break;
		}
		case QButton::NoChange: {
			use_icon_buttons = -1;
			break;
		}
	}
	fetch_exchange_rates_at_startup = fetchExchangeRatesButton->isChecked();
	save_mode_on_exit = saveModeButton->isChecked();
	printops.use_unicode_signs = unicodeButton->isChecked();
	printops.lower_case_numbers = lowerCaseButton->isChecked();
	printops.lower_case_e = lowerCaseEButton->isChecked();
	printops.spell_out_logical_operators = spellOutLogicalOperatorsButton->isChecked();
	save_defs_on_exit = saveDefsButton->isChecked();
	use_custom_result_font = useCustomResultFontButton->isChecked();
	use_custom_expression_font = useCustomExpressionFontButton->isChecked();
	use_custom_status_font = useCustomStatusFontButton->isChecked();
	custom_result_font = resultFontEdit->font().toString();
	custom_expression_font = expressionFontEdit->font().toString();
	custom_status_font = statusFontEdit->font().toString();
	status_error_color = statusErrorColorButton->color();
	if(!status_error_color.isValid()) status_error_color.setNamedColor("red");
	status_warning_color = statusWarningColorButton->color();
	if(!status_warning_color.isValid()) status_warning_color.setNamedColor("blue");
	if(dotButton->isChecked()) {
		printops.multiplication_sign = MULTIPLICATION_SIGN_DOT;
	} else if(exButton->isChecked()) {
		printops.multiplication_sign = MULTIPLICATION_SIGN_X;
	} else {
		printops.multiplication_sign = MULTIPLICATION_SIGN_ASTERISK;
	}
	if(divisionSlashButton->isChecked()) {
		printops.division_sign = DIVISION_SIGN_DIVISION_SLASH;
	} else if(divisionButton->isChecked()) {
		printops.division_sign = DIVISION_SIGN_DIVISION;
	} else {
		printops.division_sign = DIVISION_SIGN_SLASH;
	}
	mainWin->applyPreferences();
}
bool QalculatePreferencesDialog::editPreferences() {

	systrayButton->setChecked(close_to_systray);
	statusButton->setChecked(display_expression_status);
	if(use_icon_buttons < 0) {
		iconsButton->setNoChange();
	} else {
		iconsButton->setChecked(use_icon_buttons > 0);
	}
	fetchExchangeRatesButton->setChecked(fetch_exchange_rates_at_startup);
	saveModeButton->setChecked(save_mode_on_exit);
	unicodeButton->setChecked(printops.use_unicode_signs);
	lowerCaseButton->setChecked(printops.lower_case_numbers);
	lowerCaseEButton->setChecked(printops.lower_case_e);
	spellOutLogicalOperatorsButton->setChecked(printops.spell_out_logical_operators);
	saveDefsButton->setChecked(save_defs_on_exit);
	useCustomResultFontButton->setChecked(use_custom_result_font);
	useCustomExpressionFontButton->setChecked(use_custom_expression_font);
	useCustomStatusFontButton->setChecked(use_custom_status_font);
	QFont font1(resultWidget->font());
	font1.fromString(custom_result_font);
	resultFontEdit->setFont(font1);
	resultFontEdit->setEnabled(use_custom_result_font);
	QFont font2(expressionWidget->font());
	font2.fromString(custom_expression_font);
	expressionFontEdit->setFont(font2);
	expressionFontEdit->setEnabled(use_custom_expression_font);
	QFont font3(statusWidget_l->font());
	font3.fromString(custom_status_font);
	statusFontEdit->setFont(font3);
	statusFontEdit->setEnabled(use_custom_status_font);
	statusErrorColorButton->setColor(status_error_color);
	statusWarningColorButton->setColor(status_warning_color);
	if(can_display_unicode_string_function(SIGN_MULTIDOT, (void*) dotButton)) dotButton->setText(SIGN_MULTIDOT);
	else dotButton->setText(SIGN_SMALLCIRCLE);
	switch(printops.multiplication_sign) {
		case MULTIPLICATION_SIGN_DOT: {
			dotButton->setChecked(true);
			break;
		}
		case MULTIPLICATION_SIGN_X: {
			exButton->setChecked(true);
			break;
		}
		default: {
			asteriskButton->setChecked(true);
			break;
		}
	}
	asteriskButton->setEnabled(printops.use_unicode_signs);
	exButton->setEnabled(printops.use_unicode_signs);
	dotButton->setEnabled(printops.use_unicode_signs);
	multiplicationLabel->setEnabled(printops.use_unicode_signs);
	switch(printops.division_sign) {
		case DIVISION_SIGN_DIVISION_SLASH: {
			divisionSlashButton->setChecked(true);
			break;
		}
		case DIVISION_SIGN_DIVISION: {
			divisionButton->setChecked(true);
			break;
		}
		default: {
			slashButton->setChecked(true);
			break;
		}
	}
	slashButton->setEnabled(printops.use_unicode_signs);
	divisionSlashButton->setEnabled(printops.use_unicode_signs);
	divisionButton->setEnabled(printops.use_unicode_signs);
	divisionLabel->setEnabled(printops.use_unicode_signs);

	if(exec() == Accepted) {
		slotApply();
		return true;
	}
	return false;

}


#include "qalculatepreferencesdialog.moc"
