/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qalculateeditdataobjectdialog.h"
#include "qalculate_kde_utils.h"
#include <qlabel.h>
#include <qgrid.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <qvaluevector.h>
#include <qstring.h>
#include <klocale.h>

QalculateEditDataObjectDialog::QalculateEditDataObjectDialog(QWidget *parent, const char *name) : KDialogBase(parent, name, true, i18n("Edit Object"), Ok | Cancel, Ok, true) {

}

QalculateEditDataObjectDialog::~QalculateEditDataObjectDialog() {}

DataObject *QalculateEditDataObjectDialog::editDataObject(DataSet *ds, DataObject *o) {

	if(!ds) return NULL;
	if(o) {
		setCaption(i18n("Edit Object"));
	} else {
		setCaption(i18n("New Object"));
	}

	QGrid *grid = new QGrid(4, Qt::Horizontal, this);
	grid->setSpacing(spacingHint());
	setMainWidget(grid);
	new QLabel(i18n("Property"), grid);
	new QLabel(i18n("Value"), grid);
	new QLabel(grid);
	new QLabel(i18n("Approximation"), grid);
	DataPropertyIter it;
	DataProperty *dp = ds->getFirstProperty(&it);
	string sval;
	QValueVector<KLineEdit*> value_entries;
	QValueVector<KComboBox*> approx_menus;
	string str;
	while(dp) {
		new QLabel(dp->title().c_str(), grid);
		KLineEdit *entry = new KLineEdit(grid);
		value_entries.push_back(entry);
		int iapprox = -1;
		if(o) {
			entry->setText(o->getProperty(dp, &iapprox).c_str());
		}
		new QLabel(dp->getUnitString().c_str(), grid);
		KComboBox *om = new KComboBox(grid);
		om->setEditable(false);
		om->insertItem(i18n("Default"));
		om->insertItem(i18n("Approximate"));
		om->insertItem(i18n("Exact"));
		approx_menus.push_back(om);
		om->setCurrentItem(iapprox + 1);
		dp = ds->getNextProperty(&it);
	}
	if(exec() == QDialog::Accepted) {
		bool new_object = (o == NULL);
		if(new_object) {
			o = new DataObject(ds);
			ds->addObject(o);
		}
		dp = ds->getFirstProperty(&it);
		size_t i = 0;
		QString val;
		while(dp) {
			val = value_entries[i]->text().stripWhiteSpace();
			if(!val.isEmpty()) {
				o->setProperty(dp, val.ascii(), approx_menus[i]->currentItem() - 1);
			} else if(!new_object) {
				o->eraseProperty(dp);
			}
			dp = ds->getNextProperty(&it);
			i++;
		}
		o->setUserModified();
		delete grid;
		return o;
	}
	delete grid;
	return NULL;
}

#include "qalculateeditdataobjectdialog.moc"
