#ifndef GUI_H
#define GUI_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <qstring.h>
#include <qlabel.h>
#include <qslider.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qmessagebox.h>
#include <qcheckbox.h>
#include <qlist.h>
#include <qtimer.h>
#include <alsa/asoundlib.h>
#include "recdata.h"
#include "capture.h"
#include "diskwrite.h"
#include "meter.h"

const QString aboutText = "qaRecord 0.0.8\nby Matthias Nagorni\n(c)2002-2003 SuSE AG Nuremberg\n\n"
                          "qaRecord is licensed under the GPL.\n";
                                                                                     
class Gui : public QVBox
{
  Q_OBJECT

  private:
    QMessageBox *aboutWidget;
    QLabel *currentFileLabel, *timeLabel, *bufLabel, *maxBufLabel;
    QCheckBox *captureToggle;
    QTimer *timer;
    Capture *capture;
    DiskWrite *diskwrite;
    Meter *meter[2];
    snd_seq_t *seq_handle;
    long maxBuffer;
    int in_ports[2], out_ports[2];

  public:
    RecData *recdata;

  public:
    Gui(bool enableJack, QString pcmName, long periodSize, unsigned long p_ringBufSize, QWidget* parent=0, const char *name=0);
    ~Gui();
    int initSeqNotifier();    
    int open_seq(snd_seq_t **seq_handle, int in_ports[], int out_ports[], int num_in, int num_out);
 
  public slots: 
    void displayAbout();
    void newFile();
    void recordClicked();
    void stopClicked();
    void pauseClicked();
    void timerProc();
    void midiAction(int fd);
    void captureToggled(bool on);
    void closeGui();
};
  
#endif
