#include <stdio.h>      
#include <stdlib.h>     
#include <unistd.h>
#include <getopt.h>  
#include <qapplication.h>
#include <qmainwindow.h>
#include <qmenubar.h>   
#include <qpopupmenu.h>
#include "gui.h"

static struct option options[] =
        {{"help", 0, 0, 'h'},
         {"device", 1, 0, 'd'},
         {"buffersize", 1, 0, 'b'},
         {"fragments", 1, 0, 'f'},
         {"periodsize", 1, 0, 'p'},
         {"midiChannel", 1, 0, 'm'},
         {"midiNote", 1, 0, 'n'},
         {"jack", 0, 0, 'j'},
         {"rate", 1, 0, 'r'},
         {"32bit", 0, 0, 'i'},
         {0, 0, 0, 0}};

int main(int argc, char *argv[])  
{
  QApplication *qApp = new QApplication(argc, argv);
  QMainWindow *top = new QMainWindow();
  top->setCaption("qaRecord");
  int getopt_return;
  int option_index; 
  unsigned long ringBufSize = 1048576;
  int periods = 2;
  int periodsize = 2048;
  int rate = 44100;
  bool enableJack = false;
  bool enable32bit = false;
  int midiChannel = 15;
  int midiNote = 21;
  QString pcmName = "plughw:0";

  while((getopt_return = getopt_long(argc, argv, "jhid:b:f:p:m:n:r:", options, &option_index)) >= 0) {
    switch(getopt_return) {
    case 'd':
        pcmName = QString(optarg);
        break;
    case 'b':
        ringBufSize = atoi(optarg);
        break;
    case 'f':
        periods = atoi(optarg);
        break;
    case 'p':
        periodsize = atoi(optarg);
        break;
    case 'm':
        midiChannel = atoi(optarg);
        break;
    case 'r':
        rate = atoi(optarg);
        break;
    case 'j': 
        enableJack = true;
        break;
    case 'i': 
        enable32bit = true;
        break;
    case 'n':
        midiNote = atoi(optarg);
        break;
    case 'h':
        printf("\n%s\n", aboutText.latin1());
        printf("--device <ALSA device>      ALSA Capture device [plughw:0]\n");
        printf("--buffersize <bytes>        Size of Ringbuffer [%ld]\n", ringBufSize);
        printf("--fragments <num>           Number of Fragments [2]\n");
        printf("--periodsize <frames>       Periodsize [%d]\n", periodsize);
        printf("--midiChannel <num>         MIDI Channel [15]\n");
        printf("--midiNote <num>            MIDI Note [21]\n");
        printf("--rate <num>                Rate [44100]\n");
        printf("--32bit                     Use 32 Bit Format\n");
        printf("--jack                      Enable JACK mode\n\n");
        exit(EXIT_SUCCESS);
    }
  }
  Gui *gui = new Gui(enableJack, pcmName, periodsize, ringBufSize, top);
  if (!enableJack) {
    gui->recdata->rate = rate;
  }
  gui->recdata->periods = periods;
  gui->recdata->midiChannel = midiChannel;
  gui->recdata->midiNote = midiNote;
  gui->recdata->setSamplesize((enable32bit) ? 4 : 2);
  QPopupMenu *filePopup = new QPopupMenu(top); 
  QPopupMenu *aboutMenu = new QPopupMenu(top);
  top->menuBar()->insertItem("&File", filePopup);
  top->menuBar()->insertSeparator(); top->menuBar()->insertItem("&About", aboutMenu); 
  filePopup->insertItem("&New", gui, SLOT(newFile()));
  filePopup->insertItem("&Quit", qApp, SLOT(quit()));
  aboutMenu->insertItem("About qaRecord", gui, SLOT(displayAbout())); 
  if (enableJack) {
    QObject::connect(qApp, SIGNAL(aboutToQuit()), gui, SLOT(closeGui()));
  }
  top->setCentralWidget(gui); 
  top->show();
  qApp->setMainWidget(top); 
  return qApp->exec(); 
}
