#ifndef RECDATA_H
#define RECDATA_H

#include <stdio.h>
#include <stdlib.h>
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <qwaitcondition.h>
#include <jack/jack.h>
#include <alsa/asoundlib.h>

#define DEFAULT_RATE            44100
#define DEFAULT_PERIODSIZE       1024
#define DEFAULT_PERIODS             2
#define DEFAULT_CHANNELS            2
#define DEFAULT_SAMPLESIZE          2
#define WAVBUFSIZE               4096
#define MAX_JACK_FRAMES         16384
#define DEFAULT_BPS                16

class RecData : public QObject
{
  private:
   static int capture_callback(jack_nframes_t nframes, void *arg);
   int jack_capture(jack_nframes_t nframes);
          
  public:
    QString currentDir, currentFile, pcmName;
    unsigned long wavDataSize;
    bool doRecord, doCapture, pauseFlag, newMax, enableJack, jackRunning;
    int rate;
    int samplesize, framesize, periodsize, periods, channels, frameCounter;
    int max[2], jmax[2], midiChannel, midiNote;
    unsigned char *ringBuf;
    long ringBufSize, writeOfs, readOfs, validByteCount, maxValidByteCount;
    QWaitCondition waitForData;
    jack_client_t *jack_handle;
    jack_port_t *jack_in[2];
    jack_default_audio_sample_t *jackdata[2];
    
  public:
    RecData(QString p_pcmName, unsigned long p_ringBufSize, QObject *parent);
    ~RecData();
    int initJack();
    int activateJack();
    int deactivateJack(); 
    int setSamplesize(int size);
};

#endif
