%define name qbankmanager

%define is_mandrake %(test -e /etc/mandrake-release && echo 1 || echo 0)
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)
%define is_fedora %(test -e /etc/fedora-release && echo 1 || echo 0)

%define dist redhat
%define disttag rh

%if %is_mandrake
%define dist mandrake
%define disttag mdk
%endif
%if %is_suse
%define dist suse
%define disttag suse
%endif
%if %is_fedora
%define dist fedora
%define disttag rhfc
%endif
#
%define version 0.9.29

%define distver %(release="`rpm -q --queryformat='%{VERSION}' %{dist}-release 2>/dev/null`" ; if test $? != 0 ; then release="" ; fi ; echo "$release")

# Note: There is not yet a special symbol for the rpm release
# version. We set it to one here.
%define release 1.%{disttag}%{distver}

Name: %{name}
Summary: Simple bank account management software.
Version: %{version}
Release: %{release}
Source: http://download.sourceforge.net/aqbanking/%{name}-%{version}.tar.gz
Group: Desktop/Finance Managers
License: GPL
Packager: Christian Stimming <stimming@tuhh.de>
URL: http://sourceforge.net/projects/aqbanking
BuildRequires: gwenhywfar-devel aqbanking-devel
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Prereq: /sbin/ldconfig
Prefix: %{_prefix}

%description 
This is a simple finance manager, intended for the
AqBanking library and the German HBCI (Home Banking Computer
Interface) protocol.

%prep
%setup -q

%build
%{configure}
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

make DESTDIR=$RPM_BUILD_ROOT install

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%files
%defattr(-,root,root)
%doc AUTHORS README COPYING ChangeLog
%{_bindir}/qbankmanager
%{_datadir}/%{name}/i18n
%{_datadir}/%{name}/home
