/***************************************************************************
 $RCSfile: askaccount.cpp,v $
                             -------------------
    cvs         : $Id: askaccount.cpp,v 1.3 2005/08/08 14:18:35 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "askaccount.h"
#include "accountlist.h"
#include "kbanking.h"

#include <qlayout.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qmessagebox.h>



AskAccount::AskAccount(KBanking *app,
                       const char *bankCode,
                       const char *accountId,
                       QWidget* parent,
                       const char* name,
                       bool modal,
                       WFlags fl)
:AskAccountUi(parent, name, modal, fl)
,_app(app)
,_accountList(0){

  if (bankCode)
    _bankCode=bankCode;
  if (accountId)
    _accountId=accountId;

  accountBox->setColumnLayout(0, Qt::Vertical );
  QBoxLayout *accountBoxLayout=new QHBoxLayout(accountBox->layout() );
  accountBoxLayout->setAlignment(Qt::AlignTop);

  _accountList=new AccountListView((QWidget*)accountBox, "AccountList");
  accountBoxLayout->addWidget(_accountList);
  _accountList->addAccounts(app->getAppAccounts());

  bankCodeEdit->setText(_bankCode);
  if (_bankCode.isEmpty())
    bankCodeEdit->setEnabled(false);

  accountIdEdit->setText(_accountId);
  if (_accountId.isEmpty())
    accountIdEdit->setEnabled(false);

  QObject::connect((QObject*)helpButton, SIGNAL(clicked()),
                   this, SLOT(slotHelp()));
}



AskAccount::~AskAccount(){
}



Account *AskAccount::selectedAccount(){
  AccountListViewItem *entry;
  QListViewItemIterator it(_accountList);

  // iterate through all items of the listview
  for (;it.current();++it) {
    if (it.current()->isSelected()) {
      entry=dynamic_cast<AccountListViewItem*>(it.current());
      if (entry)
        return entry->getAccount();
    }
  } // for
  return 0;
}



void AskAccount::accept(){
  if (selectedAccount()==0) {
    QMessageBox::critical(0,
                          tr("No Account Selected"),
                          tr("Please select the matching account."),
                          tr("Dismiss"), 0, 0, 0);
    return;
  }

  return QDialog::accept();
}



void AskAccount::reject(){
  return QDialog::reject();
}



void AskAccount::slotHelp(){
  _app->invokeHelp("dialog/askAccount");
}











