/***************************************************************************
 $RCSfile: kbanking.cpp,v $
                             -------------------
    cvs         : $Id: kbanking.cpp,v 1.38 2005/09/01 07:27:38 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "kbanking_p.h"
#include "ktimport.h"
#include "flagstaff.h"
#include "checkduplicates.h"
#include "transactionwindow.h"
#include "mainwindow.h"

#include "report.h"
#include "simplereport.h"
#include "summaryreport.h"
#include "categoryreport.h"
/* Note: add new reports to fn _sampleReportModules() */

#include <assert.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <qinputdialog.h>
#include <qapplication.h>
#include <qdatetime.h>

#include <gwenhywfar/debug.h>
#include <gwenhywfar/text.h>

#include <qwidget.h>


KBanking::KBanking(const char *appname,
                   const char *fname,
                   const char *name)
:App(appname, fname)
,_mainWindow(0)
,_lastWidgetId(0)
,_logLevel(AB_Banking_LogLevelInfo)
,_lastReportId(0){
  _flagStaff=new FlagStaff();
}



KBanking::~KBanking(){
  delete _flagStaff;
}



FlagStaff *KBanking::flagStaff(){
  return _flagStaff;
}



int KBanking::executeQueue(){
  int rv;

  rv=QBanking::executeQueue();
  _flagStaff->queueUpdated();
  return rv;
}



void KBanking::transfersUpdated(){
  _flagStaff->transfersUpdated();
}



void KBanking::standingOrdersUpdated(){
  _flagStaff->standingOrdersUpdated();
}



bool KBanking::importContext(AB_IMEXPORTER_CONTEXT *ctx,
                             GWEN_TYPE_UINT32 flags){
  KTransactionImporter imp(this, ctx, flags);

  DBG_INFO(0, "Checking context...");
  if (!imp.checkTransactions()) {
    DBG_INFO(0, "Error checking transactions");
    return false;
  }

  DBG_INFO(0, "Importing transactions...");
  if (!imp.importContext()) {
    DBG_INFO(0, "Error importing transactions");
    return false;
  }

  _flagStaff->accountsUpdated();
  _flagStaff->transfersUpdated();
  _flagStaff->datedTransfersUpdated();
  _flagStaff->standingOrdersUpdated();
  _flagStaff->payeesUpdated();

  return true;
}



void KBanking::invokeHelp(const char *subject){
}



void KBanking::infoTransactionsChanged(Account *a){
  _flagStaff->accountsUpdated();
  appInfoTransactionsChanged(a);
}



void KBanking::rebuildExportMenu(){
  _flagStaff->rebuildExportMenu();
}



int KBanking::init(){
  GWEN_DB_NODE *db;
  int rv;
  GWEN_TYPE_UINT32 lastVersion;

  rv=App::init();
  if (rv)
    return rv;

  lastVersion=getLastVersion();
  if ((lastVersion!=APP_LAST_VERSION_NONE) &&
      (lastVersion<
       ((0<<24)+
        (9<<16)+
        (18<<8)+
        5))) {
    DBG_NOTICE(0, "Updating from old version, updating transactions");
    CheckDuplicates w(this);
    w.show();
    w.adjustDates();
  }

  if ((lastVersion!=APP_LAST_VERSION_NONE) &&
      (lastVersion<
       ((0<<24)+
        (9<<16)+
        (28<<8)+
        1))) {
    DBG_NOTICE(0, "Updating from old version, updating transactions");
    CheckDuplicates w(this);
    w.show();
    w.gatherInfoFromPurpose();
  }

  db=getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT,
                      "kbanking");
  assert(db);
  _lastReportId=GWEN_DB_GetIntValue(db, "lastReportId", 0, 0);

  _sampleReportModules();

  return 0;
}



int KBanking::fini(){
  GWEN_DB_NODE *db;

  db=getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT,
                      "kbanking");
  assert(db);
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "lastReportId",
                      _lastReportId);

  return App::fini();
}



void KBanking::setMainWindow(MainWindow *w){
  _mainWindow=w;
}



MainWindow *KBanking::getMainWindow(){
  return _mainWindow;
}



Report *KBanking::findReport(const char *name){
  std::list<Report*>::iterator it;

  for (it=_reports.begin(); it!=_reports.end(); it++) {
    std::string s;

    s=QStringToUtf8String((*it)->name());
    if (strcasecmp(s.c_str(), name)==0)
      return *it;
  } // for

  return 0;
}



std::list<Report*> KBanking::getReports(){
  return _reports;
}



GWEN_DB_NODE *KBanking::getReportProfiles(Report *r) {
  GWEN_DB_NODE *db;
  GWEN_BUFFER *nbuf;
  std::string name;

  name=QStringToUtf8String(r->name());
  db=getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT,
                      "kbanking/reports");
  assert(db);
  nbuf=GWEN_Buffer_new(0, 256, 0, 1);
  if (GWEN_Text_EscapeToBuffer(name.c_str(), nbuf)) {
    DBG_ERROR(0, "Could not escape report name");
    GWEN_Buffer_free(nbuf);
    return 0;
  }
  GWEN_Buffer_AppendString(nbuf, "/profiles");
  db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT,
                      GWEN_Buffer_GetStart(nbuf));
  assert(db);
  GWEN_Buffer_free(nbuf);

  return db;
}



GWEN_DB_NODE *KBanking::findReportProfile(Report *r, const char *id){
  GWEN_DB_NODE *db;

  db=getReportProfiles(r);
  if (!db)
    return 0;
  db=GWEN_DB_FindFirstGroup(db, "profile");
  while(db) {
    const char *s;

    s=GWEN_DB_GetCharValue(db, "id", 0, 0);
    if (!s) {
      DBG_WARN(0, "Report with no id detected");
    }
    else {
      if (strcasecmp(s, id)==0)
        return db;
    }
    db=GWEN_DB_FindNextGroup(db, "profile");
  } // while

  return 0;
}



int KBanking::addReportProfile(Report *r, GWEN_DB_NODE *dbProfile){
  GWEN_DB_NODE *db;
  char numbuf[32];

  db=getReportProfiles(r);
  if (!db)
    return -1;

  snprintf(numbuf, sizeof(numbuf), "%d", ++_lastReportId);
  GWEN_DB_SetCharValue(dbProfile, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "id", numbuf);
  if (strcasecmp(GWEN_DB_GroupName(dbProfile), "profile")!=0)
    GWEN_DB_GroupRename(dbProfile, "profile");
  GWEN_DB_AddGroup(db, dbProfile);

  return 0;
}



void KBanking::removeReportProfile(Report *r,
                                   GWEN_DB_NODE *dbProfile){
  GWEN_DB_UnlinkGroup(dbProfile);
  GWEN_DB_Group_free(dbProfile);
}



void KBanking::_sampleReportModules(){
  Report *r;

  r=new SimpleReport(this);
  _reports.push_back(r);
  r=new SummaryReport(this);
  _reports.push_back(r);
  r=new CategoryReport(this);
  _reports.push_back(r);
}



void KBanking::addTransactionWindow(TransactionWindow *w) {
  _tWindows.push_back(w);
}



void KBanking::delTransactionWindow(TransactionWindow *w) {
  std::list<RefPointer<TransactionWindow> >::iterator it;

  for (it=_tWindows.begin();
       it!=_tWindows.end();
       it++) {
    if ((*it).ptr()==w) {
      // found
      _tWindows.erase(it);
      return;
    }
  }
}



void KBanking::delTransactionWindows() {
  std::list<RefPointer<TransactionWindow> >::iterator it;

  while(!_tWindows.empty()) {
    RefPointer<TransactionWindow> wp=_tWindows.front();
    wp.ref().close();
  }
}



std::string KBanking::tr(const char *s) {
  return QBanking::QStringToUtf8String(QWidget::tr(s));
}














