/***************************************************************************
 $RCSfile: kbanking.h,v $
                             -------------------
    cvs         : $Id: kbanking.h,v 1.24 2005/08/26 11:23:01 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef QBANKMANAGER_BANKING_H
#define QBANKMANAGER_BANKING_H

#include <qbanking/qbanking.h>
#include <gwenhywfar/nettransportssl.h>

#include <qobject.h>
#include <list>

class KBanking;
class TransactionWindow;
class MainWindow;
class WaitCallback;

#include <qbanking/qbanking.h>

#include "app.h"
#include "report.h"
#include "flagstaff.h"


class KBanking: public App {
private:
  MainWindow *_mainWindow;
  GWEN_TYPE_UINT32 _lastWidgetId;
  AB_BANKING_LOGLEVEL _logLevel;
  FlagStaff *_flagStaff;

  std::list<RefPointer<TransactionWindow> > _tWindows;

  /* variables from config file */
  std::list<Report*> _reports;
  unsigned int _lastReportId;

  /* private functions */
  void _sampleReportModules();

protected:
  virtual void infoTransactionsChanged(Account *a);
  virtual std::string tr(const char *s);

public:
  KBanking(const char *appname,
           const char *fname=0,
           const char *name=0);
  virtual ~KBanking();


  int init();
  int fini();

  FlagStaff *flagStaff();

  virtual bool importContext(AB_IMEXPORTER_CONTEXT *ctx,
                             GWEN_TYPE_UINT32 flags);
  void setMainWindow(MainWindow *w);
  MainWindow * getMainWindow();

  bool setTabWidget(const QString &name);

  int executeQueue();

  void transfersUpdated();
  void standingOrdersUpdated();

  void rebuildExportMenu();

  void invokeHelp(const char *subject);

  void addTransactionWindow(TransactionWindow *w);
  void delTransactionWindow(TransactionWindow *w);
  void delTransactionWindows();

  Report *findReport(const char *name);
  std::list<Report*> getReports();

  GWEN_DB_NODE *findReportProfile(Report *r, const char *id);
  GWEN_DB_NODE *getReportProfiles(Report *r);
  /** takes over ownership of the given group */
  int addReportProfile(Report *r, GWEN_DB_NODE *db);
  void removeReportProfile(Report *r,
                           GWEN_DB_NODE *dbProfile);

};




#endif /* QBANKMANAGER_BANKING_H */


