/***************************************************************************
 $RCSfile: report.cpp,v $
                             -------------------
    cvs         : $Id: report.cpp,v 1.4 2005/09/01 07:27:38 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "report.h"
#include "account.h"
#include "category.h"
#include "kbanking.h"
#include <qwidget.h>



Report::AccountData::AccountData(Account *a)
:_account(a){

}



Report::AccountData::~AccountData(){
  std::list<Report::Year*>::iterator it;

  for (it=_years.begin(); it!=_years.end(); it++) {
    delete (*it);
    return;
  }
}



void Report::AccountData::addYear(Report::Year *y){
  _years.push_back(y);
}



void Report::AccountData::addTransaction(RefPointer<Transaction> t){
  const GWEN_TIME *ti;
  int y, m, d;

  ti=t.ref().getDate();
  if (!ti)
    ti=t.ref().getValutaDate();
  if (!GWEN_Time_GetBrokenDownDate(ti, &d, &m, &y)) {
    std::list<Report::Year*>::iterator it;

    for (it=_years.begin(); it!=_years.end(); it++) {
      if ((*it)->getYear()==y) {
        (*it)->addTransaction(t);
        return;
      }
    }
    Year *yp=new Year(y);
    DBG_ERROR(0, "Adding year %4d", y);
    _years.push_back(yp);
    yp->addTransaction(t);
  }

}



void
Report::AccountData::gatherTransactions(std::list<RefPointer<Transaction> > &tl){
  std::list<Report::Year*>::iterator it;

  for (it=_years.begin(); it!=_years.end(); it++) {
    (*it)->gatherTransactions(tl);
  }
}





Report::CategoryData::CategoryData(Category *cat)
:_category(cat), _path(cat->getPath()), _value(AB_Value_new(0.0, 0)){
}



Report::CategoryData::~CategoryData(){
  std::list<Report::Year*>::iterator it;

  for (it=_years.begin(); it!=_years.end(); it++) {
    delete (*it);
    return;
  }
  AB_Value_free(_value);
}



void Report::CategoryData::addYear(Report::Year *y){
  _years.push_back(y);
}



void Report::CategoryData::addTransaction(RefPointer<Transaction> t){
  const GWEN_TIME *ti;
  int y, m, d;
  const AB_VALUE *v;

  /* add value if any */
  v=t.ref().getValue();
  if (v)
    AB_Value_AddValue(_value, v);

  ti=t.ref().getDate();
  if (!ti)
    ti=t.ref().getValutaDate();
  if (!GWEN_Time_GetBrokenDownDate(ti, &d, &m, &y)) {
    std::list<Report::Year*>::iterator it;

    for (it=_years.begin(); it!=_years.end(); it++) {
      if ((*it)->getYear()==y) {
        (*it)->addTransaction(t);
        return;
      }
    }
    Year *yp=new Year(y);
    DBG_ERROR(0, "Adding year %4d", y);
    _years.push_back(yp);
    yp->addTransaction(t);
  }

}



void
Report::CategoryData::gatherTransactions(std::list<RefPointer<Transaction> > &tl){
  std::list<Report::Year*>::iterator it;

  for (it=_years.begin(); it!=_years.end(); it++) {
    (*it)->gatherTransactions(tl);
  }
}






Report::Year::Year(int y)
:_year(y) {

}



Report::Year::~Year(){
  std::list<Report::Month*>::iterator it;

  for (it=_months.begin(); it!=_months.end(); it++) {
    delete (*it);
    return;
  }
}



void
Report::Year::addTransaction(RefPointer<Transaction> t){
  const GWEN_TIME *ti;
  int y, m, d;

  ti=t.ref().getDate();
  if (!ti)
    ti=t.ref().getValutaDate();
  if (!GWEN_Time_GetBrokenDownDate(ti, &d, &m, &y)) {
    std::list<Report::Month*>::iterator it;

    for (it=_months.begin(); it!=_months.end(); it++) {
      if ((*it)->getMonth()==m) {
        (*it)->addTransaction(t);
        return;
      }
    }
    Month *mp=new Month(y, m);
    DBG_ERROR(0, "Adding month %4d/%02d", y, m);
    _months.push_back(mp);
    mp->addTransaction(t);
  }
}



void
Report::Year::gatherTransactions(std::list<RefPointer<Transaction> > &tl){
  std::list<Report::Month*>::iterator it;

  for (it=_months.begin(); it!=_months.end(); it++) {
    (*it)->gatherTransactions(tl);
  }

}



void
Report::Year::addMonth(Report::Month *m){
  _months.push_back(m);
}



bool
Report::Year::operator<(const Report::Year &y){
  if (_year<y._year) {
    return true;
  }
  return false;
}







Report::Month::Month(int y, int m)
:_year(y), _month(m) {

}



Report::Month::~Month(){
  std::list<Report::Day*>::iterator it;

  for (it=_days.begin(); it!=_days.end(); it++) {
    delete (*it);
    return;
  }
}



void
Report::Month::addTransaction(RefPointer<Transaction> t){
  const GWEN_TIME *ti;
  int y, m, d;

  ti=t.ref().getDate();
  if (!ti)
    ti=t.ref().getValutaDate();
  if (!GWEN_Time_GetBrokenDownDate(ti, &d, &m, &y)) {
    std::list<Report::Day*>::iterator it;

    for (it=_days.begin(); it!=_days.end(); it++) {
      if ((*it)->getDay()==d) {
        (*it)->addTransaction(t);
        return;
      }
    }
    Day *dp=new Day(y, m, d);
    DBG_ERROR(0, "Adding day %4d/%02d/%02d", y, m, d);
    _days.push_back(dp);
    dp->addTransaction(t);
  }
}



void
Report::Month::gatherTransactions(std::list<RefPointer<Transaction> > &tl){
  std::list<Report::Day*>::iterator it;

  for (it=_days.begin(); it!=_days.end(); it++) {
    std::list<RefPointer<Transaction> >::iterator tit;

    for (tit=(*it)->transactions().begin();
         tit!=(*it)->transactions().end();
         tit++)
      tl.push_back(*tit);
  }

}



void
Report::Month::addDay(Report::Day *d){
  _days.push_back(d);
}



bool
Report::Month::operator<(const Report::Month &m){
  if (_year<m._year)
    return true;
  else if (_year==m._year) {
    if (_month<m._month)
      return true;
  }
  return false;
}







Report::Day::Day(int y, int m, int d)
:_year(y), _month(m), _day(d) {
}



std::list<RefPointer<Transaction> >&
Report::Day::transactions(){
  return _transactions;
}



void
Report::Day::addTransaction(RefPointer<Transaction> t){
  _transactions.push_back(t);
}



bool
Report::Day::operator<(const Report::Day &d){
  if (_year<d._year)
    return true;
  else if (_year==d._year) {
    if (_month<d._month)
      return true;
    else if (_month==d._month) {
      if (_day<d._day)
        return true;
    }
  }
  return false;
}













Report::Report(KBanking *app, const QString &name)
:_app(app), _name(name){

}



Report::~Report(){
}



const QString &Report::name() const {
  return _name;
}



KBanking *Report::app() const {
  return _app;
}



QString Report::shortDescription(){
  return QString::null;
}



QString Report::longDescription(){
  return QString::null;
}



bool Report::initProfile(GWEN_DB_NODE *dbProfile, QWidget *parent){
  return false;
}



bool Report::editProfile(GWEN_DB_NODE *dbProfile, QWidget *parent){
  return false;
}



bool Report::useProfile(GWEN_DB_NODE *dbProfile, QWidget *parent){
  return false;
}



QString Report::tr(const char *s1, const char *s2) {
  return QWidget::tr(s1, s2);
}



void Report::addTransaction(std::list<Report::AccountData*> &adl,
                            RefPointer<Transaction> t,
                            bool mixAccounts){
  std::list<AccountData*>::iterator it;
  Account *a=0;
  std::string bankCode;
  std::string accountId;

  if (mixAccounts) {
    bankCode="";
    accountId="";
  }
  else {
    bankCode=t.ref().getLocalBankCode();
    accountId=t.ref().getLocalAccountNumber();
  }

  for (it=adl.begin(); it!=adl.end(); it++) {
    if (mixAccounts) {
      (*it)->addTransaction(t);
      return;
    }
    else {
      a=(*it)->getAccount();
      assert(a);
      if (strcasecmp(a->getBankCode().c_str(),
		     bankCode.c_str())==0 &&
	  strcasecmp(a->getAccountNumber().c_str(),
		     accountId.c_str())==0) {
	(*it)->addTransaction(t);
	return;
      }
    }
  }

  if (mixAccounts) {
    AccountData *ap=new AccountData(0);
    DBG_ERROR(0, "Adding fake account");
    adl.push_back(ap);
    ap->addTransaction(t);
  }
  else {
    a=_app->findAccount(bankCode.c_str(),
			accountId.c_str());
    if (a) {
      AccountData *ap=new AccountData(a);
      DBG_ERROR(0, "Adding account");
      adl.push_back(ap);
      ap->addTransaction(t);
    }
    else {
      DBG_ERROR(0, "Account not found");
    }
  }
}



void Report::freeAccountDataList(std::list<Report::AccountData*> &adl){
  std::list<AccountData*>::iterator it;

  for (it=adl.begin(); it!=adl.end(); it++) {
    delete *it;
  } // for
  adl.clear();
}



void Report::gatherTransactions(std::list<Report::AccountData*> &adl,
                                std::list<RefPointer<Transaction> > &tl){
  std::list<AccountData*>::iterator it;

  for (it=adl.begin(); it!=adl.end(); it++) {
    (*it)->gatherTransactions(tl);
  } // for
}



void Report::addTransaction(std::list<CategoryData*> &cdl,
                            RefPointer<Transaction> t) {
  std::list<CategoryData*>::iterator it;
  Category *cd=0;
  std::string id;

  id=t.ref().getCategory();
  if (id.empty()) {
    DBG_ERROR(0, "No category set in transaction");
    return;
  }

  for (it=cdl.begin(); it!=cdl.end(); it++) {
    cd=(*it)->getCategory();
    assert(cd);
    if (strcasecmp(cd->getId().c_str(),
                   id.c_str())==0) {
      (*it)->addTransaction(t);
      return;
    }
  }

  cd=_app->findCategoryById(id.c_str());
  if (cd) {
    CategoryData *cp=new CategoryData(cd);
    DBG_ERROR(0, "Adding category");
    cdl.push_back(cp);
    cp->addTransaction(t);
  }
  else {
    DBG_ERROR(0, "Category not found");
  }
}



void freeCategoryDataList(std::list<Report::CategoryData*> &cdl) {
  std::list<Report::CategoryData*>::iterator it;

  for (it=cdl.begin(); it!=cdl.end(); it++) {
    delete *it;
  } // for
  cdl.clear();
}



void Report::gatherTransactions(std::list<Report::CategoryData*> &cdl,
                                std::list<RefPointer<Transaction> > &tl){
  std::list<CategoryData*>::iterator it;

  for (it=cdl.begin(); it!=cdl.end(); it++) {
    (*it)->gatherTransactions(tl);
  } // for
}





void Report::sortYears(std::list<Report::Year*> &yl) {
  std::list<Year*>::iterator it1;
  bool replaced;

  do {
    replaced=false;
    for (it1=yl.begin(); it1!=yl.end(); it1++) {
      std::list<Report::Year*>::iterator it2;

      it2=it1;
      it2++;
      if (it2!=yl.end()) {
        if (*(*it2)<*(*it1)) {
          Year *tmp;

          tmp=*it1;
          *it1=*it2;
          *it2=tmp;
          replaced=true;
        }
      }
    }

  } while(replaced);
}



void Report::sortMonths(std::list<Report::Month*> &ml){
  std::list<Month*>::iterator it1;
  bool replaced;

  do {
    replaced=false;
    for (it1=ml.begin(); it1!=ml.end(); it1++) {
      std::list<Report::Month*>::iterator it2;

      it2=it1;
      it2++;
      if (it2!=ml.end()) {
        if (*(*it2)<*(*it1)) {
          Month *tmp;

          tmp=*it1;
          *it1=*it2;
          *it2=tmp;
          replaced=true;
        }
      }
    }

  } while(replaced);
}



void Report::sortDays(std::list<Report::Day*> &dl){
  std::list<Day*>::iterator it1;
  bool replaced;

  do {
    replaced=false;
    for (it1=dl.begin(); it1!=dl.end(); it1++) {
      std::list<Report::Day*>::iterator it2;

      it2=it1;
      it2++;
      if (it2!=dl.end()) {
        if (*(*it2)<*(*it1)) {
          Day *tmp;

          tmp=*it1;
          *it1=*it2;
          *it2=tmp;
          replaced=true;
        }
      }
    }

  } while(replaced);
}



void Report::sortTransactions(std::list<RefPointer<Transaction> > &tl){
  std::list<RefPointer<Transaction> >::iterator it1;
  bool replaced;

  do {
    replaced=false;
    for (it1=tl.begin(); it1!=tl.end(); it1++) {
      std::list<RefPointer<Transaction> >::iterator it2;

      it2=it1;
      it2++;
      if (it2!=tl.end()) {
        if ((*it2).ref()<(*it1).ref()) {
          RefPointer<Transaction> tmp;

          tmp=*it1;
          *it1=*it2;
          *it2=tmp;
          replaced=true;
        }
      }
    }

  } while(replaced);
}



void Report::sortCategories(std::list<Report::CategoryData*> &dl){
  std::list<CategoryData*>::iterator it1;
  bool replaced;

  do {
    replaced=false;
    for (it1=dl.begin(); it1!=dl.end(); it1++) {
      std::list<CategoryData*>::iterator it2;

      it2=it1;
      it2++;
      if (it2!=dl.end()) {
        if (strcasecmp((*it2)->getPath().c_str(),
                       (*it1)->getPath().c_str())<0) {
          CategoryData *tmp;

          tmp=*it1;
          *it1=*it2;
          *it2=tmp;
          replaced=true;
        }
      }
    }

  } while(replaced);
}







