/***************************************************************************
 $RCSfile: selectcategory.h,v $
                             -------------------
    cvs         : $Id: selectcategory.h,v 1.2 2005/09/05 05:13:21 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_SELECTCATEGORY_H
#define AQBANKING_KDE_SELECTCATEGORY_H

class KBanking;
class Category;
class Transaction;



#include "selectcategory.ui.h"

#include <string>



class SelectCategory : public SelectCategoryUi {
  Q_OBJECT
public:
  SelectCategory(KBanking *kb,
              Transaction *t,
              QWidget* parent=0,
              const char* name=0,
              bool modal=FALSE,
              WFlags fl=0);
  ~SelectCategory();

  void init();
  void fini();

  Category *selectedCategory();

  static Category *selectCategory(KBanking *kb,
                                  const QString &title,
                                  const QString &text,
                                  QWidget* parent=0);

  static Category *assignCategory(KBanking *kb,
                                  Transaction *t,
                                  bool &aborted,
                                  bool &askNoMore,
                                  QWidget* parent=0);
  static Category *assignSingleCategory(KBanking *kb,
                                        Transaction *t,
                                        bool &aborted,
                                        QWidget* parent);

public slots:
  void slotAssignSelected();
  void slotNew();
  void slotAbort();
  void slotEdit();

private:
  KBanking *_app;
  Category *_category;
  Transaction *_transaction;
  bool _aborted;
};





#endif
