/***************************************************************************
 $RCSfile: rtlist.h,v $
                             -------------------
    cvs         : $Id: rtlist.h,v 1.1 2006/03/10 02:20:53 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef RTLIST_H
#define RTLIST_H

#include "refpointer.h"

#include <qlistview.h>
#include <qvaluelist.h>
#include <qstring.h>


class QSimpleRichText;
class RichTextListViewItem;
class RichTextListView;


class RichTextListViewItem: public QListViewItem {
private:
  class Column {
  public:
    Column() {width=0; height=0;} ;
    ~Column() {};
    QString text;
    unsigned int width;
    unsigned int height;
  };

  QValueList<struct Column> _columns;
  QString _colour;
  unsigned long _id;

  RefPointer<QSimpleRichText> _prepareRichText(int col);
  void _adjustHeight();

public:
  RichTextListViewItem(RichTextListView *parent);
  RichTextListViewItem(RichTextListView *parent,
                       RichTextListViewItem *after);

  virtual ~RichTextListViewItem();

  void setText(int col, const QString &text);
  QString text(int col) const;

  unsigned long id() const;


  virtual void paintCell(QPainter * p,
                         const QColorGroup & cg,
                         int column,
                         int width,
                         int align);
  virtual int width(const QFontMetrics &,
                    const QListView *,
                    int column) const;
  virtual void setup();
  virtual QString key(int column, bool ascending) const;

  void setColour(const QString &c);

protected:
  virtual void setupColumn(int col);

};




class RichTextListView: public QListView {
  Q_OBJECT
public:
  typedef enum {
    DrawMode_Slow=0,
    DrawMode_Fast,
    DrawMode_Fastest
  } DrawMode;
private:
  unsigned long _lastId;
  DrawMode _drawMode;
public:
  RichTextListView(QWidget *parent=0, const char *name=0);
  virtual ~RichTextListView();

  void setDrawMode(DrawMode);
  DrawMode drawMode() const;

  unsigned long nextId();

public slots:
  virtual void slotHeaderChanged(int section,
                                 int oldSize,
                                 int newSize);
};



#endif
