/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: report.cpp 433 2008-01-12 08:58:57Z martin $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "report.h"
#include "account.h"
#include "category.h"
#include "kbanking.h"
#include <qwidget.h>



Report::GenericData::GenericData(){

}



Report::GenericData::~GenericData(){
  std::list<Report::Year*>::iterator it;

  for (it=_years.begin(); it!=_years.end(); it++) {
    delete (*it);
    return;
  }
}



void Report::GenericData::addYear(Report::Year *y){
  _years.push_back(y);
}



void Report::GenericData::addTransaction(RefPointer<Transaction> t){
  const GWEN_TIME *ti;
  int y, m, d;

  ti=t.ref().getDate();
  if (!ti)
    ti=t.ref().getValutaDate();
  if (!GWEN_Time_GetBrokenDownDate(ti, &d, &m, &y)) {
    std::list<Report::Year*>::iterator it;

    for (it=_years.begin(); it!=_years.end(); it++) {
      if ((*it)->getYear()==y) {
        (*it)->addTransaction(t);
        return;
      }
    }
    Year *yp=new Year(y);
    DBG_ERROR(0, "Adding year %4d", y);
    _years.push_back(yp);
    yp->addTransaction(t);
  }

}



void
Report::GenericData::gatherTransactions(std::list<RefPointer<Transaction> > &tl){
  std::list<Report::Year*>::iterator it;

  for (it=_years.begin(); it!=_years.end(); it++) {
    (*it)->gatherTransactions(tl);
  }
}



QDate Report::GenericData::getFirstDate() const {
  if (!_years.empty()) {
    Report::Year *y;
    Report::Month *m;
    Report::Day *d;

    y=_years.front();
    m=y->months().front();
    d=m->days().front();
    return QDate(y->getYear(), m->getMonth(), d->getDay());
  }
  return QDate();
}



QDate Report::GenericData::getLastDate() const {
  if (!_years.empty()) {
    Report::Year *y;
    Report::Month *m;
    Report::Day *d;

    y=_years.back();
    m=y->months().back();
    d=m->days().back();
    return QDate(y->getYear(), m->getMonth(), d->getDay());
  }
  return QDate();
}



void Report::GenericData::getMinAndMaxValues(double &minVal, double &maxVal) {
  std::list<RefPointer<Transaction> > tl;
  std::list<RefPointer<Transaction> >::iterator it;

  minVal=0.0;
  maxVal=0.0;
  gatherTransactions(tl);
  for (it=tl.begin(); it!=tl.end(); it++) {
    const AB_VALUE *v;

    v=(*it).ref().getValue();
    if (v) {
      double dv;

      dv=AB_Value_GetValueAsDouble(v);
      if (dv<minVal)
        minVal=dv;
      if (dv>maxVal)
        maxVal=dv;
    }
  }
}



void Report::GenericData::sort() {
  std::list<Report::Year*>::iterator it;

  for (it=_years.begin(); it!=_years.end(); it++) {
    (*it)->sort();
  }
}



Report::Year *Report::GenericData::findYear(int y) {
  std::list<Year*>::iterator it1;

  for (it1=_years.begin(); it1!=_years.end(); it1++)
    if ((*it1)->getYear()==y)
      return *it1;
  return 0;
}



Report::Day *Report::GenericData::findDay(int y, int m, int d) {
  Year *year;

  year=findYear(y);
  if (year)
    return year->findDay(m, d);
  return 0;
}






Report::AccountData::AccountData(Account *a)
:Report::GenericData()
, _account(a){

}



Report::AccountData::~AccountData(){
}




Report::CategoryData::CategoryData(Category *cat)
:_category(cat), _path(cat->getPath()), _value(AB_Value_new()){
}



Report::CategoryData::~CategoryData(){
  AB_Value_free(_value);
}



void Report::CategoryData::addTransaction(RefPointer<Transaction> t){
  const AB_VALUE *v;

  v=t.ref().getValue();
  if (v)
    AB_Value_AddValue(_value, v);
  GenericData::addTransaction(t);
}







Report::Year::Year(int y)
:_year(y) {

}



Report::Year::~Year(){
  std::list<Report::Month*>::iterator it;

  for (it=_months.begin(); it!=_months.end(); it++) {
    delete (*it);
    return;
  }
}



void
Report::Year::addTransaction(RefPointer<Transaction> t){
  const GWEN_TIME *ti;
  int y, m, d;

  ti=t.ref().getDate();
  if (!ti)
    ti=t.ref().getValutaDate();
  if (!GWEN_Time_GetBrokenDownDate(ti, &d, &m, &y)) {
    std::list<Report::Month*>::iterator it;

    for (it=_months.begin(); it!=_months.end(); it++) {
      if ((*it)->getMonth()==m) {
        (*it)->addTransaction(t);
        return;
      }
    }
    Month *mp=new Month(y, m);
    DBG_ERROR(0, "Adding month %4d/%02d", y, m);
    _months.push_back(mp);
    mp->addTransaction(t);
  }
}



void
Report::Year::gatherTransactions(std::list<RefPointer<Transaction> > &tl){
  std::list<Report::Month*>::iterator it;

  for (it=_months.begin(); it!=_months.end(); it++) {
    (*it)->gatherTransactions(tl);
  }

}



void
Report::Year::addMonth(Report::Month *m){
  _months.push_back(m);
}



bool
Report::Year::operator<(const Report::Year &y){
  if (_year<y._year) {
    return true;
  }
  return false;
}



void Report::Year::sortMonths() {
  std::list<Month*>::iterator it1;
  bool replaced;

  do {
    replaced=false;
    for (it1=_months.begin(); it1!=_months.end(); it1++) {
      std::list<Report::Month*>::iterator it2;

      it2=it1;
      it2++;
      if (it2!=_months.end()) {
        if (*(*it2)<*(*it1)) {
          Month *tmp;

          tmp=*it1;
          *it1=*it2;
          *it2=tmp;
          replaced=true;
        }
      }
    }

  } while(replaced);
}



void Report::Year::sort() {
  std::list<Month*>::iterator it1;

  sortMonths();
  for (it1=_months.begin(); it1!=_months.end(); it1++)
    (*it1)->sort();
}



Report::Month *Report::Year::findMonth(int m) {
  std::list<Month*>::iterator it1;

  for (it1=_months.begin(); it1!=_months.end(); it1++)
    if ((*it1)->getMonth()==m)
      return *it1;
  return 0;
}



Report::Day *Report::Year::findDay(int m, int d) {
  Month *month;

  month=findMonth(m);
  if (month)
    return month->findDay(d);
  return 0;
}







Report::Month::Month(int y, int m)
:_year(y), _month(m) {

}



Report::Month::~Month(){
  std::list<Report::Day*>::iterator it;

  for (it=_days.begin(); it!=_days.end(); it++) {
    delete (*it);
    return;
  }
}



void
Report::Month::addTransaction(RefPointer<Transaction> t){
  const GWEN_TIME *ti;
  int y, m, d;

  ti=t.ref().getDate();
  if (!ti)
    ti=t.ref().getValutaDate();
  if (!GWEN_Time_GetBrokenDownDate(ti, &d, &m, &y)) {
    std::list<Report::Day*>::iterator it;

    for (it=_days.begin(); it!=_days.end(); it++) {
      if ((*it)->getDay()==d) {
        (*it)->addTransaction(t);
        return;
      }
    }
    Day *dp=new Day(y, m, d);
    DBG_ERROR(0, "Adding day %4d/%02d/%02d", y, m, d);
    _days.push_back(dp);
    dp->addTransaction(t);
  }
}



void
Report::Month::gatherTransactions(std::list<RefPointer<Transaction> > &tl){
  std::list<Report::Day*>::iterator it;

  for (it=_days.begin(); it!=_days.end(); it++) {
    std::list<RefPointer<Transaction> >::iterator tit;

    for (tit=(*it)->transactions().begin();
         tit!=(*it)->transactions().end();
         tit++)
      tl.push_back(*tit);
  }

}



void
Report::Month::addDay(Report::Day *d){
  _days.push_back(d);
}



bool
Report::Month::operator<(const Report::Month &m){
  if (_year<m._year)
    return true;
  else if (_year==m._year) {
    if (_month<m._month)
      return true;
  }
  return false;
}



void Report::Month::sortDays() {
  std::list<Day*>::iterator it1;
  bool replaced;

  do {
    replaced=false;
    for (it1=_days.begin(); it1!=_days.end(); it1++) {
      std::list<Report::Day*>::iterator it2;

      it2=it1;
      it2++;
      if (it2!=_days.end()) {
        if (*(*it2)<*(*it1)) {
          Day *tmp;

          tmp=*it1;
          *it1=*it2;
          *it2=tmp;
          replaced=true;
        }
      }
    }

  } while(replaced);
}



void Report::Month::sort() {
  std::list<Day*>::iterator it1;

  for (it1=_days.begin(); it1!=_days.end(); it1++)
    (*it1)->sortTransactions();
  sortDays();
}



Report::Day *Report::Month::findDay(int d) {
  std::list<Day*>::iterator it1;

  for (it1=_days.begin(); it1!=_days.end(); it1++)
    if ((*it1)->getDay()==d)
      return *it1;
  return 0;
}





Report::Day::Day(int y, int m, int d)
:_year(y), _month(m), _day(d) {
}



std::list<RefPointer<Transaction> >&
Report::Day::transactions(){
  return _transactions;
}



void
Report::Day::addTransaction(RefPointer<Transaction> t){
  _transactions.push_back(t);
}



bool
Report::Day::operator<(const Report::Day &d){
  if (_year<d._year)
    return true;
  else if (_year==d._year) {
    if (_month<d._month)
      return true;
    else if (_month==d._month) {
      if (_day<d._day)
        return true;
    }
  }
  return false;
}



void Report::Day::sortTransactions() {
  Report::sortTransactions(_transactions);
}












Report::Report(KBanking *app, const QString &name)
:_app(app), _name(name){

}



Report::~Report(){
}



const QString &Report::name() const {
  return _name;
}



KBanking *Report::app() const {
  return _app;
}



QString Report::shortDescription(){
  return QString::null;
}



QString Report::longDescription(){
  return QString::null;
}



bool Report::initProfile(GWEN_DB_NODE *dbProfile, QWidget *parent){
  return false;
}



bool Report::editProfile(GWEN_DB_NODE *dbProfile, QWidget *parent){
  return false;
}



bool Report::useProfile(GWEN_DB_NODE *dbProfile, QWidget *parent){
  return false;
}



QString Report::tr(const char *s1, const char *s2) {
  return QWidget::tr(s1, s2);
}



void Report::addTransaction(std::list<Report::AccountData*> &adl,
                            RefPointer<Transaction> t,
                            bool mixAccounts){
  std::list<AccountData*>::iterator it;
  Account *a=0;
  std::string bankCode;
  std::string accountId;

  if (mixAccounts) {
    bankCode="";
    accountId="";
  }
  else {
    bankCode=t.ref().getLocalBankCode();
    accountId=t.ref().getLocalAccountNumber();
  }

  for (it=adl.begin(); it!=adl.end(); it++) {
    if (mixAccounts) {
      (*it)->addTransaction(t);
      return;
    }
    else {
      a=(*it)->getAccount();
      assert(a);
      if (strcasecmp(a->getBankCode().c_str(),
		     bankCode.c_str())==0 &&
	  strcasecmp(a->getAccountNumber().c_str(),
		     accountId.c_str())==0) {
	(*it)->addTransaction(t);
	return;
      }
    }
  }

  if (mixAccounts) {
    AccountData *ap=new AccountData(0);
    DBG_ERROR(0, "Adding fake account");
    adl.push_back(ap);
    ap->addTransaction(t);
  }
  else {
    a=_app->findAccount(bankCode.c_str(),
			accountId.c_str());
    if (a) {
      AccountData *ap=new AccountData(a);
      DBG_ERROR(0, "Adding account");
      adl.push_back(ap);
      ap->addTransaction(t);
    }
    else {
      DBG_ERROR(0, "Account not found");
    }
  }
}



void Report::freeAccountDataList(std::list<Report::AccountData*> &adl){
  std::list<AccountData*>::iterator it;

  for (it=adl.begin(); it!=adl.end(); it++) {
    delete *it;
  } // for
  adl.clear();
}



void Report::gatherTransactions(std::list<Report::AccountData*> &adl,
                                std::list<RefPointer<Transaction> > &tl){
  std::list<AccountData*>::iterator it;

  for (it=adl.begin(); it!=adl.end(); it++) {
    (*it)->gatherTransactions(tl);
  } // for
}



void Report::addTransaction(std::list<CategoryData*> &cdl,
                            RefPointer<Transaction> t) {
  std::list<CategoryData*>::iterator it;
  Category *cd=0;
  std::string id;

  id=t.ref().getCategory();
  if (id.empty()) {
    DBG_ERROR(0, "No category set in transaction");
    return;
  }

  for (it=cdl.begin(); it!=cdl.end(); it++) {
    cd=(*it)->getCategory();
    assert(cd);
    if (strcasecmp(cd->getId().c_str(),
                   id.c_str())==0) {
      (*it)->addTransaction(t);
      return;
    }
  }

  cd=_app->findCategoryById(id.c_str());
  if (cd) {
    CategoryData *cp=new CategoryData(cd);
    DBG_ERROR(0, "Adding category");
    cdl.push_back(cp);
    cp->addTransaction(t);
  }
  else {
    DBG_ERROR(0, "Category not found");
  }
}



void freeCategoryDataList(std::list<Report::CategoryData*> &cdl) {
  std::list<Report::CategoryData*>::iterator it;

  for (it=cdl.begin(); it!=cdl.end(); it++) {
    delete *it;
  } // for
  cdl.clear();
}



void Report::gatherTransactions(std::list<Report::CategoryData*> &cdl,
                                std::list<RefPointer<Transaction> > &tl){
  std::list<CategoryData*>::iterator it;

  for (it=cdl.begin(); it!=cdl.end(); it++) {
    (*it)->gatherTransactions(tl);
  } // for
}



void Report::sortCategories(std::list<Report::CategoryData*> &dl){
  std::list<CategoryData*>::iterator it1;
  bool replaced;

  do {
    replaced=false;
    for (it1=dl.begin(); it1!=dl.end(); it1++) {
      std::list<CategoryData*>::iterator it2;

      it2=it1;
      it2++;
      if (it2!=dl.end()) {
        if (strcasecmp((*it2)->getPath().c_str(),
                       (*it1)->getPath().c_str())<0) {
          CategoryData *tmp;

          tmp=*it1;
          *it1=*it2;
          *it2=tmp;
          replaced=true;
        }
      }
    }

  } while(replaced);
}



void Report::sortTransactions(std::list<RefPointer<Transaction> > &tl) {
  std::list<RefPointer<Transaction> >::iterator it1;
  bool replaced;

  do {
    replaced=false;
    for (it1=tl.begin(); it1!=tl.end(); it1++) {
      std::list<RefPointer<Transaction> >::iterator it2;

      it2=it1;
      it2++;
      if (it2!=tl.end()) {
        if ((*it2).ref()<(*it1).ref()) {
          RefPointer<Transaction> tmp;

          tmp=*it1;
          *it1=*it2;
          *it2=tmp;
          replaced=true;
        }
      }
    }

  } while(replaced);

}













