/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_EDITSTO_H
#define AQBANKING_KDE_EDITSTO_H

class KBanking;


#include "editsto.ui.h"
#include "standingorder.h"
#include "refpointer.h"



class EditStandingOrder: public EditStandingOrderUi {
  Q_OBJECT
public:
  EditStandingOrder(KBanking *app,
                    RefPointer<StandingOrder> t,
                    bool createMode,
                    QWidget* parent=0,
                    const char* name=0,
                    bool modal=false,
                    WFlags fl=0);
  ~EditStandingOrder();

  static bool createStandingOrder(KBanking *app,
                                  RefPointer<StandingOrder> t,
                                  const QString &title,
                                  QWidget* parent=0,
                                  bool modal=false,
                                  WFlags fl=0);

  static bool modifyStandingOrder(KBanking *app,
                                  RefPointer<StandingOrder> t,
                                  const QString &title,
                                  QWidget* parent=0,
                                  bool modal=false,
                                  WFlags fl=0);

public slots:
  void accept();
  void reject();
  void slotBankCode();
  void slotAccountChanged(int i);
  void slotGetBankCode();
  void slotGetPayee();
  void slotMonthlyToggled(bool on);
  void slotWeeklyToggled(bool on);
  void slotAdjustStartDate(int idx);

private:
  KBanking *_app;
  bool _isCreateMode;
  bool _allowChangePeriod;
  bool _allowChangeCycle;
  bool _allowChangeDay;
  int _minDelay;
  int _maxDelay;
  RefPointer<StandingOrder> _transfer;
  int _maxPurpose;

  void _setComboTextNoDup(QComboBox *qb, const QString &s);
  void _setComboTextIfPossible(QComboBox *qb,
                               const QString &s);

  static QString _tr(const char * sourceText);

};







#endif // AQBANKING_KDE_EDITSTO_H


