/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "selectplugin.h"
#include <qbanking/qbplugindescrlist.h>

#include <qwidget.h>
#include <qstring.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>

#include <gwenhywfar/debug.h>

#ifdef WIN32
# define strcasecmp stricmp
#endif



SelectPlugin::SelectPlugin(KBanking *kb,
                           const QString &title,
                           GWEN_PLUGIN_DESCRIPTION_LIST2 *plist,
                           const char *name,
                           QWidget* parent,
                           const char* wname,
                           bool modal,
                           WFlags fl)
:SelectPluginUI(parent, wname, modal, fl)
,_app(kb)
,_plugins(plist) {
  QBPluginDescrListViewItem *entry;

  okButton->setEnabled(false);
  pluginDescrList->addPluginDescrs(plist);

  if (name) {
    QListViewItemIterator it(pluginDescrList);
    // iterate through all items of the listview
    for (;it.current();++it) {
      entry=dynamic_cast<QBPluginDescrListViewItem*>(it.current());
      if (entry) {
        GWEN_PLUGIN_DESCRIPTION *pd;

        pd=entry->getPluginDescr();
        if (pd) {
          const char *s;

          s=GWEN_PluginDescription_GetName(pd);
          assert(s);
          if (strcasecmp(s, name)==0) {
            it.current()->setSelected(true);
            pluginDescrList->setCurrentItem(it.current());
            okButton->setEnabled(true);
            break;
          }
        }
      }
    } // for
  }

  connect(pluginDescrList, SIGNAL(selectionChanged()),
          this, SLOT(slotSelectionChanged()));


}


SelectPlugin::~SelectPlugin(){
}



GWEN_PLUGIN_DESCRIPTION *SelectPlugin::getSelectedPlugin(){
  std::list<GWEN_PLUGIN_DESCRIPTION*> pl;

  pl=pluginDescrList->getSelectedPluginDescrs();
  if (pl.empty())
    return 0;
  return pl.front();
}



void SelectPlugin::slotSelectionChanged() {
  QListViewItemIterator it(pluginDescrList);

  for (;it.current();++it) {
    if (it.current()->isSelected()) {
      okButton->setEnabled(true);
      return;
    }
  } // for
  okButton->setEnabled(false);
}







