/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "mainwindow.h"
#include "kbanking.h"

#include "splash.inc"

#include <qbanking/qbgui.h>

#include <qapplication.h>
#include <qmessagebox.h>

#include <gwenhywfar/debug.h>
#include <gwenhywfar/gwenhywfar.h>

#include <qregexp.h>
#include <qvalidator.h>
#include <qtranslator.h>
#include <qtextcodec.h>
#include <qpixmap.h>
#include <qsplashscreen.h>


#include "rtlist.h"


int test1(int argc, char **argv) {
  QApplication a(argc, argv);
  RichTextListView *lv;
  int i;

  lv=new RichTextListView();
  lv->addColumn("Column1");
  lv->addColumn("Column2");
  lv->addColumn("Column3");
  lv->addColumn("Column4");
  lv->addColumn("Column5");
  lv->addColumn("Column6");
  lv->addColumn("Column7");

  DBG_ERROR(0, "Adding lines...");
  for (i=0; i<1000; i++) {
    RichTextListViewItem *item;
    char numbuf[32];

    QString ns;
    snprintf(numbuf, sizeof(numbuf), "%04d", i);
    ns=QString(numbuf);
    item=new RichTextListViewItem(lv);

    item->setText(0,
                  QString("<qt>%1</qt>")
                  .arg(ns));
    item->setText(1,
                  QString("<qt>This is the <b>first</b> value number <font color=\"red\">%1</font>.</qt>")
                  .arg(ns));
    item->setText(2,
                  QString("<qt>This is <b>second</b> value number <font color=\"red\">%1</font>.</qt>")
                  .arg(ns));
    item->setText(3,
                  QString("<qt>This is <b>third</b> value number <font color=\"red\">%1</font>.</qt>")
                  .arg(ns));
    item->setText(4,
                  QString("<qt>This is <b>fourth</b> value number <font color=\"red\">%1</font>.</qt>")
                  .arg(ns));
    item->setText(5,
                  QString("<qt>This is <b>fifth</b> value number <font color=\"red\">%1</font>.</qt>")
                  .arg(ns));
    item->setText(6,
                  QString("<qt>This is <b>sixth</b> value number <font color=\"red\">%1</font>.</qt>")
                  .arg(ns));
  }
  DBG_ERROR(0, "Done adding");

  a.setMainWidget(lv);
  lv->show();
  a.exec();

  return 0;
}


#include "txlist.h"
#include <qdatetime.h>

int test2(int argc, char **argv) {
  QApplication a(argc, argv);
  KBanking *kb;
  int rv;
  int err;
  QTime startTime;
  QTime endTime;

  err=GWEN_Init();
  if (err) {
    DBG_ERROR_ERR(0, err);
    return 2;
  }

  GWEN_Logger_Open(0,
                   "QBankManager", 0,
		   GWEN_LoggerType_Console,
                   GWEN_LoggerFacility_User);

  kb=new KBanking("QBankManager");

  rv=kb->init();
  if (rv) {
    DBG_ERROR(0, "Error on KBanking::init: %d", rv);
    QMessageBox::critical(0,
                          QWidget::tr("Initialization Error"),
                          QWidget::tr("<qt>"
                                      "Could not initialize KBanking."
                                      "</qt>"
                                     ),
                          QWidget::tr("Dismiss"));
    return 2;
  }

  TransactionListView2 *lv;
  Account *account;
  std::list<RefPointer<Transaction> > xl;

  account=kb->findAccount("28250110", "0002728194");
  assert(account);
  lv=new TransactionListView2(kb, true);
  lv->resize(800, 600);
  for (int i=0; i<7; i++)
    lv->setColumnWidth(i, 10);
  a.setMainWidget(lv);
  xl=account->getTransactions();
  DBG_ERROR(0, "Got %d transactions", xl.size());
  DBG_ERROR(0, "Adding transactions...");
  lv->setDrawMode(RichTextListView::DrawMode_Fastest);
  startTime=QTime::currentTime();
  lv->addTransactions(xl);
  DBG_ERROR(0, "Adding transactions: done.");
  DBG_ERROR(0, "Show transactions...");
  lv->show();
  endTime=QTime::currentTime();
  DBG_ERROR(0, "Show transactions: done (%d msecs).",
            startTime.msecsTo(endTime));

  a.connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));
  a.exec();

  return 0;
}


#include "transactionlist.h"

int test3(int argc, char **argv) {
  QApplication a(argc, argv);
  KBanking *kb;
  int rv;
  int err;
  QTime startTime;
  QTime endTime;

  err=GWEN_Init();
  if (err) {
    DBG_ERROR_ERR(0, err);
    return 2;
  }

  GWEN_Logger_Open(0,
                   "QBankManager", 0,
                   GWEN_LoggerType_Console,
                   GWEN_LoggerFacility_User);

  kb=new KBanking("QBankManager");

  rv=kb->init();
  if (rv) {
    DBG_ERROR(0, "Error on KBanking::init: %d", rv);
    QMessageBox::critical(0,
                          QWidget::tr("Initialization Error"),
                          QWidget::tr("<qt>"
                                      "Could not initialize KBanking."
                                      "</qt>"
                                     ),
                          QWidget::tr("Dismiss"));
    return 2;
  }

  TransactionListView *lv;
  Account *account;
  std::list<RefPointer<Transaction> > xl;

  account=kb->findAccount("28250110", "0002728194");
  assert(account);
  lv=new TransactionListView(kb, true);
  lv->resize(800, 600);
  for (int i=0; i<7; i++)
    lv->setColumnWidth(i, 10);
  a.setMainWidget(lv);
  xl=account->getTransactions();
  DBG_ERROR(0, "Got %d transactions", xl.size());
  DBG_ERROR(0, "Adding transactions...");
  startTime=QTime::currentTime();
  lv->addTransactions(xl);
  DBG_ERROR(0, "Adding transactions: done.");
  DBG_ERROR(0, "Show transactions...");
  lv->show();
  endTime=QTime::currentTime();
  DBG_ERROR(0, "Show transactions: done (%d msecs).",
            startTime.msecsTo(endTime));

  a.connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));
  a.exec();

  return 0;
}



#include "transactionview.h"
#include <qdatetime.h>

int test4(int argc, char **argv) {
  QApplication a(argc, argv);
  KBanking *kb;
  int rv;
  int err;

  err=GWEN_Init();
  if (err) {
    DBG_ERROR_ERR(0, err);
    return 2;
  }

  GWEN_Logger_Open(0,
                   "QBankManager", 0,
		   GWEN_LoggerType_Console,
                   GWEN_LoggerFacility_User);

  kb=new KBanking("QBankManager");

  rv=kb->init();
  if (rv) {
    DBG_ERROR(0, "Error on KBanking::init: %d", rv);
    QMessageBox::critical(0,
                          QWidget::tr("Initialization Error"),
                          QWidget::tr("<qt>"
                                      "Could not initialize KBanking."
                                      "</qt>"
                                     ),
                          QWidget::tr("Dismiss"));
    return 2;
  }

  TransactionView *lv;
  Account *account;
  std::list<RefPointer<Transaction> > xl;

  account=kb->findAccount("28250110", "0002728194");
  assert(account);
  xl=account->getTransactions();
  DBG_ERROR(0, "Got %d transactions", xl.size());
  lv=new TransactionView(kb, xl);
  a.setMainWidget(lv);
  lv->init();
  lv->show();

  a.connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));
  a.exec();

  return 0;
}



int main(int argc, char **argv) {
  QApplication a(argc, argv);
  MainWindow *mw;
  KBanking *kb;
  QBGui *gui;
  int rv;
  const char *s;
  int err;
  QTranslator *translator;
  QPixmap splashPixMap(aquamaniac_xpm);
  QSplashScreen *splash=new QSplashScreen(splashPixMap);

  err=GWEN_Init();
  if (err) {
    DBG_ERROR_ERR(0, err);
    return 2;
  }

  kb=new KBanking("QBankManager");
  gui=new QBGui(kb);
  GWEN_Gui_SetGui(gui->getCInterface());
  kb->setGui(gui);

  GWEN_Logger_Open(0,
                   "QBankManager", 0,
		   GWEN_LoggerType_Console,
                   GWEN_LoggerFacility_User);

  // set loglevels
  s=getenv("LOGLEVEL");
  if (s) {
    GWEN_LOGGER_LEVEL ll;

    ll=GWEN_Logger_Name2Level(s);
    if (ll!=GWEN_LoggerLevel_Unknown) {
      GWEN_Logger_SetLevel(0, ll);
      DBG_WARN(0,
               "Overriding loglevel for QBankManager with \"%s\"",
               s);
    }
    else {
      DBG_ERROR(0, "Unknown loglevel \"%s\"",
                s);
    }
  }
  else {
    GWEN_Logger_SetLevel(0, GWEN_LoggerLevel_Notice);
  }

  splash->show();
  translator=new QTranslator(0);
  QString pkgdatadir(PKGDATADIR);
  if (translator->load(QTextCodec::locale()+QString(".qm"),
                       QString(pkgdatadir + "/" "i18n" "/"))) {
    DBG_INFO(0, "I18N available for your language");
    qApp->installTranslator(translator);
  }
  else {
    DBG_WARN(0, "Internationalisation is not available for your language");
    delete translator;
    translator=0;
  }

  /* update configuration */
  rv=AB_Banking_HasConf4(kb->getCInterface(), 0);
  if (rv) {
    fprintf(stderr, "Config for AqBanking 4 not found, update needed (%d)\n", rv);
    rv=AB_Banking_HasConf3(kb->getCInterface(), 0);
    if (!rv) {
      /* import version 3 */
      rv=AB_Banking_ImportConf3(kb->getCInterface(), 0);
      if (rv<0) {
	fprintf(stderr, "Error importing configuration (%d)\n", rv);
	QMessageBox::critical(0,
			      QWidget::tr("Configuration Error"),
			      QWidget::tr("<qt>"
					  "A configuration for AqBanking3 was found "
					  "but could not be imported (%1)."
					  "</qt>"
					 ).arg(rv),
			      QWidget::tr("Dismiss"));
	return 2;
      }
      else {
	QMessageBox::information(0,
				 QWidget::tr("Configuration Updated"),
				 QWidget::tr("<qt>"
					     "A configuration for AqBanking3 was found "
					     "and successfully imported."
					     "</qt>"
					    ),
				 QWidget::tr("Ok"));
      }
    }
    else {
      /* check for AqBanking2 */
      rv=AB_Banking_HasConf2(kb->getCInterface(), 0);
      if (!rv) {
	fprintf(stderr, "Config for AqBanking 2 found, importing\n");
	rv=AB_Banking_ImportConf2(kb->getCInterface(), 0);
	if (rv<0) {
	  fprintf(stderr, "Error importing configuration (%d)\n", rv);
	  QMessageBox::critical(0,
				QWidget::tr("Configuration Error"),
				QWidget::tr("<qt>"
					    "A configuration for AqBanking2 was found "
					    "but could not be imported (%1)."
					    "</qt>"
					   ).arg(rv),
				QWidget::tr("Dismiss"));
	  return 2;
	}
	else {
	  QMessageBox::information(0,
				   QWidget::tr("Configuration Updated"),
				   QWidget::tr("<qt>"
					       "A configuration for AqBanking2 was found "
					       "and successfully imported."
					       "</qt>"
					      ),
				   QWidget::tr("Ok"));
	}
      }
      else {
	fprintf(stderr, "No configuration found, you will have to setup AqBanking.\n");
      }
    }
  }

  splash->message(QWidget::tr("Initializing KBanking..."));
  qApp->processEvents();
  rv=kb->init();
  if (rv) {
    DBG_ERROR(0, "Error on KBanking::init: %d", rv);
    // splash->finish(mw); -- mw not yet assigned
    delete splash;
    QMessageBox::critical(0,
                          QWidget::tr("Initialization Error"),
                          QWidget::tr("<qt>"
                                      "Could not initialize KBanking."
                                      "</qt>"
                                     ),
                          QWidget::tr("Dismiss"));
    return 2;
  }

  mw=new MainWindow(kb);
  splash->message(QWidget::tr("Initializing Main Window..."));
  qApp->processEvents();
  if (!mw->init()) {
    splash->finish(mw);
    delete splash;
    QMessageBox::critical(0,
                          QWidget::tr("Initialization Error"),
                          QWidget::tr("<qt>"
                                      "Could not initialize GUI."
                                      "</qt>"
                                     ),
                          QWidget::tr("Dismiss"));
    return 2;
  }
  kb->setMainWindow(mw);
  mw->setCaption(QWidget::tr("QBankManager - Online Banking (c) 2004-2006 Martin Preuss"));
  splash->message(QWidget::tr("Finishing Display..."));
  while(qApp->hasPendingEvents())
    qApp->processEvents();
  mw->show();
  splash->finish(mw);
  delete splash;
  a.connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));
  rv=a.exec();
  if (!mw->fini()) {
    QMessageBox::critical(0,
                          QWidget::tr("Deinitialization Error"),
                          QWidget::tr("<qt>"
                                      "Could not deinitialize GUI."
                                      "</qt>"
                                     ),
                          QWidget::tr("Dismiss"));
    return 3;
  }

  if (kb->fini()) {
    QMessageBox::critical(0,
                          QWidget::tr("Deinitialization Error"),
                          QWidget::tr("<qt>"
                                      "Could not deinitialize KBanking."
                                      "</qt>"
                                     ),
                          QWidget::tr("Dismiss"));
    return 3;
  }
}



