/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_EDITTRANS_H
#define AQBANKING_KDE_EDITTRANS_H

class KBanking;


#include "edittransaction.ui.h"
#include "transfer.h"
#include "refpointer.h"



class EditTransaction: public EditTransactionUi {
  Q_OBJECT
public:
  EditTransaction(KBanking *app,
                  RefPointer<Transfer> t,
                  bool isDated=false,
                  bool isCreate=false,
                  QWidget* parent=0,
                  const char* name=0,
                  bool modal=false,
                  WFlags fl=0);
  ~EditTransaction();

  static bool editTransfer(KBanking *app,
                           RefPointer<Transfer> t,
                           const QString &title,
                           QWidget* parent=0,
                           bool modal=false,
                           WFlags fl=0);

  static bool editDebitNote(KBanking *app,
                            RefPointer<Transfer> t,
                            const QString &title,
                            QWidget* parent=0,
                            bool modal=false,
                            WFlags fl=0);

  static bool createDatedTransfer(KBanking *app,
                                  RefPointer<Transfer> t,
                                  const QString &title,
                                  QWidget* parent=0,
                                  bool modal=false,
                                  WFlags fl=0);

  static bool modifyDatedTransfer(KBanking *app,
                                  RefPointer<Transfer> t,
                                  const QString &title,
                                  QWidget* parent=0,
                                  bool modal=false,
                                  WFlags fl=0);

public slots:
  void accept();
  void reject();
  void slotBankCode();
  void slotAccountChanged(int i);
  void slotGetBankCode();
  void slotGetPayee();
  void slotRemoteAccountChanged(const QString &qs=QString::null);

private:
  KBanking *_app;
  RefPointer<Transfer> _transfer;
  int _maxPurpose;
  bool _isDated;
  bool _isCreate;
  int _minDelay;
  int _maxDelay;

  void _setComboTextNoDup(QComboBox *qb, const QString &s);
  void _setComboTextIfPossible(QComboBox *qb,
                               const QString &s);
  static QString _tr(const char * sourceText);

};







#endif // AQBANKING_KDE_EDITTRANS_H


