#ifndef LISTMANAGER_H
#define LISTMANAGER_H

#include "dialog.h"
#include "playlistwrapper.h"
#include <string>

class playlistDialog;

QString formatTime(unsigned int time);

class playlistManager
{
public:
	static playlistManager & self();

	void searchTextUpdated(playlistDialog &dialog, const string &text);
	void doubleClickOnList(playlistDialog &dialog, unsigned int id);
	QString getStatusBarText() const;
	bool getRandomStatus() const;
	void stopPressed() const;
	void playPressed() const;
	void nextPressed() const;
	void prevPressed() const;
	void pausePressed() const;
	int getPlayingId() const;
	void randomToggle() const;
	void updatePlaylist() const;

private:
	static playlistManager * m_self;
	playlistManager();

	playlistWrapper & m_wrapper;
};

#endif
