/***************************************************************************
  setupdialog.h
  -------------------
  Application setup dialog
  -------------------
  Copyright 1999-2002, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  3. Neither the name of the author nor the names of the contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
****************************************************************************/

#ifndef SETUPDIALOG_H
#define SETUPDIALOG_H

#include <qdialog.h>

class QCheckBox;
class QComboBox;
class QFrame;
class QLabel;
class QGridLayout;
class QLineEdit;
class QPushButton;
class QSpinBox;
class QStringList;

class FixedSpinBox;

// TODO: use qt designer?

class SetupDialog : public QDialog
{
    Q_OBJECT
public:
    // constructor
    SetupDialog(QWidget* parent = 0, const char* name = 0);
    // destructor
    virtual ~SetupDialog();

    // set the application directory edit box
    void setAppDir(const QString &appdir);
    // return the qbrew directory edit text
    const QString appDir();
    // set the widget style combo box
    void setWidgetStyle(const QString &style);
    // return the widget style combo box text
    const QString widgetStyle();
    // set the batch spin box
    void setBatch(const double batch);
    // return the batch spin box double
    double batch();
    // set the efficiency spin box
    void setEfficiency(const double eff);
    // return the efficiency spin box double
    double efficiency();
    // set the recipe style combo box
    void setRecipeStyle(const QString &style);
    // return the recipe style combo box text
    const QString recipeStyle();
    // set the hop calculation method
    void setTinseth(const bool tinseth);
    // return if the tinseth hop method is used
    bool tinseth();
    // set the default units
    void setUnits(const QString &unit);
    // return the default units
    const QString units();
    // set to use large icons in toolbars
    void setLargeIcons(bool large);
    // return if using large icons in toolbars
    bool largeIcons();

    // set the widget style combo box to the stringlist
    void setWidgetStyleBox(const QStringList &styles);
    // set the recipe style combo box to the stringlist
    void setRecipeStyleBox(const QStringList &styles);
    // add a unit of measurement
    void addUnits(const QString &unit);

public slots:
    // convert the batch size when units have changed
    void convertBatchSpin(const QString &selection);

protected:
    QGridLayout* layout_;
    QLabel* qbrewlabel_;
    QLabel* widgetstylelabel_;
    QLabel* batchlabel_;
    QLabel* efficiencylabel_;
    QLabel* recipestylelabel_;
    QLabel* unitslabel_;
    QFrame* separatorone_;
    QFrame* separatortwo_;
    QLineEdit* qbrewedit_;
    QComboBox* widgetstylebox_;
    FixedSpinBox* batchspin_;
    FixedSpinBox* efficiencyspin_;
    QComboBox* recipestylebox_;
    QCheckBox* tinsethcheck_;
    QComboBox* unitsbox_;
    QCheckBox* iconcheck_;
    QPushButton* cancelbutton_;
    QPushButton* okbutton_;
};

#endif // SETUPDIALOG_H
