/***************************************************************************
  resource.h
  -------------------
  Global resources for QBrew. Constants, enumerations and strings.
  -------------------
  Copyright 1999-2004, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef RESOURCE_H
#define RESOURCE_H

#include <qstring.h>
#include <qmap.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#define PACKAGE "qbrew"
#define PREFIX "/usr/local"
#define VERSION "0.3.4"
#define PACKAGE_BUGREPORT "<bugs@usermode.org>"
#endif

// some stuff to differentiate between systems
#if defined(Q_WS_X11)
// X11
#define QPREFIX     PREFIX
#define QDIR_HOME   QDir::homeDirPath()
#elif defined(Q_WS_MACX)
// Carbon
#define QPREFIX     "qbrew.app/Contents/Resources"
#define QDIR_HOME   QDir::homeDirPath()
#else
// Win32 (and others)
#define QPREFIX     ""
#define QDIR_HOME   QDir::currentDirPath()
#endif
#define LARGEICONS  true

namespace AppResource {

///////////////////////////////////////////////////////////////////
// Units

const QString UNIT_METRIC           = "Metric";
const QString UNIT_US               = "US";

///////////////////////////////////////////////////////////////////
// Hop Forms

const QString HOP_PELLET            = "pellet";
const QString HOP_PLUG              = "plug";
const QString HOP_WHOLE             = "whole";

///////////////////////////////////////////////////////////////////
// general application values

const QString ID_TITLE              = "QBrew";
const QString ID_DESCRIPTION        = "A Homebrewer's Recipe Calculator";
const QString ID_COPYRIGHT          = "Copyright 1999-2004";
const QString ID_AUTHOR             = "David Johnson";
const QString ID_AUTHOR_EMAIL       = "david@usermode.org";
const QString ID_CONTRIBUTORS       = "Rob Hudson, "
                                      "Abe Kabakoff, "
                                      "Stephen Lowrie, "
                                      "Michal Palczewski, "
                                      "Kevin Pullin";

const QString ID_READY              = "Ready";

const QChar CHAR_LATIN_DEGREE       = QChar(0xB0);  // TODO: make portable
const QChar CHAR_NBSP               = QChar(0xA0);  // TODO: make portable

///////////////////////////////////////////////////////////////////
// file locations and stuff

const QString ID_FILE_EXT           = "qbrew";
const QString ID_FILE_FILTER
    = ID_TITLE + " files (*." + ID_FILE_EXT + ");;All files (*)";
const QString ID_PREFERENCES_FILE   = ".qbrewrc";
const QString ID_HELP_FILE          = "qbrew-handbook.html";
const QString ID_PRIMER_FILE        = "primer.html";
const QString ID_DEFAULT_FILE       = "untitled";

// define file format versions
const QString QBREW_PREVIOUS        = "0.1.7";

///////////////////////////////////////////////////////////////////
// configuration strings

const QString CONFGROUP_WINDOW       = "/window";
const QString CONF_WIN_TOOLBAR       = "/toolbar";
const QString CONF_WIN_STATUSBAR     = "/statusbar";
const QString CONF_WIN_MAINWINDOW    = "/mainwindow";

const QString CONFGROUP_GENERAL      = "/general";
const QString CONF_GEN_APPDIR        = "/appdir";
const QString CONF_GEN_LOOK_FEEL     = "/lookfeel";
const QString CONF_GEN_LARGE_ICONS   = "/largeicons";
const QString CONF_GEN_SHOW_SPLASH   = "/showsplash";
const QString CONF_GEN_AUTOSAVE      = "/autosave";
const QString CONF_GEN_SAVEINTERVAL  = "/saveinterval";
const QString CONF_GEN_AUTOBACKUP    = "/autobackup";
const QString CONF_GEN_LOADLAST      = "/loadlast";
const QString CONF_GEN_RECENTFILES   = "/recentfiles";
const QString CONF_GEN_RECENTNUM     = "/recentnum";

const QString CONFGROUP_RECIPE       = "/recipedefaults";
const QString CONF_RECIPE_BATCH      = "/batch";
const QString CONF_RECIPE_STYLE      = "/style";
const QString CONF_RECIPE_HOPFORM    = "/hopform";
const QString CONF_RECIPE_MASH       = "/mash";

const QString CONFGROUP_CALC         = "/calc";
const QString CONF_CALC_EFFICIENCY   = "/efficiency";
const QString CONF_CALC_MOREY        = "/morey";
const QString CONF_CALC_TINSETH      = "/tinseth";
const QString CONF_CALC_UNITS        = "/units";

///////////////////////////////////////////////////////////////////
// TODO: the following are for a temporary conversion
// They need to remain for at least one year after the 0.3.4 release
const QString ID_PREF_STATUSBAR         = "StatusBar";
const bool ID_PREF_STATUSBAR_DEFAULT    = true;
const QString ID_PREF_TOOLBAR           = "Toolbar";
const bool ID_PREF_TOOLBAR_DEFAULT      = true;
const QString ID_PREF_APPDIR            = "QBrewDir";
const QString ID_PREF_APPDIR_DEFAULT    = QPREFIX;
const QString ID_PREF_WIDGET_STYLE      = "WidgetStyle";
const QString ID_PREF_WIDGET_STYLE_DEFAULT  = "Qt"; // non-existant
const QString ID_PREF_BATCH             = "Batch";
const double ID_PREF_BATCH_DEFAULT      = 5.00;
const QString ID_PREF_EFFICIENCY        = "Efficiency";
const double ID_PREF_EFFICIENCY_DEFAULT = 0.75;
const QString ID_PREF_TINSETH           = "Tinseth";
const bool ID_PREF_TINSETH_DEFAULT      = false;
// TODO: get rid of default recipe style option
const QString ID_PREF_RECIPE_STYLE      = "RecipeStyle";
const QString ID_PREF_RECIPE_STYLE_DEFAULT  = "Generic Ale";
const QString ID_PREF_UNITS             = "Units";
const QString ID_PREF_UNITS_DEFAULT     = UNIT_US;
const QString ID_PREF_LARGE_ICONS       = "LargeIcons";
const bool ID_PREF_LARGE_ICONS_DEFAULT  = LARGEICONS;

}; // namespace AppResource

#endif // RESOURCE_H
