/***************************************************************************
  miscdb.h
  -------------------
  A dialog page for miscellaneous ingredients
  -------------------
  Copyright 2005, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
     this list of conditions and the following disclaimer in the documentation
     and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef MISCDB_H
#define MISCDB_H

#include "miscview.h"
#include "miscingredient.h"

class Model;

class MiscDB : public MiscView  {
   Q_OBJECT
public:
    // constructor
    MiscDB(QWidget *parent, const char *name, Model *model);
    // destructor
    virtual ~MiscDB();

    // initialize list and fields
    void refresh();

signals:
    // emits on modification
    void modified();

private slots:
    // add clicked
    void addMiscIngredient();
    // apply clicked
    void applyMiscIngredient();
    // remove clicked
    void removeMiscIngredient();
    // update the entry fields
    void updateFields(const QString &name);
    // an ingredient was selected
    void itemSelected(QListViewItem *item);

private:
    Model *model_;
    MiscItem* currentitem_;
};

#endif // MISCDB_H
