/***************************************************************************
  view.h
  -------------------
  View class for QBrew
  -------------------
  Copyright 1999-2005, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef VIEW_H
#define VIEW_H

#include "viewwidget.h"

class FixedSpinBox;
class GrainPage;
class HopPage;
class MiscPage;
class NotePage;

class Controller;
class Model;

class View : public ViewWidget {
    Q_OBJECT
 public:
    // constructor
    View(Controller *controller=0, Model *model=0);
    // destructor
    ~View();
  
    // set a combo box to the text
    static void setComboItem(QComboBox *combo, const QString &txt);

 public slots:
    // refresh the entire view
    void flush();
    // refresh just the characteristics
    void refresh();

    // set the recipe title
    void setTitle(const QString &title);
    // set the recipe style
    void setStyle(const QString &style);
    // set the brewer name
    void setBrewer(const QString &brewer);
    // set the recipe size
    void setSize(double size);
    // set mashed / unmashed
    void setMash(bool mash);

private:
    Controller *controller_;
    Model *model_;

    GrainPage* grainpage_;
    HopPage* hoppage_;
    MiscPage* miscpage_;
    NotePage* notepage_;
};

#endif // VIEW_H

