/***************************************************************************
                          rdlgarc.cpp  -  description
                             -------------------
    begin                : Mon Feb 7 2000
    copyright            : (C) 2000 by Gerald Pichler
    email                : geripi@sbox.tu-graz.ac.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "rdlgarc.h"
#include "relement.h"
#include "rmath.h"
#include <qvalidator.h>

RDlgArc::RDlgArc(QWidget *_parent, const char *_name, RElement *_arc)
				: QDialog(_parent,_name,true){
	initDialog();
	setCaption(tr("Arc"));
	
  val= new QDoubleValidator(-1.0e300, 1.0e300, 8, this);
	
  QLineEdit_cx->setValidator(val);
  QLineEdit_cy->setValidator(val);
  QLineEdit_cr->setValidator(val);
  QLineEdit_a1->setValidator(val);
  QLineEdit_a2->setValidator(val);

	QPushButton_Ok->setText(tr("Ok"));
  connect(QPushButton_Ok, SIGNAL(clicked()), SLOT(accept()));

	QPushButton_Cancel->setText(tr("Cancel"));
  connect(QPushButton_Cancel, SIGNAL(clicked()), SLOT(reject()));

  QString tempStr;

  tempStr.setNum(_arc->getCx());
  QLineEdit_cx->setText(tempStr);
  tempStr.setNum(_arc->getCy());
  QLineEdit_cy->setText(tempStr);
  tempStr.setNum(_arc->getCr());
  QLineEdit_cr->setText(tempStr);
  tempStr.setNum(_arc->getA1());
  QLineEdit_a1->setText(tempStr);
  tempStr.setNum(_arc->getA2());
  QLineEdit_a2->setText(tempStr);

  QLabel_Center->setText(tr("Center:"));
  QLabel_Radius->setText(tr("Radius:"));
  tempStr.setNum(_arc->getLength());
  QLabel_Length->setText(tr("Length:") + " " + tempStr);
  QLabel_Angles->setText(tr("Angle:"));
  QLabel_From->setText(tr("from"));
  QLabel_To->setText(tr("to"));
  QLabel_From->setAlignment(AlignRight | AlignVCenter);
  QLabel_To->setAlignment(AlignRight | AlignVCenter);

	QCheckBox_Reversed->setText(tr("clockwise"));
	QCheckBox_Reversed->setChecked(_arc->getFlag(E_REVERSED));
	
}

RDlgArc::~RDlgArc(){
}

// Gives the Values that are written in the Editfields
double
RDlgArc::getCx(bool *isOk){
	//QString tmpStr=QLineEdit_cx->text();
	//return tmpStr.toDouble(isOk);
	return mtCalculate( QLineEdit_cx->text(), 0.0, isOk );
}

double
RDlgArc::getCy(bool *isOk){
	//QString tmpStr=QLineEdit_cy->text();
	//return tmpStr.toDouble(isOk);
	return mtCalculate( QLineEdit_cy->text(), 0.0, isOk );
}

double
RDlgArc::getCr(bool *isOk){
	//QString tmpStr=QLineEdit_cr->text();
	//return tmpStr.toDouble(isOk);
	return mtCalculate( QLineEdit_cr->text(), 0.0, isOk );
}

double
RDlgArc::getA1(bool *isOk){
	//QString tmpStr=QLineEdit_a1->text();
	//return tmpStr.toDouble(isOk);
	return mtCalculate( QLineEdit_a1->text(), 0.0, isOk );
}

double
RDlgArc::getA2(bool *isOk){
	//QString tmpStr=QLineEdit_a2->text();
	//return tmpStr.toDouble(isOk);
	return mtCalculate( QLineEdit_a2->text(), 0.0, isOk );
}

bool
RDlgArc::getReversed(){
	return QCheckBox_Reversed->isChecked();
}
