#!/bin/bash
# $Id: build_qcad.sh,v 1.42 2004/09/11 21:15:22 andrew Exp $

echo "build_qcad.sh"
echo "Usage: ./build_qcad.sh [demo] [nocam] [noscripting] [noclean] [noconfig]"
echo "  demo        build demo version"
echo "  debugging   add debug menu"
echo "  nocam       don't build CAM module even if available"
echo "  noscripting don't build scripting support even if available"
echo "  noclean     don't clean (speeds up building if the options don't change)"
echo "  noconfig    don't run configure (speeds up building if the options don't change)"
echo "  noprepare   don't run prepare (speeds up building if the options don't change)"
echo "  distcc      use distcc for distributed compilation. DISTCC_HOSTS must be set."
echo

echo "QTDIR is: $QTDIR"
echo "QMAKESPEC is: $QMAKESPEC"

# adjust these settings to your individual system:
#
# freebsd: use gmake
# solaris: use make
# redhat: Qt is probably located in /usr/lib/qt-3.1 or similar
# suse: Qt is usually located in /usr/lib/qt3
#
export MAKE=make
#export MAKE=gmake
#export QTDIR=/usr/local/X11/qt
#export QTDIR=/usr/share/qt3
#export PATH=$PATH:$QTDIR/bin




# no need to change anything below this line...

if [ -z $QTDIR ]
then
    echo "QTDIR not set. Aborting.."
    exit
fi

targetsfx=
targetsfxapple=
rs_cam="yes"
modules="qcadlib qcadcmd qcadactions qcadguiqt qcadscripting"

for arg in $@
do
    if [ "$arg" == "demo" ] ; then
        QMAKE_OPT="$QMAKE_OPT CONFIG+=demo"
        targetsfx=_demo
        targetsfxapple=Demo
    fi
    if [ "$arg" == "debug" ] ; then
        QMAKE_OPT="$QMAKE_OPT DEFINES+=QC_DEBUGGING"
    fi
    if [ "$arg" == "nocam" ] ; then
        QMAKE_OPT="$QMAKE_OPT CONFIG+=rs_no_cam"
		rs_cam="no"
    fi
    if [ "$arg" == "noscripting" ] ; then
        QMAKE_OPT="$QMAKE_OPT CONFIG+=rs_no_scripting"
    fi
    if [ "$arg" == "noclean" ] ; then
		NOCLEAN="true"
    fi
    if [ "$arg" == "noconfig" ] ; then
		NOCONFIG="true"
    fi
    if [ "$arg" == "noprepare" ] ; then
		NOPREPARE="true"
    fi
    if [ "$arg" == "distcc" ] ; then
		# look for hosts for distributed compilation:
		if [ ! -z "$DISTCC_HOSTS" ]
		then
			export MAKE="$MAKE -j8 CXX=distcc"
		fi
    fi
done

if [ "$rs_cam" == "yes" ]
then
	modules="$modules qcadcam"
fi

# clear demo-specific objects
if [ "x$NOCLEAN" = "x" ]
then
    rm -f ../qcad/src/obj/main.o*
    rm -f ../qcad/src/obj/qc_applicationwindow.o*
fi


echo "options: $QMAKE_OPT"

cd ..

echo "-------- Building fparser --------"
cd fparser
if [ -z $NOCONFIG ]
then
	./configure
fi
eval $MAKE
cd ..

if [ ! -f fparser/lib/libfparser.a ]
then
    echo "Building libfparser.a failed"
    exit;
fi

echo "-------- Building dxflib --------"
cd dxflib
if [ -z $NOCONFIG ]
then
	./configure
fi
eval $MAKE
cd ..

if [ ! -f dxflib/lib/libdxf.a ]
then
    echo "Building libdxf.a failed"
    exit;
fi


if [ -z $NOPREPARE ]
then
	for p in $modules
	do
	    if [ -d $p ]
	    then
	        echo "-------- Preparing $p --------"
	        cd $p
	        eval $MAKE prepare
	        cd ..
	    fi
	done
fi

for p in $modules
do
    if [ -d $p ]
    then
        echo "-------- Building $p --------"
        cd $p
        cd src
        qmake $p.pro $QMAKE_OPT
        cd ..
        eval $MAKE
        cd ..

        if [ ! -f $p/lib/*.a ]
        then
            echo "Building $p failed"
            exit;
        fi
    fi
done

echo "-------- Building QCad --------"
cd qcad
cd src
qmake qcad.pro $QMAKE_OPT
cd ..

# clean in qcad/:
for f in qcad qcad_demo camexpert camexpert_demo \
         QCad.app CAMExpert.app QCadDemo.app CAMExpertDemo.app
do
    if [ -e $f ]
    then
         rm -rf $f
    fi
done

eval $MAKE
cd ..

if [ ! -f qcad/qcad$targetsfx -a \
     ! -f qcad/QCad$targetsfxapple.app/Contents/MacOS/QCad$targetsfxapple -a \
     ! -f qcad/camexpert$targetsfx -a \
     ! -f qcad/CAMExpert$targetsfxapple.app/Contents/MacOS/CAMExpert$targetsfxapple ]
then
    echo "Building qcad binary failed"
    exit;
fi

# create mac .app folder:
cd ./qcad
if [ -d /Users ]
then
    if [ -d QCad$targetsfxapple.app ]
    then
		echo Preparing Application Folder for QCad
        app=QCad$targetsfxapple
    else
		echo Preparing Application Folder for CAM Expert
        app=CAMExpert$targetsfxapple
    fi

    if [ -d CAMExpert$targetsfxapple.app ]
    then
		echo Copying machine configuration file
        mkdir $app.app/Contents/Resources/machines
        cp machines/*.cxm $app.app/Contents/Resources/machines/
    fi

	strip $app.app/Contents/MacOS/$app
	
    #mkdir $app.app/Contents/Resources/doc
    #cp doc/*.html doc/*.css doc/*.adp $app.app/Contents/Resources/doc/
    #mkdir $app.app/Contents/Resources/doc/img
    #cp doc/img/*.png $app.app/Contents/Resources/doc/img/
    #mkdir $app.app/Contents/Resources/doc/imgs
    #cp doc/img/*.png $app.app/Contents/Resources/doc/imgs/
    mkdir $app.app/Contents/Resources/qm
    cp qm/*.qm $app.app/Contents/Resources/qm/
    mkdir $app.app/Contents/Resources/fonts
    cp fonts/*.cxf $app.app/Contents/Resources/fonts/
    mkdir $app.app/Contents/Resources/patterns
    cp patterns/*.dxf $app.app/Contents/Resources/patterns/
    #cp src/Info.plist $app.app/Contents/

	if [ -d "$QTDIR/bin/assistant.app" ]
	then
         mkdir -p "$app.app/Contents/MacOS/bin"
         cp -R "$QTDIR/bin/assistant.app" "$app.app/Contents/MacOS/bin/"
    fi
fi

#cd scripts
#bash ./release_translations.sh

