/***************************************************************************
                          body.h  -  description
                             -------------------
    begin                : Mit Sep 25 13:11:41 CEST 2002
    copyright            : (C) 2002 by Harald Krippel
    email                : neuro.harald@surfeu.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef BODY_H
#define BODY_H

/**
  *@author Krippel Harald
  */

#include <plib/ssg.h>
#include <ode/ode.h>

class Body
{
   public:
     Body(void);

     void   createOdeBody(dWorldID odworld, dSpaceID odspace, int typ);
     void   typ(dSpaceID odspace,int typ);
     void   adjustMass(float tmpmass);
     void   Scale(float x, float y, float z);
     void   update();
     void   setTransform (ssgTransform *objtrans, const dReal pos[3], const dReal R[12],dVector3 dxyz);
     void   setPosition ();
     void   getPosition ( sgCoord  *bodypos );
     void   setRotation ();
     void   Rotation (float h, float p, float r);
     void   setLinearVel ();
     void   addRelForce ();
     void   setAngularVel ();
     void   addRelTorque ();
     void   setObjtrans (ssgTransform *trans);
     ~Body(void);


    /* ode test */
    dMass odm;
    dBodyID odbody;
    dGeomID odgeom;
    dGeomID odgeom_group;

    float lvel[3];
    float avel[3];
    
    int oldtyp;
   
   ssgTransform *objtrans;
   ssgTransform *boxobjtrans;
   sgCoord      pos;
     
protected:
};

#endif
