//
// C++ Implementation: CCatalogEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CCatalogEdit.hpp"
#include "main.h"

CCatalogEditDlg::CCatalogEditDlg(QString strTitle, QWidget * parent, QString tmppath,QDir::Filter filters, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   catpath  = tmppath;
   catfilter= filters;
   ui.setupUi(this);
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));
   connect(ui.comboBox1, SIGNAL(activated(QString)), this, SLOT(slotGetCombo()));
   connect(ui.toolButton1, SIGNAL(pressed()), this, SLOT(slotGetCatPath()));

   myParent = parent;
   setWindowTitle(strTitle);

   tmpdir.setPath(tmppath);
   ui.catpath->setText(tmppath);
   ui.icon->setViewMode(QListView::IconMode);
//     ui.icon->setIconSize(QSize(40, 40));
   ui.icon->setGridSize(QSize(100, 20));
//     ui.icon->setSpacing(10);
   model = new QStandardItemModel(this);
   ui.icon->setModel(model);
   connect(ui.icon, SIGNAL(clicked(QModelIndex)),
             this, SLOT(click(QModelIndex)));
   connect(ui.icon, SIGNAL(doubleClicked(QModelIndex)),
             this, SLOT(doubleclick(QModelIndex)));
   fillcombo();
   fillicon(catfilter);
   ui.catpath->setText( tmppath ) ;
   state=0;
}

CCatalogEditDlg::~CCatalogEditDlg() {
}

void CCatalogEditDlg::slotGetData()
{
    qWarning( "CCatalogEditDlg::slotGetData(): Geht !" );
    reject();
}

void CCatalogEditDlg::slotEditData()
{
     qWarning( "CCatalogEditDlg::slotEditData(): Geht !" );
     accept();
}

void CCatalogEditDlg::slotGetCombo()
{
    fillicon(catfilter);
    qWarning( "MyCatalogEditDlg::slotGetCombo(): Geht !" );
}

void CCatalogEditDlg::fillicon(QDir::Filter filters)
{
    QDir icondir;
    QStringList catlist;
    icondir.setPath( tmpdir.path() + "/" + ui.comboBox1->currentText());
    path =  icondir.path() + "/";
//     icondir.setFilter(QDir::Dirs);
//     icondir.setFilter(QDir::Files);
    icondir.setFilter(filters);
    catlist = icondir.entryList();

    model->clear();
    int x=0;
    int y=0;
    for ( uint i = 0; i < icondir.count(); i++ ){
        if (icondir[i] != "." && icondir[i] != ".."){
            QStandardItem *item = new QStandardItem(icondir[i]);
            item->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
            model->setItem(x++, y, item);
       }
    }
// todo     ui.icon->setCurrentItem(ui.icon->firstItem());
}

void CCatalogEditDlg::fillcombo()
{
    QStringList catlist;
    qWarning(tmpdir.absolutePath().toAscii());
    catlist = tmpdir.entryList(QDir::Dirs,QDir::Name);
    ui.comboBox1->clear();
    for (int i = 0; i < catlist.size(); ++i){
        if (catlist.at(i) != "." && catlist.at(i) != ".."){
            ui.comboBox1->addItem( catlist.at(i) );
        }
    }
}
void CCatalogEditDlg::click(QModelIndex index)
{
    QStandardItem *item = model->itemFromIndex(index);
    file = item->text();
}

void CCatalogEditDlg::doubleclick(QModelIndex index)
{
    QStandardItem *item = model->itemFromIndex(index);
    file = item->text();
    qWarning( "CCatalogEditDlg::doubleclick(): Geht !" );
    accept();
}

QString CCatalogEditDlg::getfile()
{
     return file;
}

QString CCatalogEditDlg::getpath()
{
     return path;
}

QString CCatalogEditDlg::getcatpath()
{
     return catpath;
}

void CCatalogEditDlg::slotGetCatPath()
{
    QString url=QFileDialog::getExistingDirectory(this, tr("Catalog Directory"),
                                                 tmppath,
                                                 QFileDialog::ShowDirsOnly
                                                 | QFileDialog::DontResolveSymlinks);
    if(!url.isEmpty()){
        catpath =  url;
        tmpdir.setPath(catpath);
        ui.catpath->setText( catpath) ;
        fillcombo();
        fillicon(catfilter);
    }
    qWarning( "MyCatalogEditDlg::slotGetCatPath(): Geht !" );
}
