/***************************************************************************
                          gamedesigner.cpp  -  description
                             -------------------
    begin                : Mit Sep 25 13:11:41 CEST 2002
    copyright            : (C) 2002 by Harald Krippel
    email                : harald@hte-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   this program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**
 * @class Glcontrol
 * @brief The Glcontrol class is the 3D graphics device class
 *
 * This class use an opengl QT-OpenGL context and plib to reender a 3D scenerie 
 * at the moment this class make to many thinks and is a monster
 */

#ifndef GL_GLEXT_PROTOTYPES
#define GL_GLEXT_PROTOTYPES
#endif

#include <QtGui>
#include <QtOpenGL>

#include "glcontrol.hpp"

// plib
#include <plib/ssg.h>
#include <plib/ssgAux.h>
#include <plib/ssgaSky.h>
#include <plib/js.h>
#include <plib/pu.h>
#include <puQT.h>

// open-al and phonon
 #include "audioenv.hpp"
 #include "alsound.hpp"
 #include "qcphonon.hpp"

// ODE
#include <ode/ode.h>

// shader
#include "shader.hpp"

#include "scripting.hpp"

#include "main.h"
#include "phthread.hpp"
#include "spl_prg.hpp"
#include "qtscript_prg.hpp"
#include "python_prg.hpp"
#include "loadMD2.hpp"
#include "tribarrier.hpp"
#include "usercamera.hpp"
#include "guitext.hpp"
#include "guibutton.hpp"
#include "guiosbutton.hpp"
#include "guiinput.hpp"
#include "joystickenv.hpp"
#include "CCatalogEdit.hpp"
#include "messages.hpp"
#include "qcfire.hpp"
#include "qcpartsys.hpp"
#include "qcwavesystem.hpp"
#include "qcskysystem.hpp"
#include "qcfog.hpp"

#ifndef GL_VERSION_1_3
// ARB_multitexture
#define GL_TEXTURE0      GL_TEXTURE0_ARB
#define GL_TEXTURE1      GL_TEXTURE1_ARB
#define glActiveTexture  glActiveTextureARB
#endif

#ifdef Q_OS_IRIX 
#define glActiveTexture glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
#endif

// Mutex
QMutex ph_mutex(QMutex::Recursive);

//*********PUI********************************
  
#define VIEW_GUI_BASE 20
#define FONT_COLOUR   1,1,1,1

 static puText      *timeText           = (puText      *) NULL ;
 static puText      *phText             = (puText      *) NULL ;

//*****************************************

// #define  CONTINUOUS_DISPLAY_SURFACE 1

    /* ode */
static    dWorldID odworld;
static    dSpaceID odspace;
static    dJointGroupID odcontactgroup;
static    dGeomID odground;

// this is called by dSpaceCollide when two objects in space are
// potentially colliding.

static void nearCallback (void *data, dGeomID o1, dGeomID o2)
{
  Q_UNUSED(data);
  int i;
  int n;

// todo
//  int a; // g1, g2;

/*  
  // only collide things with the ground
    for(a=0;a<MAX_LIST_ITEMS;a++){
      if(g_ListItem[a] != NULL){
        if(g_ListItem[a]->text(1) == "BODY"){
          if(g_ListItem[a]->body !=NULL){
            if(g_ListItem[a]->body->odgeom[0] !=NULL){
              if(o1 == g_ListItem[a]->body->odgeom[0] || o2 == g_ListItem[a]->body->odgeom[0] ){
                if( o1 == odground || o2 == odground ){
                  g_ListItem[a]->groundcollision=1;
                }else{
                  g_ListItem[a]->collision=1;
                }
              }
            }
          }
        }
      }
    }
*/
  const int N = 10;
  dContact contact[N];
  n = dCollide (o1,o2,N,&contact[0].geom,sizeof(dContact));
  if (n > 0){
    for (i=0; i<n; i++){
      contact[i].surface.mode = dContactSlip1 | dContactSlip2 |
      dContactSoftERP | dContactSoftCFM | dContactApprox1;
      contact[i].surface.mu = dInfinity;
      contact[i].surface.slip1 = 0.1;     // 0.1
      contact[i].surface.slip2 = 0.1;     // 0.1
      contact[i].surface.soft_erp = 0.7;  // 0.5
      contact[i].surface.soft_cfm = 0.1;  // 0.3
      dJointID c = dJointCreateContact (odworld,odcontactgroup,&contact[i]);
      dJointAttach (c,
      dGeomGetBody(contact[i].geom.g1),
      dGeomGetBody(contact[i].geom.g2));
    }
  }
}

/**
 * enables the multitexture feature if available
 */
int Glcontrol::enableTexGen ( ssgEntity * )
{
#ifdef GL_ARB_multitexture
  GLint tx ;
  glGetIntegerv ( GL_TEXTURE_BINDING_2D, &tx ) ;
  glActiveTexture ( GL_TEXTURE1 ) ;
#endif
  glTexGeni ( GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP ) ;
  glTexGeni ( GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP ) ;
  glEnable ( GL_TEXTURE_GEN_S ) ;
  glEnable ( GL_TEXTURE_GEN_T ) ;
#ifdef GL_ARB_multitexture
  glEnable ( GL_TEXTURE_2D ) ;  /* Enables the second texture map. */
  glBindTexture ( GL_TEXTURE_2D, tx ) ;
  glActiveTexture ( GL_TEXTURE0 ) ;
#endif
  return true ;
}

/**
 * disable the multitexture feature if available
 */
int Glcontrol::disableTexGen ( ssgEntity * )
{
#ifdef GL_ARB_multitexture
  glActiveTexture ( GL_TEXTURE1 ) ;
#endif
  glDisable ( GL_TEXTURE_GEN_S ) ;
  glDisable ( GL_TEXTURE_GEN_T ) ;
#ifdef GL_ARB_multitexture
  glDisable ( GL_TEXTURE_2D ) ; /* Disables the second texture map */
  glActiveTexture ( GL_TEXTURE0 ) ;
#endif
  return true ;
}

// 3D-Object Callbacks  uuugggssssss @@@ H.K.
// Shader @@@ testcode !!!!!!!!!!!!!!!!
int Glcontrol::objprecall  ( ssgEntity * )
{
  // turn Shader ON

  return true ;
}
int Glcontrol::objpostcall ( ssgEntity * )
{
  // turn Shader ON

  return true ;
}

Glcontrol::Glcontrol(QWidget *parent)
  : QGLWidget(parent)
{
  phthread=NULL;
  scene=NULL;
  lensflare_obj = NULL;
  initVariables();

  phfps=0.0f;
  mouse_mode=0;
  gllook=0;
  keylook=1;
  xRot=0;
  yRot=0;
  zRot=0;

  xTrans=0, yTrans=0, zTrans=0;
  scale=10;

  cxTrans=0;
  cyTrans=0;
  czTrans=0;
  cxRot=0;
  cyRot=0;
  czRot=0;
  
//    setCursor( pointingHandCursor  );

    // graphic timer
    gtimer = new QTimer( this );
    connect( gtimer, SIGNAL(timeout()), this, SLOT(gtimerDone()) );
    gtimer->start(TIMER_INTERVAL);

    // Physik & SPL thread

    phthread = new phThread();
    phthread->gl = this;
    phthread->go = 1;
    phthread->start();

}

void    Glcontrol::gtimerDone()
{
    updateGL();

    if(g_playmode){
      my_context->makeCurrent();
      // get3DMouse Update
      QPoint mpoint = mapFromGlobal(QCursor::pos());
// Debian etch problem with Intel Graphics driver!!!!!!
//      my_context->setPOI(mpoint.x(), mpoint.y());
      my_context->getPOI(&g_poi);
      g_mouse_x = mpoint.x();
      g_mouse_y = mpoint.y();

    }
    // spl switch scene
    if( g_switch==1 && g_switchScene != NULL){
         g_switch = 0;
         switchScene(g_switchScene);
         g_switchScene = NULL;
    }
}

void Glcontrol::initVariables()
{
  int a;

  usercam = NULL;
  globj=NULL;
  focusitem=NULL;
  sceneitem = NULL;

  // player
  for(a=0;a<MAX_PLAYER;a++){
    gl_player[a]=NULL;
  }
  gl_player_num=0;

}

void Glcontrol::phDelete()
{
    dWorldDestroy (odworld);
   // ODE create world
   odworld = dWorldCreate();
   odspace = dHashSpaceCreate(0);
   odcontactgroup = dJointGroupCreate(0);
   dWorldSetGravity(odworld,0,0,-1.0);       // 0,0,-9.81 !!!
   odground = NULL;
}

void Glcontrol::DeleteScene()
{
  if ( scene ){
    phDelete ();
    ssgDelete ( scene ) ;
    scene = NULL;
    sceneitem->scene_cleanup(sceneitem);
    initVariables();
  }
}

void Glcontrol::redrawScene()
{
  if(sceneitem != NULL){
    switchScene( sceneitem );
  }
}

void Glcontrol::puRedraw()
{
  if(sceneitem != NULL){
      sceneitem->scene_RedrawGUI(sceneitem);
  }
}

Glcontrol::~Glcontrol()
{
    makeCurrent();
    if(phthread){
      phthread->go = 0;
      phthread->wait();
      delete phthread;
      phthread=0;
    }
// cleanup
  StopSound();
  g_playmode = 0;
  gtimer->stop();
  while(gtimer->isActive()) ;
         
  // otherwise switch with wavesys will crash but why ??
  ulMilliSecondSleep ( 100 ) ;    
  if(lensflare_obj != NULL){
//      delete lensflare_obj;
      lensflare_obj = NULL;
  }
  DeleteScene();
//--------------------------------

    dCloseODE();    // dellocate some extra memory used by ODE -> at the end of application
}

void Glcontrol::load_database ()
{
  xScale=1.0f;
  yScale=1.0f;
  zScale=1.0f;
  /*
    Set up the path to the data files
  */
  ssgModelPath   ( "data" ) ;
  ssgTexturePath ( "data" ) ;

  /*
    Create a root node - and a transform to position
    the pedestal - and another to position the penguin
    beneath that (in the tree that is).
  */

  scene = new ssgRoot();
  // ODE create world
  dInitODE();  //ODE 0.8
  odworld = dWorldCreate();
  odspace = dHashSpaceCreate(0);
  odcontactgroup = dJointGroupCreate(0);
  dWorldSetGravity(odworld,0,0,-1.0);       // 0,0,-9.81 !!!
  // Test ODE
  odground = dCreatePlane(odspace,0,0,1,0);
}


void Glcontrol::init_gui ()
{

/*    
  static puFont     *sorority ;
  static fntTexFont *fnt      ;

  fnt      = new fntTexFont () ;
//  fnt     -> load ( "Courier.txf" ) ;
  fnt     -> load ( "Times-Roman.txf" ) ;
//  fnt     -> load ( "Helvetica.txf" ) ;
  sorority = new puFont ( fnt, 14 ) ;

  puSetDefaultFonts        ( *sorority, *sorority ) ;
  puSetDefaultStyle        ( PUSTYLE_SHADED ) ;
  puSetDefaultColourScheme ( 0.2f, 0.5f, 0.2f, 0.5f ) ;

*/
  timeText = new puText ( 40, 40 ) ;
  timeText->setColour( PUCOL_LABEL, FONT_COLOUR ) ;
  phText = new puText ( 40, 20 ) ;
  phText->setColour( PUCOL_LABEL, FONT_COLOUR ) ;

}

void Glcontrol::init_graphics ()
{
  /*
    Initialise SSG
  */
  puInitQT ();
  ssgInit () ;
  jsInit () ;
  /*
    Some basic OpenGL setup
  */
  glClearColor ( 0.2f, 0.7f, 1.0f, 1.0f ) ;
  glColor4f(1.0f,1.0f,1.0f,0.5f);
  glEnable ( GL_DEPTH_TEST ) ;
//  glEnable(GL_TEXTURE_2D);
//  glEnable(GL_BLEND);
//  glEnable(GL_ALPHA_TEST);
//  glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
//  glDisable(GL_DEPTH_TEST);        // Turn Depth Testing Off

  my_context = new Camera; 
  my_context->makeCurrent();
}

void Glcontrol::updatePH ()
{
  static ulClock ck ;
  static float waitoffs = 20;
//  int a;
  float wait;
  static int state=0;

  state++;
  ck.update () ;
  float dt = ck.getDeltaTime () ;
  wait = (waitoffs - dt);
  if(wait > 0){
    ulMilliSecondSleep ( (long)wait ) ;
  }

  if(state > 1/dt){
    phfps = 1/dt;
    if( phfps > 52){
        waitoffs += 0.5 ;
    }
    if( phfps < 48){
        waitoffs -= 0.5 ;
    }
    state=0;
  }

  if(g_playmode){
    // update scripting languages
    emit msg_ph_update("");
    // update physik
    ph_mutex.lock();
    dSpaceCollide (odspace,0,&nearCallback);
    // dWorldStep (odworld,dt);
    dWorldStepFast1 (odworld,dt,5); 
    // remove all contact joints
    dJointGroupEmpty(odcontactgroup);
    ph_mutex.unlock();
  }
  // update Joystick
  JoystickEnv *Joystick=JoystickEnv::theInstance();
  Joystick->update();
}

void Glcontrol::update_motion ()
{
  AudioEnv *Audio=AudioEnv::theInstance();
  sgCoord campos ;
  sgCoord gobjpos ;

  int a=0;
  static int state=0;
  static int frameno = 0 ;
  static ulClock ck ;
  static char buff1[256];
  static char buff2[256];
  float fps=0.0f;

  frameno++ ;
  state++;

  ck . update () ;
  float dt = ck . getDeltaTime () ;

  if(state > 1/dt){
    fps = (1/dt);
    if(g_displayfps){
        sprintf(buff1," FPS:%.0f",fps);
    }else{
        sprintf(buff1," ");
    }
    timeText->setLabel ( buff1 ) ;
    if(g_displayphfps){
        sprintf(buff2,"PHPS:%.0f",phfps);
    }else{
        sprintf(buff2," ");
    }
    phText->setLabel ( buff2 ) ;
    state=0;
  }
  emit msg_motion_update(dt);

  sgMat4  cammat;
  my_context->getModelviewMatrix ( cammat );
  if(Audio != 0){
  	Audio->ListenerPosition(cammat);
  }

  if(g_playmode){
    ph_mutex.lock();
    QcakeScriptApi *Script=QcakeScriptApi::theInstance();
    Script->Redraw ();
    ph_mutex.unlock();
    ph_mutex.lock();
    emit msg_motionplay_update(dt);
    ph_mutex.unlock();
    for(a=0;a<MAX_PLAYER;a++){
      if(gl_player[a] != NULL){
        gl_player[a] -> maus (mgox,mgoy) ;
        ph_mutex.lock();
        gl_player[a] -> update (dt) ;
        ph_mutex.unlock();
        my_context -> setCamera( gl_player[a] -> cmat);
      }
    }

    if(usercam != NULL){
      ph_mutex.lock();
      usercam->update();
      ph_mutex.unlock();
    }
  }else{
    // Set the Camera Key Num Block
    if(keylook){
      switch(gllook){
          case 0:     // Key NumBlock 2
            sgSetCoord ( & campos, 0.0f, -5.0f*scale, 3.0f, 0.0f, 0.0f, 0.0f ) ;
            break;
          case 1:     // Key NumBlock 4
            sgSetCoord ( & campos, -5.0f*scale, 0.0f , 3.0f, -90.0f, 0.0f, 0.0f ) ;
            break;
          case 2:     // Key NumBlock 8
            sgSetCoord ( & campos, 0.0f, 5.0f*scale, 3.0f, 180.0f, 0.0f, 0.0f ) ;
            break;
          case 3:     // Key NumBlock 6
            sgSetCoord ( & campos, 5.0f*scale, 0.0f , 3.0f, 90.0f, 0.0f, 0.0f ) ;
            break;
          case 4:     // Key NumBlock 5
            sgSetCoord ( & campos, 0.0f , 0.0f, 5.0f*scale, 0.0f, -90.0f, 0.0f ) ;
            break;
      }
      my_context -> setCamera ( & campos );
      keylook=0;
    }
    /* update Object */
    if(globj != NULL){
      // Translate, Rotate , Scale
      sgSetCoord ( & gobjpos, xTrans,  yTrans, zTrans, zRot, xRot, yRot ) ;  // x,y,z,h,p,r
      globj -> setTransform ( & gobjpos,xScale,yScale,zScale) ;
    }
  }
}

/*!
  Paint the scene. The actual openGL commands for drawing the scene are
  performed here.
*/

void Glcontrol::paintGL()
{
  my_context->makeCurrent();

  glClear  ( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT ) ;
  glDisable ( GL_FOG ) ;
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glEnable ( GL_BLEND ) ;

  update_motion () ;

  emit msg_predraw();
  ssgCullAndDraw ( scene ) ;
  emit msg_postdraw();

  puDisplay () ;
}

/*!
  Set up the OpenGL rendering state, and define display list
*/

void Glcontrol::initializeGL()
{
  makeCurrent();   // test
  init_graphics () ;
  load_database () ;
  init_gui();
}

/*!
  Set up the OpenGL view port, matrix mode, etc.
*/

void Glcontrol::resizeGL( int w, int h )
{
  my_context->setAspect((SGfloat)w/(SGfloat)h);
  glViewport ( 0, 0, w, h ) ;
  g_window_w=w;
  g_window_h=h;
  puRedraw();
}

void Glcontrol::transform()
{

}

/*!
  Set the rotation angle of the object to \e degrees around the X axis.
*/
void Glcontrol::setXRotation( double degrees )
{
    xRot = (GLfloat)fmod(degrees, 360.0);
}

/*!
  Set the rotation angle of the object to \e degrees around the Y axis.
*/
void Glcontrol::setYRotation( double degrees )
{
    yRot = (GLfloat)fmod(degrees, 360.0);
}


/*!
  Set the rotation angle of the object to \e degrees around the Z axis.
*/
void Glcontrol::setZRotation( double degrees )
{
    zRot = (GLfloat)fmod(degrees, 360.0);
}

void Glcontrol::setScale( double s )
{
    scale = s;
}

void Glcontrol::setXTrans( double x )
{
    xTrans = x;
}

void Glcontrol::setYTrans( double y )
{
    yTrans = y;
}

void Glcontrol::setZTrans( double z )
{
    zTrans = z;
}

void Glcontrol::setXScale( double x )
{
    xScale = x;
}

void Glcontrol::setYScale( double y )
{
    yScale = y;
}

void Glcontrol::setZScale( double z )
{
    zScale = z;
}

void Glcontrol::setRotationImpulse( double x, double y, double z )
{
    setXRotation( xRot + 180*x );
    setYRotation( yRot + 180*y );
    setZRotation( zRot - 180*z );
}

void Glcontrol::setTranslationImpulse( double x, double y, double z )
{
    setXTrans( xTrans + 2*x );
    setYTrans( yTrans + 2*y );
    setZTrans( zTrans + 2*z );
}

void Glcontrol::setScaleImpulse( double x, double y, double z )
{
    setXScale( xScale + 2*x );
    setYScale( yScale + 2*y );
    setZScale( zScale + 2*z );
}

void Glcontrol::mousePressEvent( QMouseEvent *e )
{
    setFocus ();
    e->accept();
    oldPos = e->pos();
    makeCurrent();
    my_context->setPOI(e->pos().x(), e->pos().y());
    if(g_playmode){
      /* PUI */
      if (e->buttons() & Qt::LeftButton){
        puMouse ( PU_LEFT_BUTTON, PU_DOWN, e->x(), e->y() ) ;
      }
      // SPL Mouse Buttons
      if (e->buttons() & Qt::LeftButton){
        g_mouse_button |= 0x01;
      }
      if (e->buttons() & Qt::MidButton){
        g_mouse_button |= 0x02;
      }
      if (e->buttons() & Qt::RightButton){
         g_mouse_button |= 0x04;
      }
   }
}

void Glcontrol::mouseReleaseEvent( QMouseEvent *e )
{
    char mybuff[256];

      mgox = 0;
      mgoy = 0;

   if(g_playmode){
    /* PUI */
     if (e->button() == Qt::LeftButton){
        puMouse ( PU_LEFT_BUTTON, PU_UP, e->x(), e->y() ) ;
     }
    // SPL Mouse Buttons
    if (e->button() == Qt::LeftButton){
       g_mouse_button &= ~0x01;
    }
    if (e->button() == Qt::MidButton){
       g_mouse_button &= ~0x02;
    }
    if (e->button() == Qt::RightButton){
       g_mouse_button &= ~0x04;
    }
   }
    e->accept();
    oldPos = e->pos();
    // update tree
    if(focusitem && globj && ( !g_playmode ) ){
      sprintf(mybuff,"%f",xTrans);
      focusitem->SetValue( "x" , mybuff);
      sprintf(mybuff,"%f",yTrans);
      focusitem->SetValue( "y" , mybuff);
      sprintf(mybuff,"%f",zTrans);
      focusitem->SetValue( "z" , mybuff);

      sprintf(mybuff,"%f",xRot);
      focusitem->SetValue( "rotx" , mybuff);
      sprintf(mybuff,"%f",yRot);
      focusitem->SetValue( "roty" , mybuff);
      sprintf(mybuff,"%f",zRot);
      focusitem->SetValue( "rotz" , mybuff);

      sprintf(mybuff,"%f",xScale);
      focusitem->SetValue( "scax" , mybuff);
      sprintf(mybuff,"%f",yScale);
      focusitem->SetValue( "scay" , mybuff);
      sprintf(mybuff,"%f",zScale);
      focusitem->SetValue( "scaz" , mybuff);
      focusitem->updateDialog();
    }
}

void Glcontrol::mouseMoveEvent( QMouseEvent *e )
{
    
    e->accept();
    mouse_mode = g_mouse_mode;       // wrg !!
      
   if(!g_playmode){
     if(g_mouse_mode == 3){
      if (e->buttons() & Qt::LeftButton){
        QPoint point = e->pos()-oldPos;
        if (point != QPoint(0,0)) {
//        my_context->tilt((point.x()>0)?1.0:-1.0,Camera::Yaxis);
//        my_context->tilt((point.y()>0)?1.0:-1.0,Camera::Xaxis);
//        my_context->tilt(point.y(),Camera::Xaxis);
          my_context->tilt(point.x(),Camera::Yaxis);
          my_context->tilt(point.y(),Camera::Xaxis);
          updateGL();
#ifndef    Q_OS_MACX
          QCursor::setPos(mapToGlobal(oldPos));	// dont work correct under QT OSX 10.3.6
#endif
        }
      }
      else if (e->buttons() & Qt::RightButton){
        my_context->pan(e->pos().x(), e->pos().y());
        updateGL();
      }
      else if (e->buttons() & Qt::MidButton){
        QPoint point = e->pos()-oldPos;
        if (point != QPoint(0,0)) {
//        my_context->walk((point.y()>0)?1.0:-1.0);
          my_context->walk(point.y());
          updateGL();
#ifndef    Q_OS_MACX
          QCursor::setPos(mapToGlobal(oldPos));	// dont work correct under QT OSX 10.3.6
#endif
        }
      }
    } else {
      double dx = e->x() - oldPos.x();
      double dy = e->y() - oldPos.y();

#ifndef    Q_OS_MACX
      oldPos = e->pos();
#endif

      double rx = dx / width();
      double ry = dy / height();

      if ( e->buttons() & Qt::LeftButton ){
         if(mouse_mode==0){
            if(gllook==0){
              setTranslationImpulse( rx*scale, ry*scale * -1, 0 );
            }
            if(gllook==1){
              setTranslationImpulse( ry*scale * -1, rx*scale * -1, 0 );
            }
            if(gllook==2){
              setTranslationImpulse( rx*scale * -1, ry*scale, 0  );
            }
            if(gllook==3){
              setTranslationImpulse( ry*scale, rx*scale, 0 );
            }
            if(gllook==4){
              setTranslationImpulse( rx*scale, ry*scale * -1, 0 );
            }
            if(gllook==10){
              setTranslationImpulse( rx*scale, ry*scale * -1, 0 );
            }
         }
         if(mouse_mode==1)
            setRotationImpulse( rx, ry, 0 );
         if(mouse_mode==2)
            setScaleImpulse( rx*scale/2, rx*scale/2, rx*scale/2 );
      }
      else if ( e->buttons() & Qt::RightButton ){
         if(mouse_mode==0)
            setTranslationImpulse( 0, 0, ry*scale * -1 );
         if(mouse_mode==1)
            setRotationImpulse( rx, 0, ry );
         if(mouse_mode==2)
            setScaleImpulse( 0 , rx*scale/2, 0 );
      }
      else if ( e->buttons() & Qt::MidButton ){
         if(mouse_mode==0)
            setTranslationImpulse( rx*scale, ry*scale * -1, 0 );
         if(mouse_mode==1)
            setRotationImpulse( rx, 0, ry );
         if(mouse_mode==2)
            setScaleImpulse( 0 , 0, rx*scale/2 );
      }
      else if ( e->buttons() & ( Qt::LeftButton | Qt::RightButton ) ){
            setScaleImpulse( rx*scale/2, 0 , 0);
      }
      mgox=0;
      mgoy=0;
    } 
  } else { // !g_playmode
      puMouse ( e->x(), e->y() ) ;
      mgox = ((float)e->x()-((float)width()/2)) / ((float)width()/2);
      mgoy = ((float)e->y()-((float)height()/2)) / ((float)height()/2);      
  }
#ifdef    Q_OS_MACX
  oldPos = e->pos();
#endif
}

void Glcontrol::wheelEvent( QWheelEvent *e )
{
    e->accept();
    my_context->walk((e->delta()>0)?(1.0):(-1.0));
    updateGL();
}
/*
void Glcontrol::mouseDoubleClickEvent( QMouseEvent * )
{
    if ( delay <= 0 )
	return;

}
*/
void Glcontrol::keyPressEvent(QKeyEvent *e)
{
   e->accept();
   switch(e->key()){
      case Qt::Key_P:
          if(g_playmode){

          } else {

          }
        break;
   }
   if(!g_playmode)
   {
    switch(e->key())
    {
      //edit mode
      case Qt::Key_0:
          gllook=10;
          xTrans=cxTrans;
          yTrans=cyTrans;
          zTrans=czTrans;
          xRot=cxRot;
          yRot=cyRot;
          zRot=czRot;
          globj=NULL;
          keylook=1;
        break;
      case Qt::Key_2:
          gllook=0;
          keylook=1;
        break;
      case Qt::Key_4:
          gllook=1;
          keylook=1;
        break;
      case Qt::Key_8:
          gllook=2;
          keylook=1;
        break;
      case Qt::Key_6:
          gllook=3;
          keylook=1;
        break;
      case Qt::Key_5:
          gllook=4;
          keylook=1;
        break;
      }
    } else {
       // PUI
       if ( ! puKeyboard ( e->key(), PU_DOWN ) ){
         g_key = e->text().toAscii().data ()[0];
       }
       // PLAYER
       for(int a=0;a<MAX_PLAYER;a++){
          if(gl_player[a] != NULL){
             gl_player[a] -> kbd (e->key()) ;
          }
       }
       // Usercam
       if(usercam != NULL){
             usercam -> kbd (e->key()) ;
       }
       // keyset
       if (!e->isAutoRepeat()) {
          if(g_playmode){
//            QString s = QString("Pressed: %1 %2").arg(e->key());
//            qDebug() << s;
            g_keyset.insert(e->key());
        }
    }
    }
    e->ignore();
}

//***********************************************************
//    add Elements to a scene
//***********************************************************

//**************** OBJECT *******************************************

int Glcontrol::loadObject(FolderListItem * i, ssgTransform *obj)
{
  QString tmpfile;



  CCatalogEditDlg  *catalog = new  CCatalogEditDlg("3D-Catalog",this,g_3dcatalogpath,QDir::Dirs);
  if ( catalog->exec() == QDialog::Accepted ){

#ifdef Q_OS_UNIX
  // set locale plib problem
  char * ctype = qstrdup(setlocale(LC_NUMERIC, 0));
  setlocale(LC_NUMERIC, "C");        // make sprintf()/scanf() work
#endif

         g_3dcatalogpath = catalog->getcatpath();
         QString   result = catalog->getfile();
         if(result.isEmpty()){
              globj=NULL;
              return 1; // error
         }
         QString   workingDirectory = catalog->getpath();
         qWarning( result.toAscii() );
         qWarning( workingDirectory.toAscii() );

         // copy the 3d-object folder
#ifdef    Q_OS_IRIX
	 QString   copy = "cp -DpR " + workingDirectory + result + ' ' +  g_prjpath + "data/";
         qWarning( copy.toAscii() );
         system (copy.toAscii().constData());
#endif

#ifdef    Q_OS_LINUX
         QString   copy = "cp -dpR " + workingDirectory + result + ' ' +  g_prjpath + "data/";
         qWarning( copy.toAscii() );
         system (copy.toAscii().constData());
#endif

#ifdef    Q_OS_MACX
         QString   copy = "cp -pR " + workingDirectory + result + ' ' +  g_prjpath + "data/";
         qWarning( copy.toAscii() );
         system (copy.toAscii().constData());
#endif

#ifdef    Q_OS_WIN32
// todo
//         copydir mycopy;
//         mycopy.copy(workingDirectory + result , g_prjpath + "data/" + result);
         QString   copy = "xcopy \"" + workingDirectory + result + "\" \"" +  g_prjpath + "data/" + result + "\" /e /i" ;
         qWarning( copy.toAscii() );
         system (copy.toAscii().constData());

#endif
       // find *.3ds or *.ac
         QString meshfile =  g_prjpath + "data/" + result + "/mesh.tri";
         QString msg = g_prjpath + "data/" + result;
         qWarning( msg.toAscii() );
         QDir tmpdir (g_prjpath + "data/" + result , "*.3ds *.ac");
         QStringList catlist = tmpdir.entryList();
         for ( QStringList::Iterator it = catlist.begin(); it != catlist.end(); ++it ){
            tmpfile = *it;
            qWarning( tmpfile.toAscii() );
         }
         // load the 3d-file from the project folder
         if (! tmpfile.isEmpty() ){
           setXRotation( 0 );
           setYRotation( 0 );
           setZRotation( 0 );

           setXScale(1.0f);
           setYScale(1.0f);
           setZScale(1.0f);

           ssgModelPath   ( tmpdir.path().toAscii().constData() ) ;
           ssgTexturePath ( tmpdir.path().toAscii().constData() ) ;
           ssgEntity *nobj = ssgLoad ( tmpfile.toAscii().constData() ); 

//            nobj   -> setCallback ( SSG_CALLBACK_PREDRAW , NULL ) ;
//            nobj   -> setCallback ( SSG_CALLBACK_POSTDRAW, NULL ) ;
//            nobj   -> setCallback ( SSG_CALLBACK_PREDRAW , objprecall ) ;
//            nobj   -> setCallback ( SSG_CALLBACK_POSTDRAW, objpostcall ) ;

           i->SetValue("path","data/" + result);          
           i->SetValue("file",tmpfile);
           i->setText( 0, tmpfile);
           if ( !nobj ){
              globj=NULL;
              return 1; // error
           }
           // save trimesh
           qWarning( "save trimesh \n" );
           ssgSaveTRI(meshfile.toAscii().constData(),nobj);  //@@@@ todo
           i->objtrans = new ssgTransform ;
           i->objtrans -> addKid ( nobj  ) ;
           if(obj == NULL)
             scene -> addKid ( i->objtrans ) ;
           else
             obj -> addKid ( i->objtrans ) ;

           globj=i->objtrans;
           i->gl=this;
         } else {
            QDir tmpdir (g_prjpath + "data/" + result , "*.md2");
            catlist = tmpdir.entryList();
            for ( QStringList::Iterator it = catlist.begin(); it != catlist.end(); ++it ){
                tmpfile = *it;
                qWarning( tmpfile.toAscii() );
            }
            
            // load the 3d-file from the project folder
            if (! tmpfile.isEmpty() ){
              setXRotation( 0 );
              setYRotation( 0 );
              setZRotation( 0 );

              setXScale(1.0f);
              setYScale(1.0f);
              setZScale(1.0f);

              ssgModelPath   ( tmpdir.path().toAscii().constData() ) ;
              ssgTexturePath ( tmpdir.path().toAscii().constData() ) ;

              ssgSelector *selector = (ssgSelector *)LoadMD2(tmpfile.toAscii().constData(), NULL);
              selector->selectStep ( SSG_MD2_STAND );
              ssgTimedSelector *ts = (ssgTimedSelector *)selector -> getKid( SSG_MD2_STAND );
              ts -> setMode(SSG_ANIM_SHUTTLE);
              ts -> control(SSG_ANIM_START);
              ts -> setDuration ( 0.1 , -1 , SSG_ANIM_CLOCK ) ;

              i->SetValue("path","data/" + result);
              i->SetValue("file",tmpfile);
              i->setText( 0, tmpfile);
              if ( !selector ){
                  globj=NULL;
                  return 1; // error
              }
              // save trimesh
              //qWarning( "save trimesh \n" );

              //ssgSaveTRI(meshfile.toAscii().constData(),nobj);
              i->objtrans = new ssgTransform ;
              i->objtrans -> addKid ( selector  ) ;

              if(obj == NULL)
                scene -> addKid ( i->objtrans ) ;
              else
                obj -> addKid ( i->objtrans ) ;

              globj=i->objtrans;
              i->gl=this;
            }
         }
#ifdef Q_OS_UNIX
     // restore locale plib problem
     setlocale(LC_NUMERIC, ctype);
     delete [] ctype ;
#endif
  }else{
        globj=NULL;
        return 1; // error
  }
  globj=NULL;

  return 0; // ok

//  slotStatusMsg(i18n("Ready."));
}

ssgTransform* Glcontrol::loadObjectFile(QString path , QString file, ssgTransform *obj)
{
  QString tmpfile;

  ssgEntity *nobj = NULL;
  ssgTransform *objtrans = NULL ;

#ifdef Q_OS_UNIX
  // set locale plib problem
  char * ctype = qstrdup(setlocale(LC_NUMERIC, 0));
  setlocale(LC_NUMERIC, "C");        // make sprintf()/scanf() work
#endif

      setXRotation( 0 );
      setYRotation( 0 );
      setZRotation( 0 );

      setXScale(1.0f);
      setYScale(1.0f);
      setZScale(1.0f);

      ssgModelPath   ( path.toAscii().constData() ) ;
      ssgTexturePath ( path.toAscii().constData() ) ;


      if(file.lastIndexOf( ".3ds" )!= -1 || file.lastIndexOf( ".ac" ) != -1){
          QString msg = "Load 3D file: " +  path + "/" + file;
          qWarning(  msg.toAscii()); // debug
          nobj = ssgLoad ( file.toAscii().constData () );
          if(nobj != NULL){
//            nobj   -> setCallback ( SSG_CALLBACK_PREDRAW , NULL ) ;
//            nobj   -> setCallback ( SSG_CALLBACK_POSTDRAW, NULL ) ;
//            nobj   -> setCallback ( SSG_CALLBACK_PREDRAW , objprecall ) ;
//            nobj   -> setCallback ( SSG_CALLBACK_POSTDRAW, objpostcall ) ;

            objtrans = new ssgTransform ;
            objtrans -> addKid ( nobj  ) ;

            if(obj == NULL)
               scene-> addKid ( objtrans ) ;
            else
              obj -> addKid ( objtrans ) ;

            globj=objtrans;
          } else {
            msg = "no file " +  path + file;
            qWarning(  msg.toAscii());
            globj = NULL;
          }
      }
      if(file.lastIndexOf( ".md2" )!= -1){
          qWarning( file.toAscii() );
          ssgSelector *selector = (ssgSelector *)LoadMD2(file.toAscii().constData(), NULL);
          selector->selectStep ( SSG_MD2_STAND );
          ssgTimedSelector *ts = (ssgTimedSelector *)selector -> getKid(SSG_MD2_STAND);
          ts -> setMode(SSG_ANIM_SHUTTLE);
          ts -> control(SSG_ANIM_START);
          ts -> setDuration ( 0.1 , -1 , SSG_ANIM_CLOCK ) ;
          if(ts != NULL){
            objtrans = new ssgTransform ;
            objtrans -> addKid ( selector  ) ;

            if(obj == NULL)
              scene -> addKid ( objtrans ) ;
            else
              obj -> addKid ( objtrans ) ;

            globj=objtrans;
          } else {
            QString msg = "no file " +  path + file;
            qWarning(  msg.toAscii());
            globj = NULL;
          }
      }

#ifdef Q_OS_UNIX
     // restore locale plib problem
     setlocale(LC_NUMERIC, ctype);
     delete [] ctype ;
#endif

      return objtrans;
}

// ************* 3D Object ********************
void  Glcontrol::addObjectFile(FolderListItem * i, QString path , QString file, ssgTransform *obj)
{
    i->gl=this;
    i->objtrans = loadObjectFile(path ,file,obj);
    setFocusObject(i);
}

// ************* PLAYER ********************

void  Glcontrol::addPlayer(FolderListItem * i, ssgTransform *obj)
{
   Q_UNUSED(obj);

   i->gl=this;
   i->player = new Player();
   i->SetValue("file","box.3ds");
   i->player->objtrans[0]= i->objtrans= loadObjectFile(g_prjpath +"data" , "box.3ds", NULL);
   i->player->objtrans[1]= loadObjectFile(g_prjpath +"data" , "buggyradlv.3ds", NULL);
   i->player->objtrans[2]= loadObjectFile(g_prjpath +"data" , "buggyradrv.3ds", NULL);
   i->player->objtrans[3]= loadObjectFile(g_prjpath +"data" , "buggyradlh.3ds", NULL);
   i->player->objtrans[4]=loadObjectFile(g_prjpath +"data" , "buggyradrh.3ds", NULL);

   gl_player[gl_player_num]=i->player;

   // ode
   i->player->createOdeBody(odworld, odspace);
   i->player->update ( 0.1 );

   if(gl_player_num < MAX_PLAYER-1 ){
       gl_player_num++;
   }
   setFocusPlayer(i);
}

void  Glcontrol::addPlayerFile(FolderListItem * i,QString path , QString file, ssgTransform *obj)
{
   Q_UNUSED(obj);

   i->gl=this;
   i->player = new Player();
   i->objtrans = i->player->objtrans[0] = loadObjectFile( path , file, NULL);
   i->player->objtrans[1] = loadObjectFile(path , "buggyradlv.3ds", NULL);
   i->player->objtrans[2] = loadObjectFile(path , "buggyradrv.3ds", NULL);
   i->player->objtrans[3] = loadObjectFile(path , "buggyradlh.3ds", NULL);
   i->player->objtrans[4] = loadObjectFile(path , "buggyradrh.3ds", NULL);

   gl_player[gl_player_num]=i->player;

   // ode
   i->player->createOdeBody(odworld, odspace);
   i->player->update ( 0.1 );

   if(gl_player_num < MAX_PLAYER-1 ){
    gl_player_num++;
   }
   setFocusPlayer(i);
}

// ************** BARRIER ********************

void  Glcontrol::addBarrier(FolderListItem * i, ssgTransform *obj)
{
   Q_UNUSED(obj);

   addBarrierFile(i,g_prjpath + i->GetValue("path") ,i->GetValue("file"),obj);
}

void  Glcontrol::addBarrierFile(FolderListItem * i,QString path , QString file, ssgTransform *obj)
{
   Q_UNUSED(obj);

   i->gl=this;
   i->objtrans =loadObjectFile( path , file, NULL);
   // Barrier
   i->barrier = new Barrier();
   i->barrier->setObjtrans(i->objtrans);
   i->barrier->boxobjtrans = loadObjectFile(path , "linebox.ac", i->barrier->objtrans);
   // ode
   i->barrier->createOdeBody(odspace);

   connect(this, SIGNAL(msg_motionplay_update( float )),i->barrier , SLOT(update(float)));
   setFocusBarrier(i);
}

// ************** BODY ********************

void  Glcontrol::addBody(FolderListItem * i, ssgTransform *obj)
{
   Q_UNUSED(obj);

   addBodyFile(i,g_prjpath + i->GetValue("path") ,i->GetValue("file"),obj);
}

void  Glcontrol::addBodyFile(FolderListItem * i,QString path , QString file, ssgTransform *obj)
{
   Q_UNUSED(obj);

   int typ=0;
   i->gl=this;
   i->objtrans = loadObjectFile( path , file, NULL);
   // Body
   i->body = new Body();
   i->body->setObjtrans(i->objtrans);
   i->body->boxobjtrans = loadObjectFile(g_prjpath +"data" , "linebox.ac", i->body->objtrans);
   // ode
   i->body->createOdeBody(odworld, odspace, typ);

   connect(this, SIGNAL(msg_motionplay_update( float )),i->body , SLOT(update(float)));
   setFocusBody(i);
}

// ************** SKY ********************

void    Glcontrol::addSky(FolderListItem * i, ssgTransform *obj)
{
  Q_UNUSED(obj);

  ssgaCloudLayer     *clouds = NULL ;
  ssgaCelestialBody  *bodies = NULL ;
  qcSkySystem      *sky_obj = NULL ;

  sky_obj       =  new qcSkySystem(0,my_context) ;

  // sun 
  QString texture=g_prjpath +"data/halo.rgba";
  bodies =  sky_obj -> addBody (
                  NULL,                 // body texture
                  texture.toAscii().constData (),     // halo texture
                  5000,                 // size
                  80000,                // distance
                  true );               // is sun - dome painted based on this
  bodies -> setDeclination  ( 20*SGD_DEGREES_TO_RADIANS );
  // moon
  texture=g_prjpath +"data/moon.rgba";
  bodies =  sky_obj -> addBody (
                  texture.toAscii().constData (),     // body texture
                  NULL,                 // halo texture
                  5000,                 // size
                  80000 );              // distance
  bodies -> setDeclination  ( 65*SGD_DEGREES_TO_RADIANS );
  // clouds 0
  texture=g_prjpath +"data/scattered.rgba";
  clouds =  sky_obj -> addCloud (
                 texture.toAscii().constData (), // texture
                 80000,                 // span
                 2000,                  // elevation,
                 100,                   // thickness
                 100 );                 // transition
  clouds -> setSpeed ( 50 ) ;
  clouds -> setDirection ( 45 ) ;
  // clouds 1
  clouds =  sky_obj -> addCloud (
                 texture.toAscii().constData (), // texture
                 80000,                 // span
                 3000,                  // elevation,
                 100,                   // thickness
                 100 );                 // transition
  clouds -> setSpeed ( 20 ) ;
  clouds -> setDirection ( 30 ) ;
  // clouds 2
  clouds =  sky_obj -> addCloud (
                 texture.toAscii().constData (), // texture
                 80000,                 // span
                 1000,                  // elevation,
                 100,                   // thickness
                 100 );                 // transition
  clouds -> setSpeed ( 5 ) ;
  clouds -> setDirection ( 20 ) ;

  i->sky = sky_obj;
  i->gl=this;

// msg_motion_update
   connect(this, SIGNAL(msg_motion_update( float )),i->sky , SLOT(slot_update(float)));
   connect(this, SIGNAL(msg_predraw(  )),i->sky , SLOT(slot_preDraw( )));
   connect(this, SIGNAL(msg_postdraw(  )),i->sky , SLOT(slot_postDraw( )));
   setFocusSky(i);
}


// ************** FIRE ********************


void Glcontrol::addFire(FolderListItem * i, ssgTransform *obj)
{
    char mybuff[256];
    unsigned int colorr;
    unsigned int colorg;
    unsigned int colorb;
    sgVec4  firecol;
    QString tmpfile;

    i->gl=this;
    i->fire =  new qcFire (0, MAX_FIRE_TRIS, i->GetValue("radius").toFloat(), i->GetValue("height").toFloat(), i->GetValue("speed").toFloat() );
    strncpy(mybuff,i->GetValue("hotcolor").toAscii().constData(),8);
    sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
    sgSetVec4 ( firecol, (float)colorr/255,(float)colorg/255,(float)colorb/255, 1.0f ) ;
    i->fire->setHotColour(firecol);
    i->objtrans = new ssgTransform ;
    i->objtrans-> addKid ( i->fire ) ;
    if(obj == NULL){
          scene -> addKid ( i->objtrans ) ;
    } else {
          obj -> addKid ( i->objtrans ) ;
    }
    connect(this, SIGNAL(msg_motion_update( float )),i->fire , SLOT(slot_update(float)));
    setFocusFire(i);
}

//**************** LENSFLARE *******************************************


void Glcontrol::addLamp(FolderListItem * i, ssgTransform *obj)
{
    Q_UNUSED(obj);
    int number=0;

    number =  i->GetValue("number").toInt();
    if(number >= 0 && number <=7){
        i->light=ssgGetLight(number);
        addLensflare(i, 0);
        setFocusLamp(i);
    }
}

//**************** LENSFLARE *******************************************


void Glcontrol::addLensflare(FolderListItem * i, ssgTransform *obj)
{
    i->gl=this;
    i->objtrans = new ssgTransform ;
    if(lensflare_obj){
      if(i->GetValue("lensflare").toInt()==1){
         i->objtrans-> addKid ( lensflare_obj ) ;
      }
    }
    if(obj == NULL){
      scene -> addKid ( i->objtrans ) ;
    } else {
      obj -> addKid ( i->objtrans ) ;
    }
}

//**************** PARTSYS *******************************************

void Glcontrol::addPartSys(FolderListItem * i, ssgTransform *obj)
{
  static ssgSimpleState     *splash_state = NULL ;

  splash_state = new ssgSimpleState () ;
  QString texture=g_prjpath +"data/droplet.rgb";
  splash_state -> setTexture        ( texture.toAscii().constData() ) ;
  splash_state -> setTranslucent    () ;
  splash_state -> enable            ( GL_TEXTURE_2D ) ;
  splash_state -> setShadeModel     ( GL_SMOOTH ) ;
  splash_state -> enable            ( GL_CULL_FACE ) ;
  splash_state -> enable            ( GL_BLEND ) ;
  splash_state -> enable            ( GL_LIGHTING ) ;
  splash_state -> setColourMaterial ( GL_EMISSION ) ;
  splash_state -> setMaterial       ( GL_AMBIENT, 0, 0, 0, 1 ) ;
  splash_state -> setMaterial       ( GL_DIFFUSE, 0, 0, 0, 1 ) ;
  splash_state -> setMaterial       ( GL_SPECULAR, 0, 0, 0, 1 ) ;
  splash_state -> setShininess      (  0 ) ;

  i->partsys =  new  qcPartsys ( 0,1000, 100, 500, true,
                                      0.2f, 1000,
                                      qcPartsys::droplet_create );

  i->partsys -> setState ( splash_state );

  i->gl=this;
  i->objtrans = new ssgTransform ;
  i->objtrans-> addKid ( i->partsys );
  if(obj == NULL)
    scene -> addKid ( i->objtrans );
  else
    obj -> addKid ( i->objtrans );

  connect(this, SIGNAL(msg_motion_update( float )),i->partsys , SLOT(slot_update(float)));
  setFocusPartSys(i);
}

//**************** WAVESYS *******************************************

void Glcontrol::addWaveSys(FolderListItem * i, ssgTransform *obj)
{ 
    sgVec4  TRANSLUCENT_WHITE  = { 1.0f, 1.0f, 1.0f, 0.8f } ;
    sgVec3  pos    = { 0, 0, 0 } ;

  i->wavesys   =  new qcWaveSystem ( 0,10000 ) ;  // 10000
  i->wavesys   -> setColour        ( TRANSLUCENT_WHITE ) ;
  i->wavesys   -> setSize          ( i->GetValue("size").toFloat() );
  i->wavesys   -> setTexScale      ( i->GetValue("texsx").toFloat(), i->GetValue("texsx").toFloat());
  i->wavesys   -> setCenter        ( pos ) ;
  i->wavesys   -> setDepthCallback ( NULL ) ;
  i->wavesys   -> setKidState      ( i->wavesys->add_sea_state() ) ;
  i->wavesys   -> setWindSpeed     ( i->GetValue("wspeed").toFloat());

  i->wavesys   -> setWaveTrain     ( 0, i->wavesys->add_wtrains(3.1f, 0.8f, 0.6f, 47.0f, 0.2f));
  i->wavesys   -> setWaveTrain     ( 1, i->wavesys->add_wtrains(4.6f, 0.8f, 1.0f, 36.0f, 0.1f));
  i->wavesys   -> setWaveTrain     ( 2, i->wavesys->add_wtrains(8.5f, 0.6f, 1.0f, 65.0f, 0.1f));

  i->wavesys   -> setKidCallback   ( SSG_CALLBACK_PREDRAW , NULL ) ;
  i->wavesys   -> setKidCallback   ( SSG_CALLBACK_POSTDRAW, NULL ) ;
  i->wavesys   -> regenerate       () ;

  i->gl=this;
  i->objtrans = new ssgTransform ;
  i->objtrans-> addKid ( i->wavesys );

  if(obj == NULL)
        scene -> addKid ( i->objtrans );
  else
        obj -> addKid ( i->objtrans );

  connect(this, SIGNAL(msg_motion_update( float )),i->wavesys , SLOT(slot_update(float)));
  setFocusWaveSys(i);
}

//**************** CAMERA *******************************************

void Glcontrol::addCamera(FolderListItem * i, ssgTransform *obj)
{
   i->gl=this;
   i->usercam = new usercamera(my_context);
   i->usercam->objtrans = i->objtrans = loadObjectFile(g_prjpath + i->GetValue("path") ,i->GetValue("file"),obj);
   i->usercam->item = i;
   setFocusCamera(i);
}
//**************** TMPOBJECT *******************************************

int    Glcontrol::addTmpObject(FolderListItem * i, FolderListItem * imodel, ssgTransform *obj, sgCoord pos, int id)
{
  FolderListItem * iditem; 
  i->gl=this;
  i->objtrans = new ssgTransform ;
  if(i->objtrans != NULL){
      if(id){  // add kid to listitem with number id
             
          if((iditem = i->search_id((FolderListItem *)i->treeWidget()->invisibleRootItem(),id)) == NULL){
            QString msg = "addTmpObject: There is no such Object as ID" + id ;
            qWarning(msg.toAscii());
          } else {
            obj=  iditem->objtrans;
          }
      }
      if(imodel->text(1) == "OBJECT"){
          i->objtrans->setTransform ( & pos, imodel->GetValue ( "scax" ).toFloat(),
                                          imodel->GetValue ( "scay" ).toFloat(),
                                          imodel->GetValue ( "scaz" ).toFloat()) ;

          if(imodel->objtrans-> getKid(0)-> isAKindOf(ssgTypeEntity())) {
             i->objtrans -> addKid ( (ssgEntity *)imodel->objtrans-> getKid(0) ) ;
             if(obj == NULL)
               scene -> addKid ( i->objtrans );
             else
               obj -> addKid ( i->objtrans );
             return 0;
          }
      }
   }
   return 1; // error
}

//**************** FOG *******************************************

void Glcontrol::addFog(FolderListItem * i)
{
   i->fog= new qcFog();
   i->gl=this;

   connect(this, SIGNAL(msg_motion_update( float )),i->fog , SLOT(slot_update(float)));
   connect(this, SIGNAL(msg_predraw(  )),i->fog , SLOT(slot_preDraw( )));
   connect(this, SIGNAL(msg_postdraw(  )),i->fog , SLOT(slot_postDraw( )));
   setFocusFog(i);
}

//**************** SPL *******************************************

int Glcontrol::addSpl(FolderListItem * i, ssgTransform *obj)
{
  QString tmpfile;
  QFileDialog SFileDialog;
  i->gl=this;
  CCatalogEditDlg  *catalog = new  CCatalogEditDlg("SPL-Catalog",this,g_scriptcatalogpath,QDir::Files);
  if ( catalog->exec() == QDialog::Accepted ){
         g_scriptcatalogpath = catalog->getcatpath();
         QString   result = catalog->getfile();
         QString msg = "LoadName: " + result;
         qWarning( msg.toAscii() );
         if(result.isEmpty()){
              return 1; // error
         }
         QString   workingDirectory = catalog->getpath();
         qWarning( workingDirectory.toAscii() );
         // get the new spl filename
         QString surl=SFileDialog.getSaveFileName(this,"Save File...",g_prjpath + "data/","*.spl (*.spl)" );
         if(!surl.isEmpty()){
              QFileInfo f(surl);
              QString sname = f.fileName();
              QString msg = "SaveName: " + f.fileName();
              qWarning( msg.toAscii() );
              // copy the spl file in the project folder
              QFile srcFile(workingDirectory+result);
              srcFile.copy(g_prjpath + "data/" + sname);
        
              tmpfile = g_prjpath + "data/" + sname ;
              msg = "spl: " + tmpfile;
              qWarning( msg.toAscii() );
              i->SetValue("file",sname);
              i->setText( 0, sname);
              QString mypath=g_prjpath + "data";
              addSPLFile(i,mypath,sname,obj);
        }
 }
 return 0;
}

//**************** QTSCRIPT (javascript) *******************************************

int Glcontrol::addQTScript(FolderListItem * i, ssgTransform *obj)
{
  QString tmpfile;
  QFileDialog SFileDialog;
  i->gl=this;
  CCatalogEditDlg  *catalog = new  CCatalogEditDlg("JS-Catalog",this,g_scriptcatalogpath,QDir::Files);
  if ( catalog->exec() == QDialog::Accepted ){
         g_scriptcatalogpath = catalog->getcatpath();
         QString   result = catalog->getfile();
         QString msg = "LoadName: " + result;
         qWarning( msg.toAscii() );
         if(result.isEmpty()){
              return 1; // error
         }
         QString   workingDirectory = catalog->getpath();
         qWarning( workingDirectory.toAscii() );
         // get the new js filename
         QString surl=SFileDialog.getSaveFileName(this,"Save File...",g_prjpath + "data/","*.js (*.js)" );
         if(!surl.isEmpty()){
              QFileInfo f(surl);
              QString sname = f.fileName();
              QString msg = "SaveName: " + f.fileName();
              qWarning( msg.toAscii() );
              // copy the js file in the project folder
              QFile srcFile(workingDirectory+result);
              srcFile.copy(g_prjpath + "data/" + sname);
        
              tmpfile = g_prjpath + "data/" + sname ;
              msg = "js: " + tmpfile;
              qWarning( msg.toAscii() );
              i->SetValue("file",sname);
              i->setText( 0, sname);
              QString mypath=g_prjpath + "data";
              addQTSFile(i,mypath,sname,obj);
        }
 }
 return 0;
}
//**************** python *******************************************

int Glcontrol::addPython(FolderListItem * i, ssgTransform *obj)
{
  QString tmpfile;
  QFileDialog SFileDialog;
  i->gl=this;
  CCatalogEditDlg  *catalog = new  CCatalogEditDlg("PYTHON-Catalog",this,g_scriptcatalogpath,QDir::Files);
  if ( catalog->exec() == QDialog::Accepted ){
         g_scriptcatalogpath = catalog->getcatpath();
         QString   result = catalog->getfile();
         QString msg = "LoadName: " + result;
         qWarning( msg.toAscii() );
         if(result.isEmpty()){
              return 1; // error
         }
         QString   workingDirectory = catalog->getpath();
         qWarning( workingDirectory.toAscii() );
         // get the new js filename
         QString surl=SFileDialog.getSaveFileName(this,"Save File...",g_prjpath + "data/","*.py (*.py)" );
         if(!surl.isEmpty()){
              QFileInfo f(surl);
              QString sname = f.fileName();
              QString msg = "SaveName: " + f.fileName();
              qWarning( msg.toAscii() );
              // copy the js file in the project folder
              QFile srcFile(workingDirectory+result);
              srcFile.copy(g_prjpath + "data/" + sname);
        
              tmpfile = g_prjpath + "data/" + sname ;
              msg = "py: " + tmpfile;
              qWarning( msg.toAscii() );
              i->SetValue("file",sname);
              i->setText( 0, sname);
              QString mypath=g_prjpath + "data";
              addPythonFile(i,mypath,sname,obj);
       }
 }
 return 0;
}

void Glcontrol::addSPLFile(FolderListItem * i, QString path , QString file, ssgTransform *obj)
{
  Q_UNUSED(obj);

  QString tmpfile;

      i->gl=this;
      tmpfile = path + "/" + file;
      i->scriptprog = new splPrg(tmpfile.toAscii().constData());
      connect(this, SIGNAL(msg_ph_update (const QString &)),i->scriptprog , SLOT(slot_update(const QString &)));
      connect(this, SIGNAL(msg_compile()),i->scriptprog , SLOT(slot_compile()));
      setFocusScriptprg(i);
}

void Glcontrol::addQTSFile(FolderListItem * i, QString path , QString file, ssgTransform *obj)
{
  Q_UNUSED(obj);
  QString tmpfile;

      i->gl=this;
      tmpfile = path + "/" + file;
      i->scriptprog = new qtscriptPrg(tmpfile.toAscii().constData());
      connect(this, SIGNAL(msg_ph_update (const QString &)),i->scriptprog , SLOT(slot_update(const QString &)));
      connect(this, SIGNAL(msg_compile()),i->scriptprog , SLOT(slot_compile()));
      setFocusScriptprg(i);
}

void Glcontrol::addPythonFile(FolderListItem * i, QString path , QString file, ssgTransform *obj)
{
  Q_UNUSED(obj);
  QString tmpfile;

      i->gl=this;
      tmpfile = path + "/" + file;
      i->scriptprog = new python_prg(tmpfile.toAscii().constData());
      connect(this, SIGNAL(msg_ph_update (const QString &)),i->scriptprog , SLOT(slot_update(const QString &)));
      connect(this, SIGNAL(msg_compile()),i->scriptprog , SLOT(slot_compile()));
      setFocusScriptprg(i);
}


//**************** SHADER *******************************************
int Glcontrol::addShader(FolderListItem * i, ssgTransform *obj)
{
  Q_UNUSED(obj);

  QString tmpvfile;
  QString tmpffile;

  i->gl=this;
  CCatalogEditDlg  *catalog = new  CCatalogEditDlg("Shader-Catalog",this,g_shadercatalogpath,QDir::Dirs);
  if ( catalog->exec() == QDialog::Accepted ){
         g_shadercatalogpath = catalog->getcatpath();
         QString   result = catalog->getfile();
         if(result.isEmpty()){
              return 1; // error
         }
         QString   workingDirectory = catalog->getpath();
         qWarning( result.toAscii() );
         qWarning( workingDirectory.toAscii() );

         // copy the shader-folder
#ifdef    Q_OS_IRIX
	 QString   copy = "cp -DpR " + workingDirectory + result + ' ' +  g_prjpath + "data/";
         qWarning( copy.toAscii() );
         system (copy.toAscii().constData());
#endif

#ifdef    Q_OS_LINUX
         QString   copy = "cp -dpR " + workingDirectory + result + ' ' +  g_prjpath + "data/";
         qWarning( copy.toAscii() );
         system (copy.toAscii().constData());
#endif

#ifdef    Q_OS_MACX
         QString   copy = "cp -pR " + workingDirectory + result + ' ' +  g_prjpath + "data/";
         qWarning( copy.toAscii() );
         system (copy.toAscii().constData());
#endif

#ifdef    Q_OS_WIN32
// todo
//         copydir mycopy;
//         mycopy.copy(workingDirectory + result , g_prjpath + "data/" + result);
         QString   copy = "xcopy \"" + workingDirectory + result + "\" \"" +  g_prjpath + "data/" + result + "\" /e /i" ;
         qWarning( copy.toAscii() );
         system (copy.toAscii().constData());
#endif
         QDir tmpdirv (g_prjpath + "data/" + result , "*.vert");
         QStringList catlist = tmpdirv.entryList();
         for ( QStringList::Iterator it = catlist.begin(); it != catlist.end(); ++it ){
            tmpvfile = *it;
//            qWarning( tmpvfile.toAscii() );
         }

         QDir tmpdirf (g_prjpath + "data/" + result , "*.frag");
         catlist = tmpdirf.entryList();
         for ( QStringList::Iterator it = catlist.begin(); it != catlist.end(); ++it ){
            tmpffile = *it;
//            qWarning( tmpffile.toAscii() );
         }

         // load the vertex and pixel-schader file from the project folder
         if ((! tmpvfile.isEmpty()) && (! tmpffile.isEmpty())){
            QFileInfo f(tmpffile);
            QString sname = f.fileName();
            i->SetValue("ffile",sname);
            tmpvfile = tmpdirv.path() + "/" + tmpvfile;
            tmpffile = tmpdirf.path() + "/" + tmpffile;
            qWarning( tmpvfile.toAscii() );
            qWarning( tmpffile.toAscii() );
            i->scriptprog = new shader(tmpvfile.toAscii().constData(),tmpffile.toAscii().constData());
            setFocusScriptprg(i);
         }
  }
  return 0;
}

void Glcontrol::addShaderFile(FolderListItem * i, QString path , QString vfile, QString ffile, ssgTransform *obj)
{
  Q_UNUSED(obj);

  QString tmpvfile;
  QString tmpffile;

    i->gl=this;
    tmpvfile = path + "/" + vfile;
    tmpffile = path + "/" + ffile;
    i->scriptprog = new shader(tmpvfile.toAscii().constData(),tmpffile.toAscii().constData());
    setFocusScriptprg(i);
}

//**************** CURSOR *******************************************

void Glcontrol::addCursor(FolderListItem * i)
{
      i->gl=this;
      i->cursor = new cursor3d();
      connect(this, SIGNAL(msg_motionplay_update( float )),i->cursor , SLOT(update(float)));
      setFocusCursor(i);
}

//**************** GUITXT *******************************************

void Glcontrol::addGUITXT(FolderListItem * i)
{
   i->gl=this;
   globj=NULL;
   i->guitext = new  GUIText(10,10);
   setFocusGUIText(i);
}

//**************** GUIButton *******************************************

void Glcontrol::addGUIButton(FolderListItem * i)
{
   i->gl=this;
   globj=NULL;
   i->guibutton = new  GUIButton(10,10,"nonamed");
   i->guibutton->setValue     ( false ) ;
   setFocusGUIButton(i);
}

//**************** GUIOSButton *******************************************

void Glcontrol::addGUIOSButton(FolderListItem * i)
{
   i->gl=this;
   globj=NULL;
   i->guiosbutton = new  GUIOSButton(10,10,"nonamed");
   i->guiosbutton->setValue     ( false ) ;
   setFocusGUIOSButton(i);
}

//**************** GUIInput *******************************************

void Glcontrol::addGUIInput(FolderListItem * i)
{
   i->gl=this;
   globj=NULL;
   i->guiinput = new  GUIInput(10,10,90,30);
   setFocusGUIInput(i);
}

//**************** Network *******************************************

void Glcontrol::addNetwork(FolderListItem * i)
{
   Q_UNUSED(i);
// todo with qt4 network class
/*
   i->gl=this;
   globj=NULL;
   i->client = new  netclient();
   g_client = i->client;
*/
}

//**************** SOUND *******************************************

void Glcontrol::addSound(FolderListItem * i, ssgTransform *obj)
{
  QString copy;

    QString url = QFileDialog::getOpenFileName(this,
       tr("Open Sound"), ".", tr("Sound Files (*.wav)"));

    if(!url.isEmpty())
    {
      QFileInfo f(url);
      QString sname = f.fileName();
      // copy the sound file in the project folder
      copy = "cp " + url + ' ' +  g_prjpath + "data/" ; 
      qWarning( copy.toAscii() );
      system (copy.toAscii().constData());
      i->SetValue("file",sname);
      i->setText( 0, sname);
      addSoundFile(i,g_prjpath + i->GetValue("path") , sname, obj);
    }
}

void Glcontrol::addSoundFile(FolderListItem * i, QString path , QString file, ssgTransform *obj)
{
  QString tmpfile;

   ssgModelPath   ( path.toAscii().constData() ) ;
   ssgTexturePath ( path.toAscii().constData() ) ;

   tmpfile = path + "/" + file;

   i->gl=this;
   i->objtrans = loadObjectFile(g_prjpath +"data" , "minibox.ac", obj);
   i->sound = new AlSound();	// use OpenAL Spartial 3d Sound
   i->sound->boxobjtrans = loadObjectFile(g_prjpath +"data" , "linebox.ac", i->objtrans);
   i->sound->loadFile(tmpfile);
   connect(this, SIGNAL(msg_sound_stop()),i->sound , SLOT(slot_stop()));
   setFocusSound(i);
   qDebug() << "add Sound: " << tmpfile;
}

//**************** MEDIA *******************************************

void Glcontrol::addMedia(FolderListItem * i, ssgTransform *obj)
{
     addMediaFile(i,g_prjpath + i->GetValue("path") , "", obj);
}

void Glcontrol::addMediaFile(FolderListItem * i, QString path , QString file, ssgTransform *obj)
{
  QString tmpfile;

   ssgModelPath   ( path.toAscii().constData() ) ;
   ssgTexturePath ( path.toAscii().constData() ) ;

   tmpfile = path + "/" + file;

   i->gl=this;
   i->objtrans = loadObjectFile(g_prjpath +"data" , "minibox.ac", obj);
   i->media = new qcPhonon(i);	// use Phonen Sound Module
   i->media->boxobjtrans = loadObjectFile(g_prjpath +"data" , "linebox.ac", i->objtrans);
   i->media->loadFile(tmpfile);
   connect(this, SIGNAL(msg_sound_stop()),i->media , SLOT(slot_stop()));
   setFocusMedia(i);
   qDebug() << "add Media: " << tmpfile;
}

void Glcontrol::setMouseMode(int mode)
{
    //  0 Tanslate
    //  1 Rotate
    //  2 Scale
    
    mouse_mode=mode;
}

void Glcontrol::initFolderListItem(FolderListItem * i,const QString &path)
{
    int a;

    if ( !i )
         return;

    for(a=0; a < i->childCount (); a++) {
    QTreeWidgetItem *ichild = i->child(a);
    if(ichild != NULL){
      if(ichild->text(1) == "LAMP"){
        qWarning(  "LAMP OK !" );
        addLamp((FolderListItem *) ichild, i->objtrans);
      }
      if(ichild->text(1) == "OBJECT"){
        qWarning(  "OBJECT OK !" );
        addObjectFile((FolderListItem *)ichild,path + ((FolderListItem *)ichild)->GetValue("path") ,((FolderListItem *)ichild)->GetValue("file"),i->objtrans);
      }
      if(ichild->text(1) == "PLAYER"){
        qWarning(  "PLAYER OK !" );
        addPlayerFile((FolderListItem *)ichild,path + ((FolderListItem *)ichild)->GetValue("path") ,((FolderListItem *)ichild)->GetValue("file"),i->objtrans);
      }
      if(ichild->text(1) == "BARRIER"){
        qWarning(  "BARRIER OK !" );
        addBarrierFile((FolderListItem *)ichild,path + ((FolderListItem *)ichild)->GetValue("path") ,((FolderListItem *)ichild)->GetValue("file"),i->objtrans);
      }
      if(ichild->text(1) == "BODY"){
        qWarning(  "BODY OK !" );
        addBodyFile((FolderListItem *)ichild,path + ((FolderListItem *)ichild)->GetValue("path") ,((FolderListItem *)ichild)->GetValue("file"),i->objtrans);
      }
      if(ichild->text(1) == "CAMERA"){
        qWarning(  "CAMERA OK !" );
        addCamera((FolderListItem *)  ichild, i->objtrans);
      }
      if(ichild->text(1) == "FIRE"){
        qWarning(  "FIRE OK !" );
        addFire((FolderListItem *) ichild, i->objtrans);
      }
      if(ichild->text(1) == "PARTSYS"){
        qWarning(  "PARTSYS OK !" );
        addPartSys((FolderListItem *) ichild, i->objtrans);
      }
      if(ichild->text(1) == "WAVESYS"){
        qWarning(  "WAVESYS OK !" );
        addWaveSys((FolderListItem *) ichild, i->objtrans);
      }
      if(ichild->text(1) == "FOG"){
        qWarning(  "FOG OK !" );
        addFog((FolderListItem *) ichild);
      }
      if(ichild->text(1) == "SKY"){
        qWarning(  "SKY OK !" );
        addSky((FolderListItem *) ichild, i->objtrans);
      }
      if(ichild->text(1) == "SPL"){
        qWarning(  "SPL OK !" );
        addSPLFile((FolderListItem *)ichild,path + ((FolderListItem *)ichild)->GetValue("path") ,((FolderListItem *)ichild)->GetValue("file"),i->objtrans);
      }
      if(ichild->text(1) == "JS"){
        qWarning(  "QTS OK !" );
        addQTSFile((FolderListItem *)ichild,path + ((FolderListItem *)ichild)->GetValue("path") ,((FolderListItem *)ichild)->GetValue("file"),i->objtrans);
      }
      if(ichild->text(1) == "PYTHON"){
        qWarning(  "PYTHON OK !" );
        addPythonFile((FolderListItem *)ichild,path + ((FolderListItem *)ichild)->GetValue("path") ,((FolderListItem *)ichild)->GetValue("file"),i->objtrans);
      }
      if(ichild->text(1) == "SHADER"){
        qWarning(  "SHADER OK !" );
        addShaderFile((FolderListItem *)ichild,path + ((FolderListItem *)ichild)->GetValue("path") ,((FolderListItem *)ichild)->GetValue("vfile"),((FolderListItem *)ichild)->GetValue("ffile"),i->objtrans);
      }
      if(ichild->text(1) == "SOUND"){
        qWarning(  "SOUND OK !" );
        addSoundFile((FolderListItem *)ichild,path + ((FolderListItem *)ichild)->GetValue("path") ,((FolderListItem *)ichild)->GetValue("file"),i->objtrans);
      }
      if(ichild->text(1) == "MEDIA"){
        qWarning(  "MEDIA OK !" );
        addMediaFile((FolderListItem *)ichild,path + ((FolderListItem *)ichild)->GetValue("path") ,((FolderListItem *)ichild)->GetValue("file"),i->objtrans);
      }
      if(ichild->text(1) == "CURSOR"){
        qWarning(  "CURSOR OK !" );
        addCursor((FolderListItem *) ichild);
      }
      if(ichild->text(1) == "GUI-TXT"){
        qWarning(  "GUI-TXT OK !" );
        addGUITXT((FolderListItem *) ichild);
      }
      if(ichild->text(1) == "GUI-BUTTON"){
        qWarning(  "GUI-Button OK !" );
        addGUIButton((FolderListItem *) ichild);
      }
      if(ichild->text(1) == "GUI-OSBUTTON"){
        qWarning(  "GUI-OSButton OK !" );
        addGUIOSButton((FolderListItem *) ichild);
      }
      if(ichild->text(1) == "GUI-INPUT"){
        qWarning(  "GUI-Input OK !" );
        addGUIInput((FolderListItem *) ichild);
      }
      if(ichild->text(1) == "NETWORK"){
        qWarning(  "Network OK !" );
        addNetwork((FolderListItem *) ichild);
      }
      initFolderListItem((FolderListItem *)ichild,path);
    }
    }
}

//***********************************************************
//    set the focus to a Elements
//***********************************************************

void Glcontrol::setFocusDefault(FolderListItem * i)
{
    sgCoord tmpobjpos ;

    if(i->objtrans != NULL){
         globj = i->objtrans;

      setXTrans( i->GetValue("x").toFloat() );
      setYTrans( i->GetValue("y").toFloat() );
      setZTrans( i->GetValue("z").toFloat() );
      setXRotation( i->GetValue("rotx").toFloat() );
      setYRotation( i->GetValue("roty").toFloat() );
      setZRotation( i->GetValue("rotz").toFloat() );

      if(i->GetValue("on").toInt() == 0){
        setXScale( 0.0001f );
        setYScale( 0.0001f );
        setZScale( 0.0001f );
      } else {
        setXScale( i->GetValue("scax").toFloat() );
        setYScale( i->GetValue("scay").toFloat() );
        setZScale( i->GetValue("scaz").toFloat() );
      }
      focusitem = i;
      // Translate, Rotate , Scale
      sgSetCoord ( & tmpobjpos, xTrans,  yTrans, zTrans, zRot, xRot, yRot ) ;  // x,y,z,h,p,r
      i->objtrans -> setTransform ( & tmpobjpos,xScale,yScale,zScale) ;
    } else {
        globj=NULL;
    }
}

void Glcontrol::setFocusObject(FolderListItem * i)
{
  sgCoord       pos ;

    if(i->objtrans != NULL){
      // x,y,z,h,p,r
      sgSetCoord ( &pos,
                  i->GetValue("x").toFloat(),
                  i->GetValue("y").toFloat(),
                  i->GetValue("z").toFloat(),
                  i->GetValue("rotz").toFloat(),
                  i->GetValue("rotx").toFloat(),
                  i->GetValue("roty").toFloat() ) ;

      if(i->GetValue("barrier").toInt() == 1){
        if(i->tribarrier == NULL){
            QString file = g_prjpath + i->GetValue("path") + "/mesh.tri" ;
            QString msg = "trimesh: " + file;
            qWarning( file.toAscii() );
            i->tribarrier = new TriBarrier();
            i->tribarrier->createTriMesh( odspace , file.toAscii().constData());
        }
      }

      if(i->GetValue("on").toInt() == 0){
        i->objtrans->setTransform ( & pos,0.0001f,0.0001f,0.0001f) ;
      } else {
          i->objtrans->setTransform ( & pos,
                                      i->GetValue("scax").toFloat(),
                                      i->GetValue("scay").toFloat(),
                                      i->GetValue("scaz").toFloat()) ;
          i->objtrans->recalcBSphere();
          if(i->tribarrier != NULL){
             i->tribarrier->pos.xyz[0] = i->GetValue("x").toFloat();
             i->tribarrier->pos.xyz[1] = i->GetValue("y").toFloat();
             i->tribarrier->pos.xyz[2] = i->GetValue("z").toFloat();

             i->tribarrier->pos.hpr[0] = i->GetValue("rotx").toFloat();
             i->tribarrier->pos.hpr[1] = i->GetValue("roty").toFloat();
             i->tribarrier->pos.hpr[2] = i->GetValue("rotz").toFloat();
             i->tribarrier->SetPosition ();
          }
      }
   }
   setFocusDefault(i);
}

void Glcontrol::setFocusScene(FolderListItem * i)
{
    char mybuff[256];
    unsigned int colorr;
    unsigned int colorg;
    unsigned int colorb;

//      i->gl->setCaption( tr( i->text(0) ) );
      dWorldSetGravity(odworld,i->GetValue("wgx").toFloat(),i->GetValue("wgy").toFloat(),i->GetValue("wgz").toFloat());  
      strncpy(mybuff,i->GetValue("color_back",i).toAscii().constData(),8);
      sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
      glClearColor ( (float)colorr/255, (float)colorg/255, (float)colorb/255 ,1.0f) ;

      if(i->GetValue("cgplane").toInt() == 0){
         if(odground != NULL){
            dGeomDestroy (odground);
            odground = NULL;
         }
      } else {
         if(odground == NULL){
            odground = dCreatePlane(odspace,0,0,1,0);
         }
      }
      globj=NULL;
}

void Glcontrol::setFocusPlayer(FolderListItem * i)
{
     if(i->player != NULL){
        i->player->rotspeed = i->GetValue("rotsp").toFloat();
        i->player->transspeed = i->GetValue("transp").toFloat();
        i->player->fmax2 = i->GetValue("fmax2").toFloat();
        
        // keyboard
        i->player->kbforward =  (i->GetValue("kbforward").at(0)).toAscii();
        i->player->kbback = (i->GetValue("kbback").at(0)).toAscii();
        i->player->kbleft = (i->GetValue("kbleft").at(0)).toAscii();
        i->player->kbright = (i->GetValue("kbright").at(0)).toAscii();

        i->player->pos.xyz[0] = i->GetValue("x").toFloat();
        i->player->pos.xyz[1] = i->GetValue("y").toFloat();

        i->player->pos.hpr[0] = i->GetValue("rotx").toFloat();
        i->player->pos.hpr[1] = i->GetValue("roty").toFloat();
        i->player->pos.hpr[2] = i->GetValue("rotz").toFloat();

        i->player->kbcamrotadd = (i->GetValue("kbcamrotadd").at(0)).toAscii();
        i->player->kbcamrotsub = (i->GetValue("kbcamrotsub").at(0)).toAscii();
        i->player->kbcamradadd = (i->GetValue("kbcamradadd").at(0)).toAscii();
        i->player->kbcamradsub = (i->GetValue("kbcamradsub").at(0)).toAscii();
        i->player->kbcamheightadd = (i->GetValue("kbcamheightadd").at(0)).toAscii();
        i->player->kbcamheightsub = (i->GetValue("kbcamheightsub").at(0)).toAscii();

        i->player->camradius = i->GetValue("camradius").toFloat();
        i->player->camrotw = i->GetValue("camrotw").toFloat();
        i->player->camhight = i->GetValue("camhight").toFloat();
        
        i->player->jaxis[0][0] = i->GetValue("ax1").toInt();
        i->player->jaxis[0][1] = i->GetValue("ay1").toInt();
        i->player->jaxis[1][0] = i->GetValue("ax2").toInt();
        i->player->jaxis[1][1] = i->GetValue("ay2").toInt();
        
        if(i->GetValue("on").toInt() == 0){
            i->player->pos.xyz[2] = OBJ_OFF ;
        } else {
            i->player->pos.xyz[2] = i->GetValue("z").toFloat() ;
        }
      
      // ode   Test   move to player

        i->player->SetPosition ();
      
      // controller
        if(i->GetValue("kbd").toInt() == 1){
            i->player->controller = 1 ;
        }
        if(i->GetValue("maus").toInt() == 1){
            i->player->controller = 2 ;
        }
        if(i->GetValue("joystick").toInt() == 1){
            i->player->controller = 3 ;
        }
        if(i->GetValue("joystick").toInt() == 2){
            i->player->controller = 4 ;
        }
        if(i->GetValue("network").toInt() == 1){
            i->player->controller = 5 ;
        }
      
      // cameratyp
        if(i->GetValue("camfix").toInt() == 1){
            i->player->camtyp = 1 ;
        }
        if(i->GetValue("cam2d").toInt() == 1){
            i->player->camtyp = 2 ;
        }
        if(i->GetValue("camego").toInt() == 1){
            i->player->camtyp = 3 ;
        }
        QString msg = "setFocusPlayer Player Object OK " + i->player->controller +  i->player->camtyp;
        qWarning(  msg.toAscii());
     } else {
          qWarning(  "setFocusPlayer No Player Object " );
     }
     setFocusDefault(i);
}
void Glcontrol::setFocusBarrier(FolderListItem * i)
{

    sgCoord    boxpos;
    float barrz=0.0f;
    
     if(i->barrier != NULL){
       if(i->barrier->boxobjtrans != NULL){
         sgSetCoord ( & boxpos, 0,  0, 0, 0, 0, 0 ) ;
         if(i->GetValue("viewbox").toInt() == 0){
           i->barrier->boxobjtrans -> setTransform ( & boxpos,0.0f,0.0f,0.0f) ;
         } else {
           i->barrier->boxobjtrans -> setTransform ( & boxpos,1.0f,1.0f,1.0f) ;
         }
       }

      // ode   Test   move to player
       if(i->GetValue("on").toInt() == 0){
         barrz = OBJ_OFF ;
       } else {
         barrz = i->GetValue("z").toFloat() ;
       }
       dGeomBoxSetLengths (i->barrier->odbox, i->GetValue("scax").toFloat(), i->GetValue("scay").toFloat(), i->GetValue("scaz").toFloat());

        i->barrier->pos.xyz[0] = i->GetValue("x").toFloat();
        i->barrier->pos.xyz[1] = i->GetValue("y").toFloat();
        i->barrier->pos.xyz[2] = barrz;

        i->barrier->pos.hpr[0] = i->GetValue("rotx").toFloat();
        i->barrier->pos.hpr[1] = i->GetValue("roty").toFloat();
        i->barrier->pos.hpr[2] = i->GetValue("rotz").toFloat();
        i->barrier->setPosition ();
     } else {
          qWarning(  "setFocusBarrier No Barrier Object " );
     }
     setFocusDefault(i);
}

void Glcontrol::setFocusBody(FolderListItem * i)
{
    sgCoord    boxpos;
    float bodyz=0.0f;
    int typ=0;
    
     // enable or disable VIEWBOX
     if(i->body != NULL){
       if(i->body->boxobjtrans != NULL){
         sgSetCoord ( & boxpos, 0,  0, 0, 0, 0, 0 ) ;
         if(i->GetValue("viewbox").toInt() == 0){
           i->body->boxobjtrans -> setTransform ( & boxpos,0.0f,0.0f,0.0f) ;
         } else {
           i->body->boxobjtrans -> setTransform ( & boxpos,1.0f,1.0f,1.0f) ;
         }
       }

      // ode
       if(i->GetValue("box").toInt() == 1){
         typ=0;
       }
       if(i->GetValue("cylinder").toInt() == 1){
         typ=1;
       }
       if(i->GetValue("sphere").toInt() == 1){
         typ=2;
       }
       i->body->typ(odspace, typ);
   
       if(i->GetValue("on").toInt() == 0){
         bodyz = OBJ_OFF ;
       }
       else{
        bodyz = i->GetValue("z").toFloat() ;
       }
       i->body->Scale (i->GetValue("scax").toFloat(), i->GetValue("scay").toFloat(), i->GetValue("scaz").toFloat());
       i->body->adjustMass(i->GetValue("mass").toFloat());

       i->body->pos.xyz[0] = i->GetValue("x").toFloat();
       i->body->pos.xyz[1] = i->GetValue("y").toFloat();
       i->body->pos.xyz[2] = bodyz;

       i->body->pos.hpr[0] = i->GetValue("rotx").toFloat();
       i->body->pos.hpr[1] = i->GetValue("roty").toFloat();
       i->body->pos.hpr[2] = i->GetValue("rotz").toFloat();

       i->body->lvel[0] = i->GetValue("lvx").toFloat();
       i->body->lvel[1] = i->GetValue("lvy").toFloat();
       i->body->lvel[2] = i->GetValue("lvz").toFloat();

       i->body->avel[0] = i->GetValue("avx").toFloat();
       i->body->avel[1] = i->GetValue("avy").toFloat();
       i->body->avel[2] = i->GetValue("avz").toFloat();
      
       i->body->setPosition ();
     } else {
          qWarning(  "setFocusBody No Barrier Object " );
     }
     setFocusDefault(i);
}

void Glcontrol::setFocusLamp(FolderListItem * i)
{
    char mybuff[256];
    unsigned int colorr;
    unsigned int colorg;
    unsigned int colorb;
    int number;
    
    if(i->objtrans != NULL){
        number =  i->GetValue("number").toInt();
        if(number >= 0 && number <=7){
            i->light=ssgGetLight(number);   // ? the lamps are Global ????
            strncpy(mybuff,i->GetValue("color_amb").toAscii(),8);
            sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
            i->light->setColour(GL_AMBIENT,(float)colorr/255,(float)colorg/255,(float)colorb/255);
            strncpy(mybuff,i->GetValue("color_dif").toAscii(),8);
            sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
            i->light->setColour(GL_DIFFUSE,(float)colorr/255,(float)colorg/255,(float)colorb/255);
            strncpy(mybuff,i->GetValue("color_spe").toAscii(),8);
            sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
            i->light->setColour(GL_SPECULAR,(float)colorr/255,(float)colorg/255,(float)colorb/255);
            i->light->setPosition(i->GetValue("x").toFloat(),i->GetValue("y").toFloat(),i->GetValue("z").toFloat());
            i->light->setSpotDirection(i->GetValue("sx").toFloat(),i->GetValue("sy").toFloat(),i->GetValue("sz").toFloat());
            i->light->setSpotDiffusion(i->GetValue("sdexpo").toFloat(),i->GetValue("sdcut").toFloat());

            if(i->GetValue("on").toInt()==0)
              i->light->off();
            else
              i->light->on();

            if(i->GetValue("spotlight").toInt()==0)
              i->light->setSpotlight(0);
            else
              i->light->setSpotlight(1);

            if(i->GetValue("headlight").toInt()==0)
              i->light->setHeadlight(0);
            else
              i->light->setHeadlight(1);

            setFocusDefault(i);
       }
    } else {
        globj=NULL;
    }
}

void Glcontrol::setFocusFog(FolderListItem * i)
{
    char mybuff[256];
    unsigned int colorr;
    unsigned int colorg;
    unsigned int colorb;

      if(i->GetValue("on").toInt() == 0){
        i->fog->off();
      } else {
        i->fog->on();
      }

      strncpy(mybuff,i->GetValue("color").toAscii(),8);
      sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
      sgSetVec4 ( i->fog->skyfogcol, 0.2, (float)colorr/255, (float)colorg/255,(float)colorb/255 ) ;

      i->fog->fogdensity=i->GetValue("density").toFloat();
      i->fog->fogstart=i->GetValue("start").toFloat();
      i->fog->fogend=i->GetValue("end").toFloat();

      if(i->GetValue("linear").toInt() == 1){
        i->fog->fogmode=0;
      }
      if(i->GetValue("exp").toInt() == 1){
        i->fog->fogmode=1;
      }
      if(i->GetValue("exp2").toInt() == 1){
        i->fog->fogmode=2;
      }
      if(i->GetValue("dontcare").toInt() == 1){
        i->fog->foghint=0;
      }
      if(i->GetValue("fastest").toInt() == 1){
        i->fog->foghint=1;
      }
      if(i->GetValue("nicest").toInt() == 1){
        i->fog->foghint=2;
      }
      globj=NULL;
}

void Glcontrol::setFocusFire(FolderListItem * i)
{
    char mybuff[256];
    unsigned int colorr;
    unsigned int colorg;
    unsigned int colorb;
    sgVec4  firecol;
    
    if(i->fire != NULL){
      i->fire->setUpwardSpeed(i->GetValue("speed").toFloat());
      i->fire->setHeight(i->GetValue("height").toFloat());
//    i->fire->setRadius(i->GetValue("radius").toFloat());

      strncpy(mybuff,i->GetValue("hotcolor").toAscii(),8);
      sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
      sgSetVec4 ( firecol, (float)colorr/255,(float)colorg/255,(float)colorb/255, 1.0f ) ;
      i->fire->setHotColour(firecol);
      setFocusDefault(i);
    } else {
          qWarning(  "setFocusFire No Fire Object " );
    }
}

void  Glcontrol::setFocusSky(FolderListItem * i)
{
  ssgaCloudLayer     *cloud = NULL ;

  if(i->sky != NULL){
    // sun
    i->sky->getBody(0)->setRightAscension(i->GetValue("sunrotv").toFloat()*SGD_DEGREES_TO_RADIANS);
    i->sky->getBody(0)->setDeclination(i->GetValue("sunroth").toFloat()*SGD_DEGREES_TO_RADIANS);
    // moon
    i->sky->getBody(1)->setRightAscension(i->GetValue("moonrotv").toFloat()*SGD_DEGREES_TO_RADIANS);
    i->sky->getBody(1)->setDeclination(i->GetValue("moonroth").toFloat()*SGD_DEGREES_TO_RADIANS);

    cloud = i->sky->getCloud(0);
    if(i->GetValue("cl1on").toInt() == 0){
        cloud -> disable();
    } else {
        cloud -> enable();
    }
    cloud -> setElevation ( i->GetValue("cl1h").toFloat() ) ;
    cloud -> setSpeed ( i->GetValue("cl1s").toFloat() ) ;
    cloud -> setDirection ( i->GetValue("cl1d").toFloat() ) ;

    cloud = i->sky->getCloud(1);
    if(i->GetValue("cl2on").toInt() == 0){
        cloud -> disable();
    } else {
        cloud -> enable();
    }
    cloud -> setElevation ( i->GetValue("cl2h").toFloat() ) ;
    cloud -> setSpeed ( i->GetValue("cl2s").toFloat() ) ;
    cloud -> setDirection ( i->GetValue("cl2d").toFloat() ) ;

    cloud = i->sky->getCloud(2);
    if(i->GetValue("cl3on").toInt() == 0){
        cloud -> disable();
    } else {
        cloud -> enable();
    }
    cloud -> setElevation ( i->GetValue("cl3h").toFloat() ) ;
    cloud -> setSpeed ( i->GetValue("cl3s").toFloat() ) ;
    cloud -> setDirection ( i->GetValue("cl3d").toFloat() ) ;
  } else {
          qWarning(  "setFocusSky No Sky Object " );
  }
}

void Glcontrol::setFocusSound(FolderListItem * i)
{
     sgCoord    boxpos;

  if(i->sound != NULL){
     if(i->GetValue("relativexyz").toInt() == 1){
       i->sound->Relative(1);
     } else {
       i->sound->Relative(0);
     }
     i->sound->adjustVolume(i->GetValue("volume").toFloat());

     if(i->sound->boxobjtrans != NULL){
        sgSetCoord ( & boxpos,
                     i->GetValue("x").toFloat(),
                     i->GetValue("y").toFloat(),
                     i->GetValue("z").toFloat(),
                     0,
                     0,
                     0 ) ;
        if(i->GetValue("viewbox").toInt() == 0){
            i->sound->boxobjtrans -> setTransform ( & boxpos,0.01f,0.01f,0.01f) ;
        } else {
            i->sound->boxobjtrans -> setTransform ( & boxpos,1.0f,1.0f,1.0f) ;
        }
     }
     i->sound->setPosition(i->GetValue("x").toFloat(),
                           i->GetValue("y").toFloat(),
                           i->GetValue("z").toFloat());

     if(i->GetValue("loop").toInt() == 1){
       i->sound->Loop(1);
     } else {
       i->sound->Loop(0);
     }

     if(i->GetValue("play").toInt() == 1){
       i->sound->slot_play();
     }
     if(i->GetValue("play").toInt() == 0){
       i->sound->slot_stop();
     }
  } else {
          qWarning(  "setFocusSound No Sound Object " );
  }
}

void Glcontrol::setFocusMedia(FolderListItem * i)
{
     sgCoord    boxpos;

  if(i->media != NULL){
     i->media->adjustVolume(i->GetValue("volume").toFloat());

     if(i->media->boxobjtrans != NULL){
        sgSetCoord ( & boxpos,
                     i->GetValue("x").toFloat(),
                     i->GetValue("y").toFloat(),
                     i->GetValue("z").toFloat(),
                     0,
                     0,
                     0 ) ;
        if(i->GetValue("viewbox").toInt() == 0){
            i->media->boxobjtrans -> setTransform ( & boxpos,0.01f,0.01f,0.01f) ;
        } else {
            i->media->boxobjtrans -> setTransform ( & boxpos,1.0f,1.0f,1.0f) ;
        }
     }
     i->media->setPosition(i->GetValue("x").toFloat(),
                           i->GetValue("y").toFloat(),
                           i->GetValue("z").toFloat());

     if(i->GetValue("loop").toInt() == 1){
       i->media->Loop(1);
     } else {
       i->media->Loop(0);
     }

     if(i->GetValue("play").toInt() == 1){
       i->media->slot_play();
     }
     if(i->GetValue("play").toInt() == 0){
       i->media->slot_stop();
     }
     setFocusDefault(i);
  } else {
          qWarning(  "setFocusMedia No Sound Object " );
  }
}

void  Glcontrol::setFocusScriptprg(FolderListItem * i)
{ 
  if(i->scriptprog!= NULL){
    if(i->GetValue("on").toInt() == 1){
        i->scriptprog->TurnOn();
    } else {
        i->scriptprog->TurnOff();
    }
  } else {
          qWarning(  "setFocusScriptprg No Scripting Object " );
  }
}
/*
void  Glcontrol::setFocusShader(FolderListItem * i)
{
  if(i->gshader != NULL){
    if(i->GetValue("on").toInt() == 1){
        i->gshader->TurnOn();
    } else {
        i->gshader->TurnOff();
    }
  } else {
          qWarning(  "setFocusShader No Shader Object " );
  }
}
*/
void Glcontrol::setFocusPartSys(FolderListItem * i)
{
    if(i->partsys != NULL){
        setFocusDefault(i);
    } else {
        qWarning(  "setFocusFire No Fire Object " );
    }
}

void  Glcontrol::setFocusCursor(FolderListItem * i)
{
  if(i->cursor != NULL){
    if(i->GetValue("on").toInt() == 1){
        i->cursor->TurnOn();
    } else {
        i->cursor->TurnOff();
    }
    i->cursor->x = i->GetValue("mx").toInt();
    i->cursor->y = i->GetValue("my").toInt();
  } else {
          qWarning(  "setFocusCursor No Cursor Object " );
  }
}

void Glcontrol::setFocusGUIText(FolderListItem * i)
{
   char mybuff[256];
   unsigned int colorr;
   unsigned int colorg;
   unsigned int colorb;

   int w = puGetWindowWidth  () ;
   int h = puGetWindowHeight () ;

  if(i->guitext != NULL){
    if(i->GetValue("on").toInt() == 1){
        i->guitext->reveal();
    } else {
        i->guitext->hide();
    }
    i->guitext->setText ( i->GetValue("label").toAscii() ) ;

    strncpy(mybuff,i->GetValue("colorlabel").toAscii(),8);
    sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
    i->guitext->setColour( PUCOL_LABEL, (float)colorr/255, (float)colorg/255,(float)colorb/255, 1.0f ) ;

    switch (i->GetValue("place").toInt())
    {
      case 0:
      // upperleft
      i->guitext->setPosition ( i->GetValue("x").toInt(), h - i->GetValue("y").toInt() ) ;
      break;

      case 1:
      // upperright
      i->guitext->setPosition ( w - i->GetValue("x").toInt() , h - i->GetValue("y").toInt() ) ;
      break;

      case 2:
      // lowerright
      i->guitext->setPosition ( w - i->GetValue("x").toInt() ,  i->GetValue("y").toInt() ) ;
      break;

      case 3:
      // lowerleft
      i->guitext->setPosition ( i->GetValue("x").toInt() , i->GetValue("y").toInt() ) ;
      break;

      case 4:
      // center
      i->guitext->setPosition ( (w/2) + i->GetValue("x").toInt() , (h/2) + i->GetValue("y").toInt() ) ;
      break;
    }
  } else {
          qWarning(  "setFocusGUIText No GUIText Object " );
  }
}

void Glcontrol::setFocusGUIButton(FolderListItem * i)
{
   char mybuff[256];
   unsigned int colorr;
   unsigned int colorg;
   unsigned int colorb;

   int w = puGetWindowWidth  () ;
   int h = puGetWindowHeight () ;

  if(i->guibutton != NULL){
    if(i->GetValue("on").toInt() == 1){
        i->guibutton->reveal();
    } else {
        i->guibutton->hide();
    }

    i->guibutton->setText ( i->GetValue("legend").toAscii() ) ;
    i->guibutton->setSize ( i->GetValue("maxx").toInt(), i->GetValue("maxy").toInt() ) ;

    strncpy(mybuff,i->GetValue("colorlabel").toAscii(),8);
    sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
    i->guibutton->setColour( PUCOL_LEGEND, (float)colorr/255, (float)colorg/255,(float)colorb/255, 1.0f ) ;

    switch (i->GetValue("place").toInt())
    {
      case 0:
      // upperleft
      i->guibutton->setPosition ( i->GetValue("x").toInt(), h - i->GetValue("y").toInt() ) ;
      break;

      case 1:
      // upperright
      i->guibutton->setPosition ( w - i->GetValue("x").toInt() , h - i->GetValue("y").toInt() ) ;
      break;

      case 2:
      // lowerright
      i->guibutton->setPosition ( w - i->GetValue("x").toInt() ,  i->GetValue("y").toInt() ) ;
      break;

      case 3:
      // lowerleft
      i->guibutton->setPosition ( i->GetValue("x").toInt() , i->GetValue("y").toInt() ) ;
      break;

      case 4:
      // center
      i->guibutton->setPosition ( (w/2) - i->GetValue("x").toInt() , (h/2) + i->GetValue("y").toInt() ) ;
      break;
    }
  } else {
          qWarning(  "setFocusGUIButton No GUIButton Object " );
  }
}

void Glcontrol::setFocusGUIOSButton(FolderListItem * i)
{
   char mybuff[256];
   unsigned int colorr;
   unsigned int colorg;
   unsigned int colorb;

  int w = puGetWindowWidth  () ;
  int h = puGetWindowHeight () ;

  if(i->guiosbutton != NULL){
    if(i->GetValue("on").toInt() == 1){
        i->guiosbutton->reveal();
    } else {
        i->guiosbutton->hide();
    }

    i->guiosbutton->setText ( i->GetValue("legend").toAscii() ) ;
    i->guiosbutton->setSize ( i->GetValue("maxx").toInt(), i->GetValue("maxy").toInt() ) ;

    strncpy(mybuff,i->GetValue("colorlabel").toAscii(),8);
    sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
    i->guiosbutton->setColour( PUCOL_LEGEND, (float)colorr/255, (float)colorg/255,(float)colorb/255, 1.0f ) ;

    switch (i->GetValue("place").toInt())
    {
      case 0:
      // upperleft
      i->guiosbutton->setPosition ( i->GetValue("x").toInt(), h - i->GetValue("y").toInt() ) ;
      break;

      case 1:
      // upperright
      i->guiosbutton->setPosition ( w - i->GetValue("x").toInt() , h - i->GetValue("y").toInt() ) ;
      break;

      case 2:
      // lowerright
      i->guiosbutton->setPosition ( w - i->GetValue("x").toInt() ,  i->GetValue("y").toInt() ) ;
      break;

      case 3:
      // lowerleft
      i->guiosbutton->setPosition ( i->GetValue("x").toInt() , i->GetValue("y").toInt() ) ;
      break;

      case 4:
      // center
      i->guiosbutton->setPosition ( (w/2) - i->GetValue("x").toInt() , (h/2) + i->GetValue("y").toInt() ) ;
      break;
    }
  } else {
          qWarning(  "setFocusGUIOSButton No GUIOSButton Object " );
  }
}

void Glcontrol::setFocusGUIInput(FolderListItem * i)
{
   char mybuff[256];
   unsigned int colorr;
   unsigned int colorg;
   unsigned int colorb;

   int w = puGetWindowWidth  () ;
   int h = puGetWindowHeight () ;

  if(i->guiinput != NULL){
    if(i->GetValue("on").toInt() == 1){
        i->guiinput->reveal();
    } else {
        i->guiinput->hide();
    }

    i->guiinput->setText ( i->GetValue("label").toAscii() ) ;
    i->guiinput->setSize ( i->GetValue("maxx").toInt(), i->GetValue("maxy").toInt() ) ;

    strncpy(mybuff,i->GetValue("colorlabel").toAscii(),8);
    sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
    i->guiinput->setColour( PUCOL_LABEL, (float)colorr/255, (float)colorg/255,(float)colorb/255, 1.0f ) ;

    switch (i->GetValue("place").toInt())
    {
      case 0:
      // upperleft
      i->guiinput->setPosition ( i->GetValue("x").toInt(), h - i->GetValue("y").toInt() ) ;
      break;

      case 1:
      // upperright
      i->guiinput->setPosition ( w - i->GetValue("x").toInt() , h - i->GetValue("y").toInt() ) ;
      break;

      case 2:
      // lowerright
      i->guiinput->setPosition ( w - i->GetValue("x").toInt() ,  i->GetValue("y").toInt() ) ;
      break;

      case 3:
      // lowerleft
      i->guiinput->setPosition ( i->GetValue("x").toInt() , i->GetValue("y").toInt() ) ;
      break;

      case 4:
      // center
      i->guiinput->setPosition ( (w/2) - i->GetValue("x").toInt() , (h/2) + i->GetValue("y").toInt() ) ;
      break;
    }
  } else {
          qWarning(  "setFocusGUIInput No GUIInput Object " );
  }
}

void Glcontrol::setFocusCamera(FolderListItem * i)
{
  if(i->usercam != NULL){
    i->usercam->bind( i->GetValue("bind").toInt() );

    i->usercam->camradius = i->GetValue("camradius").toFloat();
    i->usercam->camrotw = i->GetValue("camrotw").toFloat();
    i->usercam->camhight = i->GetValue("camhight").toFloat();

    // cameratyp
    if(i->GetValue("camfix").toInt() == 1){
        i->usercam->camtyp = 1 ;
    }
    if(i->GetValue("cam2d").toInt() == 1){
        i->usercam->camtyp = 2 ;
    }
    if(i->GetValue("camego").toInt() == 1){
        i->usercam->camtyp = 3 ;
    }
    ssgSetFOV     ( i->GetValue("fovw").toFloat(), i->GetValue("fovh").toFloat() ) ;
    ssgSetNearFar ( i->GetValue("near").toFloat(), i->GetValue("far").toFloat() ) ;

    setFocusDefault(i);
  } else {
          qWarning(  "setFocusCamera No usercamera Object " );
  }
}

void Glcontrol::setFocusWaveSys(FolderListItem * i)
{
  if(i->wavesys != NULL){
    if(i->GetValue("envmap").toInt() == 1){
      i->wavesys->setKidCallback   ( SSG_CALLBACK_PREDRAW , enableTexGen ) ;
      i->wavesys->setKidCallback   ( SSG_CALLBACK_POSTDRAW, disableTexGen ) ;
      i->wavesys->regenerate       () ;
    } else {
      i->wavesys->setKidCallback   ( SSG_CALLBACK_PREDRAW , NULL ) ;
      i->wavesys->setKidCallback   ( SSG_CALLBACK_POSTDRAW, NULL ) ;
      i->wavesys->regenerate       () ;
    }

    i->wavesys->setSize( i->GetValue("size").toFloat() );
    i->wavesys->setTexScale( i->GetValue("texsx").toFloat(), i->GetValue("texsy").toFloat());
    i->wavesys->setWindSpeed( MAX_WSPEED - i->GetValue("wspeed").toFloat());

    setFocusDefault(i);
  } else {
          qWarning(  "setFocusWaveSys No Wavesys Object " );
  }
}

void  Glcontrol::viewCamera(FolderListItem * i)
{
  sgCoord campos ;

  if(i != NULL && i->usercam != NULL){
      i->usercam->view();
  } else {
      qWarning(  "viewCamera No usercamera Object " );
      ssgSetFOV     ( 60.0f, 0.0f ) ;
      ssgSetNearFar ( 0.01f, 100000.0f ) ;
      sgSetCoord ( & campos, 0.0f, -5.0f*scale, 3.0f, 0.0f, 0.0f, 0.0f ) ;
      my_context -> setCamera ( & campos );
      resizeGL( g_window_w, g_window_h );
  }
}

void  Glcontrol::switchCamera(FolderListItem * i)
{
    usercam = i->usercam;
    viewCamera(i);
}

void  Glcontrol::makemyCurrent()
{
    my_context->makeCurrent();
}

void Glcontrol::changeAttribute (FolderListItem * i, char *attr, char *value)
{
    i->SetValue(attr,value);
    if(i->text(1) == "OBJECT"){
       setFocusObject(i);
    }
    if(i->text(1) == "BARRIER"){
       setFocusBarrier(i);
    }
    if(i->text(1) == "BODY"){
       setFocusBody(i);
    }
    if(i->text(1) == "FOG"){
       setFocusFog(i);
    }
    if(i->text(1) == "GUI-BUTTON"){
       setFocusGUIButton(i);
    }
    if(i->text(1) == "GUI-OSBUTTON"){
       setFocusGUIOSButton(i);
    }
    if(i->text(1) == "GUI-INPUT"){
       setFocusGUIInput(i);
    }
    if(i->text(1) == "GUI-TXT"){
       setFocusGUIText(i);
    }
    if(i->text(1) == "LAMP"){
       setFocusLamp(i);
    }
    if(i->text(1) == "PLAYER"){
       setFocusPlayer(i);
    }
    if(i->text(1) == "SCENE"){
       setFocusScene(i);
    }
    if(i->text(1) == "SKY"){
       setFocusSky(i);
    }
    if(i->text(1) == "SOUND"){
       setFocusSound(i);
    }
    if(i->text(1) == "WAVESYS"){
       setFocusWaveSys(i);
    }
    if(i->text(1) == "CURSOR"){
       setFocusCursor(i);
    }
}

void  Glcontrol::switchScene(FolderListItem * i)
{
//  int a;
  int tmpplaymode;

  StopSound();
  tmpplaymode=g_playmode;
  g_playmode = 0;
  gtimer->stop();
  while(gtimer->isActive()) ;
         
  // otherwise switch with wavesys will crash but why ??
  ulMilliSecondSleep ( 100 ) ;    
  if(lensflare_obj != NULL){
//      delete lensflare_obj;
      lensflare_obj = NULL;
  }
  i->gl=this;
  DeleteScene();
//  init_graphics();
  scene = new ssgRoot ;
  globj=NULL;
  QcakeScriptApi *Script=QcakeScriptApi::theInstance();
  Script->Init (i);
  if(lensflare_obj == NULL){
//     lensflare_obj =  new ssgaLensFlare ();
  }
  viewCamera(NULL);
  initFolderListItem(i,g_prjpath);
  setFocusScene(i);
  sceneitem= i;
  if(tmpplaymode){
     compile();
  }
  gtimer->start(TIMER_INTERVAL);
  g_playmode=tmpplaymode;
  qWarning(  "switch Scene OK " );
}

void  Glcontrol::StopSound()
{
  emit msg_sound_stop();
}

int  Glcontrol::getPoint(int x, int y, sgVec3 *poi)
{
    sgVec3 old_poi;
    sgVec3 my_poi;
    int valid = FALSE;
    if(my_context){
      valid=my_context->getPOI(&old_poi);
      my_context->setPOI(x,y);
      my_context->getPOI(&my_poi);
      sgCopyVec3( *poi, my_poi);
      my_context->setPOI(old_poi);
    }
/*  
      qWarning("QC: mx:%i my:%i",g_mouse_x,g_mouse_y);
      qWarning("QC: x:%f y:%f z:%f",g_poi[0],g_poi[1],g_poi[2]);
      qWarning("getPoint: mx:%i my:%i",x,y);
      qWarning("getPoint: x:%f y:%f z:%f",my_poi[0],my_poi[1],my_poi[2]);
*/
    return valid;
}

int  Glcontrol::compile()
{
  emit msg_compile();
  return 0;
}

void Glcontrol::keyReleaseEvent ( QKeyEvent * e )
{
    if (!e->isAutoRepeat()) {
        if(g_playmode){
//          QString s = QString("Released: %1 %2").arg(e->key());
//          qDebug() << s;
          g_keyset.remove(e->key());
        }
    }
}
