/***************************************************************************
                          listviews.hpp  -  description
                             -------------------
    begin                : Mon M�r 3 2003
    copyright            : (C) 2003 by Harald Krippel
    email                : harald@hte-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LISTVIEWS_H
#define LISTVIEWS_H

/**
  *@author Harald Krippel
  */

#include <QtGui>
#include <plib/ssg.h>

class ssgLight;
class ssgTransform;
class qcFire;
class qcWaveSystem;
class Player;
class Barrier;
class Body;
class scriptPrg;
class cursor3d;
class qcSound;
class qcSkySystem;
class qcPartsys;
class qcFog;
class Glcontrol;
class GUIText;
class GUIButton;
class GUIOSButton;
class GUIInput;
class TriBarrier;
class usercamera;
class CQcakeDlg;

class FolderListItem : public QTreeWidgetItem
{

public:
    FolderListItem( QTreeWidget * parent );
    FolderListItem( FolderListItem * parent );
    FolderListItem( QTreeWidget * parent, FolderListItem * after );
    FolderListItem( FolderListItem * parent, FolderListItem * after );
    void cleanup();
    ~FolderListItem();
    FolderListItem * search_id(FolderListItem * i,const int id);
    void scene_cleanup(FolderListItem * i);
    void scene_RedrawGUI(FolderListItem * i);
    QString GetValue(const QString & item); 
    QString GetValue(const QString & item,FolderListItem *i);
    void SetValue(const QString & item, const QString & value);
    void SetValue(const QString & item, const QString & value, FolderListItem *i);
    void addObject(const QString & type);
    int addTmpObject(FolderListItem * origitem, sgCoord  pos, int id);
    void addCoord(FolderListItem *thisItem);
    void viewCamera();
    void updategl();
    void updateDialog();

    Glcontrol       *gl;
    ssgLight        *light;
    ssgTransform    *objtrans;
    qcFire          *fire;
    qcWaveSystem    *wavesys;
    qcSkySystem     *sky;
    qcPartsys       *partsys;
    qcFog           *fog;
    CQcakeDlg       *dialog;
    Player          *player;
    Barrier         *barrier;
    Body            *body;
    scriptPrg      *scriptprog;
    GUIText         *guitext;
    GUIButton       *guibutton;
    GUIOSButton     *guiosbutton;
    GUIInput        *guiinput;
    TriBarrier      *tribarrier;
    usercamera      *usercam;
    cursor3d        *cursor;
    qcSound        *sound;
    qcSound        *media;
    int   groundcollision;
    int   collision;

private:
    void init();

protected:

    
protected slots:

};

#endif
