//
// C++ Implementation: python_prg
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "python_prg.hpp"
#include <main.h>
#include "scripting.hpp"
#include "scriptprg.hpp"
#include "messages.hpp"

#include <Python.h>

//------------------------------------------------------------------------------
// Make Python aware of our special C++ QCake API functions
//------------------------------------------------------------------------------

PyObject* py_debug( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    char * sValue=0;
    QString qmsg;

    if( PyArg_ParseTuple( args, "s", &sValue )){
        QTextStream(&qmsg) << sValue;
        ScriptApi->print(qmsg);
    }else{
        QString pyerr("pyError: Parameter must be a single string!\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_getPositionX( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    int hh=0;

    if( PyArg_ParseTuple( args, "i", &hh )){
        return Py_BuildValue( "f", ScriptApi->getPositionX(hh) );
    }else{
        QString pyerr("pyError: getPositionX: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_getPositionY( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    int hh=0;

    if( PyArg_ParseTuple( args, "i", &hh )){
        return Py_BuildValue( "f", ScriptApi->getPositionY(hh) );
    }else{
        QString pyerr("pyError: getPositionY: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_getPositionZ( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);
    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    int hh=0;

    if( PyArg_ParseTuple( args, "i", &hh )){
        return Py_BuildValue( "f", ScriptApi->getPositionZ(hh) );
    }else{
        QString pyerr("pyError: getPositionZ: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_getPositionH( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    int hh=0;

    if( PyArg_ParseTuple( args, "i", &hh )){
        return Py_BuildValue( "f", ScriptApi->getPositionH(hh) );
    }else{
        QString pyerr("pyError: getPositionH: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_getPositionP( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);
    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    int hh=0;

    if( PyArg_ParseTuple( args, "i", &hh )){
        return Py_BuildValue( "f", ScriptApi->getPositionP(hh) );
    }else{
        QString pyerr("pyError: getPositionP: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_getPositionR( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    int hh=0;

    if( PyArg_ParseTuple( args, "i", &hh )){
        return Py_BuildValue( "f", ScriptApi->getPositionR(hh));
    }else{
        QString pyerr("pyError: getPositionR: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_addRelTorque( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // hh,velx,vely,velz
    int hh= 0;
    float velx= 0;
    float vely= 0;
    float velz= 0;

    if( PyArg_ParseTuple( args, "ifff", &hh, &velx, &vely, &velz)){
        ScriptApi->addRelTorque ( hh,velx,vely,velz );
    }else{
        QString pyerr("pyError: addRelTorque: Parameter must be a int, float, float, float !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_setAngularVel( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // hh,velx,vely,velz
    int hh= 0;
    float velx= 0;
    float vely= 0;
    float velz= 0;

    if( PyArg_ParseTuple( args, "ifff", &hh, &velx, &vely, &velz)){
        ScriptApi->setAngularVel ( hh,velx,vely,velz );
    }else{
        QString pyerr("pyError: setAngularVel: Parameter must be a int, float, float, float !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_addRelForce( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // hh,velx,vely,velz
    int hh= 0;
    float velx= 0;
    float vely= 0;
    float velz= 0;

    if( PyArg_ParseTuple( args, "ifff", &hh, &velx, &vely, &velz)){
        ScriptApi->addRelForce ( hh,velx,vely,velz );
    }else{
        QString pyerr("pyError: addRelForce: Parameter must be a int, float, float, float !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_setSequence( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // hh,sequenz,mode
    int hh= 0;
    int sequence= 0;
    int mode= 0;

    if( PyArg_ParseTuple( args, "iii", &hh, &sequence, &mode)){
        ScriptApi->setSequence ( hh,sequence,mode );
    }else{
        QString pyerr("pyError: setSequence: Parameter must be a int, int, int!\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_setLinVel( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();

    // hh,velx,vely,velz
    int hh= 0;
    float velx= 0;
    float vely= 0;
    float velz= 0;

    if( PyArg_ParseTuple( args, "ifff", &hh, &velx, &vely, &velz)){
        ScriptApi->setLinVel ( hh,velx,vely,velz );
    }else{
        QString pyerr("setLinVel: Parameter must be a int, float, float, float !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_setRotation( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();

    // hh,h,p,r
    int hh= 0;
    float h= 0;
    float p= 0;
    float r= 0;

    if( PyArg_ParseTuple( args, "ifff", &hh, &h, &p, &r)){
        ScriptApi->setRotation ( hh,h,p,r );
    }else{
        QString pyerr("pyError: setRotation: Parameter must be a int, float, float, float !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_Rotation( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();

    // hh,h,p,r
    int hh= 0;
    float h= 0;
    float p= 0;
    float r= 0;

    if( PyArg_ParseTuple( args, "ifff", &hh, &h, &p, &r)){
        ScriptApi->rotation ( hh,h,p,r );
    }else{
        QString pyerr("pyError: rotation: Parameter must be a int, float, float, float !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_setPosition( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // hh,x,y,z,h,p,r
    int hh= 0;
    float x= 0;
    float y= 0;
    float z= 0;
    float h= 0;
    float p= 0;
    float r= 0;

    if( PyArg_ParseTuple( args, "iffffff", &hh, &x, &y, &z, &h, &p, &r)){
        ScriptApi->setPosition ( hh,x,y,z,h,p,r );
    }else{
        QString pyerr("pyError: setPosition: Parameter must be a int, float, float, float, float, float, float !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_getRef( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // hh
    int hh= 0;

    if( PyArg_ParseTuple( args, "i", &hh)){
        return Py_BuildValue( "i", ScriptApi->getRef ( hh ) );
    }else{
        QString pyerr("pyError: getRef: Parameter must ba a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_getJoystick( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // js ax
    int js= 0;
    int ax= 0;

    if( PyArg_ParseTuple( args, "ii", &js, &ax)){
        return Py_BuildValue( "f", ScriptApi->getJoystick ( js,ax ) );
    }else{
        QString pyerr("pyError: getJoystick: Parameter must be a int and a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_getJoyButton( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // js
    int js= 0;

    if( PyArg_ParseTuple( args, "i", &js)){
        return Py_BuildValue( "i", ScriptApi->getJoyButton ( js ) );
    }else{
        QString pyerr("pyError: getJoyButton: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_getMouse( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // m
    int m= 0;

    if( PyArg_ParseTuple( args, "i", &m)){
        return Py_BuildValue( "i", ScriptApi->getMouse ( m ) );
    }else{
        QString pyerr("pyError: getMouse: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_getMouseButton( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // no arguments

    if( PyArg_ParseTuple( args, "")){
        return Py_BuildValue( "i", ScriptApi->getMouseButton () );
    }else{
        QString pyerr("pyError: getMouseButton: no Parameter needs !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_get3DMouse( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // m
    int m= 0;

    if( PyArg_ParseTuple( args, "i", &m)){
        return Py_BuildValue( "f", ScriptApi->get3DMouse ( m ) );
    }else{
        QString pyerr("pyError: get3DMouse: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_getAttribute( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // hh attr
    int     hh= 0;
    char *attr= 0;

    if( PyArg_ParseTuple( args, "is", &hh, &attr)){
        return Py_BuildValue( "s", ScriptApi->getAttribute ( hh, attr ).toAscii().constData() );
    }else{
        QString pyerr("pyError: getAttribute: Parameter must be a int and a string !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_setAttribute( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // hh attr
    int     hh= 0;
    char *attr= 0;
    char *value= 0;

    if( PyArg_ParseTuple( args, "iss", &hh, &attr, &value)){
        ScriptApi->setAttribute ( hh , attr, value);
    }else{
        QString pyerr("pyError: setAttribute: Parameter must be a int and a string and a string!\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_getKey( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // no arguments

    if( PyArg_ParseTuple( args, "")){
        return Py_BuildValue( "i", ScriptApi->getKey () );
    }else{
        QString pyerr("pyError: getKey: no Parameter needs !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_keyPressed( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // m
    int m= 0;

    if( PyArg_ParseTuple( args, "i", &m)){
        return Py_BuildValue( "i", ScriptApi->keyPressed ( m ) );
    }else{
        QString pyerr("pyError: keyPressed: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_switchScene( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // m
    int m= 0;

    if( PyArg_ParseTuple( args, "i", &m)){
        ScriptApi->switchScene ( m );
    }else{
        QString pyerr("pyError: switchScene: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_playSound( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // m
    int m= 0;

    if( PyArg_ParseTuple( args, "i", &m)){
        ScriptApi->playSound ( m );
    }else{
        QString pyerr("pyError: playSound: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_stopSound( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // m
    int m= 0;

    if( PyArg_ParseTuple( args, "i", &m)){
        ScriptApi->stopSound ( m );
    }else{
        QString pyerr("pyError: stopSound: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_switchCamera( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // m
    int m= 0;

    if( PyArg_ParseTuple( args, "i", &m)){
        ScriptApi->switchCamera ( m );
    }else{
        QString pyerr("pyError: switchCamera: Parameter must be a int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_astarFindPath( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // pl sx sy tx ty
    int  pl=  0;
    int  sx=  0;
    int  sy=  0;
    int  tx=  0;
    int  ty=  0;

    if( PyArg_ParseTuple( args, "iiiii", &pl, &sx, &sy, &tx, &ty)){
        return Py_BuildValue( "i", ScriptApi->astarFindPath ( pl,sx,sy,tx,ty) );
    }else{
        QString pyerr("pyError: astarFindPath: Parameter must be a int, int, int, int, int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_astarReadPathX( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // pl sx
    int  pl=  0;
    int  sx=  0;

    if( PyArg_ParseTuple( args, "ii", &pl, &sx)){
        return Py_BuildValue( "i", ScriptApi->astarReadPathX (pl,sx) );
    }else{
        QString pyerr("pyError: astarReadPathX: Parameter must be a int, int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_astarReadPathY( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // pl sx
    int  pl=  0;
    int  sy=  0;

    if( PyArg_ParseTuple( args, "ii", &pl, &sy)){
        return Py_BuildValue( "i", ScriptApi->astarReadPathY (pl,sy) );
    }else{
        QString pyerr("pyError: astarReadPathY: Parameter must be a int, int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_astarReadMap( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // file
    char *file=  0;

    if( PyArg_ParseTuple( args, "s", &file)){
        return Py_BuildValue( "i", ScriptApi->astarReadMap (file) );
    }else{
        QString pyerr("pyError: astarReadMap: Parameter must be a string !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_astarReadMapValue( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // x y
    int x=  0;
    int y=  0;

    if( PyArg_ParseTuple( args, "ii", &x, &y)){
        return Py_BuildValue( "i", ScriptApi->astarReadMapValue (x,y) );
    }else{
        QString pyerr("pyError: astarReadMap: Parameter must be a int, int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_astarInit( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // width height size people
    int width     =  0;
    int height    =  0;
    int size      =  0;
    int people    =  0;

    if( PyArg_ParseTuple( args, "iiii", &width, &height, &size, &people)){
        return Py_BuildValue( "i", ScriptApi->astarInit (width, height, size, people) );
    }else{
        QString pyerr("pyError: astarInit: Parameter must be a int int int int !\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

PyObject* py_tmpobjInit( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    QcakeScriptApi *ScriptApi=QcakeScriptApi::theInstance();
    // ref x y z h p r id
    int ref    =  0;
    float x    =  0;
    float y    =  0;
    float z    =  0;
    float h    =  0;
    float p    =  0;
    float r    =  0;
    int  id    =  0;

    if( PyArg_ParseTuple( args, "iffffffi", &ref, &x, &y, &z, &h, &p, &r, &id)){
        return Py_BuildValue( "i", ScriptApi->tmpobjInit (ref,x,y,z,h,p,r,id) );
    }else{
        QString pyerr("pyError: tmpobjInit: Parameter must be a int float float float float float float int!\n");
        ErrorMsg errormsg(pyerr);
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

//------------------------------------------------------------------------------
// Make Python aware of our special C++ functions above.
//------------------------------------------------------------------------------

PyMethodDef g_methodDefinitions[] =
{
    { "debug", py_debug, METH_VARARGS, "write msg to debug window" },
    { "setCallback", python_prg::setCallback, METH_VARARGS, "set the callback function" },
    { "getPositionX", py_getPositionX, METH_VARARGS, "get the x positon" },
    { "getPositionY", py_getPositionY, METH_VARARGS, "get the y positon" },
    { "getPositionZ", py_getPositionZ, METH_VARARGS, "get the z positon" },
    { "getPositionH", py_getPositionH, METH_VARARGS, "get the H rotation" },
    { "getPositionP", py_getPositionP, METH_VARARGS, "get the P rotation" },
    { "getPositionR", py_getPositionR, METH_VARARGS, "get the R rotation" },
    { "addRelTorque", py_addRelTorque, METH_VARARGS, "add relative Torque" },
    { "setAngularVel", py_setAngularVel, METH_VARARGS, "set Angular Velocity" },
    { "addRelForce", py_addRelForce, METH_VARARGS, "add relativ Force" },
    { "setSequence", py_setSequence, METH_VARARGS, "set md2 Sequence" },
    { "setLinVel", py_setLinVel, METH_VARARGS, "set linear Velocity" },
    { "setRotation", py_setRotation, METH_VARARGS, "set Rotation" },
    { "Rotate", py_Rotation, METH_VARARGS, "relativ Rotate h,p,r" },
    { "setPosition", py_setPosition, METH_VARARGS, "set Position" },
    { "getRef", py_getRef, METH_VARARGS, "get a Reference" },
    { "getJoystick", py_getJoystick, METH_VARARGS, "getJoystick" },
    { "getJoyButton", py_getJoyButton, METH_VARARGS, "get Joystick Button" },
    { "getMouse", py_getMouse, METH_VARARGS, "get Mouse Axis" },
    { "getMouseButton", py_getMouseButton, METH_VARARGS, "get Mouse Button" },
    { "get3DMouse", py_get3DMouse, METH_VARARGS, "get 3D Mouse Axis" },
    { "getAttribute", py_getAttribute, METH_VARARGS, "get Attribute" },
    { "setAttribute", py_setAttribute, METH_VARARGS, "set Attribute" },
    { "getKey", py_getKey, METH_VARARGS, "get Key" },
    { "keyPressed", py_keyPressed, METH_VARARGS, "is Key pressed" },
    { "switchScene", py_switchScene, METH_VARARGS, "switch to Scene" },
    { "playSound", py_playSound, METH_VARARGS, "play Sound" },
    { "stopSound", py_stopSound, METH_VARARGS, "stop Sound" },
    { "switchCamera", py_switchCamera, METH_VARARGS, "switch to Camera" },
    { "astarFindPath", py_astarFindPath, METH_VARARGS, "astar Find Path" },
    { "astarReadPathX", py_astarReadPathX, METH_VARARGS, "astar Read PathX" },
    { "astarReadPathY", py_astarReadPathY, METH_VARARGS, "astar Read PathY" },
    { "astarReadMap", py_astarReadMap, METH_VARARGS, "astar Read Map" },
    { "astarReadMapValue", py_astarReadMapValue, METH_VARARGS, "astar Read Map Value" },
    { "astarInit", py_astarInit, METH_VARARGS, "astar Init" },
    { "tmpobjInit", py_tmpobjInit, METH_VARARGS, "temp object Init" },
//    { "setCallback", setCallback, METH_VARARGS, "Sets a call-back function in Python" },
    {NULL, NULL}
};

//-------- PythonEnv Singleton ---

 PythonEnv * PythonEnv::theInstancePtr = 0;
 PyObject *python_prg::update_pythonCallback = 0;

PythonEnv::PythonEnv (QObject *parent): QObject(parent)
{

}

// destructor
PythonEnv::~PythonEnv ()
{
    // Cleanup after Python...
    Py_Finalize();
}

PythonEnv * PythonEnv::theInstance(QObject *parent) {
    if (theInstancePtr == 0) {
        theInstancePtr = new PythonEnv(parent);
        theInstancePtr->Init();
    }
    return theInstancePtr;
}

void PythonEnv::Init ()
{ 
    Py_Initialize();  // ? should this  be done in a singleton obj ??
    // Define our custom module called "QCakeApi"
    PyImport_AddModule( "QCakeApi" );
    Py_InitModule( "QCakeApi", g_methodDefinitions );
}

//---------------------------------

python_prg::python_prg(const QString & program)
 : scriptPrg()
{
    prgname = program;
    update_pythonCallback= NULL;
    // Setup Python to be embedded...
    PythonEnv *mypython=PythonEnv::theInstance();
    // Access the "__main__" module and its name-space dictionary.
    pMainModule     = PyImport_AddModule( "__main__" );
    pMainDictionary = PyModule_GetDict( pMainModule );
}


python_prg::~python_prg()
{

}

int python_prg::compile(void)
{
  return run();
}

int python_prg::run(void)
{
  if(on==1){
    // load the standard python qcake library
    if(runFile(g_prjpath + "/data/python_stdlib.py")){
      return 1;
    }
    if(runFile(prgname)){
      return 1;
    }
  }
  return 0;
}

int python_prg::runFile(const QString &prgfile)
{
  QFile scriptFile(prgfile);
  scriptFile.open(QIODevice::ReadOnly);
  // run the script
  QString srcprg(scriptFile.readAll());
  char *myprg=strdup(srcprg.toAscii().constData());
  PyObject *p   = NULL;
  p=PyRun_String( myprg, Py_file_input,
                      pMainDictionary, pMainDictionary );
  if (p) {

  } else {
    handleError();
    return 1;
  }
  scriptFile.close();
  return 0;
}

void python_prg::update(void)
{
  if(on==1){
    if( update_pythonCallback ){
        int nArg1 = 123;
        PyObject *pArgList = Py_BuildValue( "(i)", nArg1 );
        PyObject *pResult  = PyEval_CallObject( update_pythonCallback, pArgList );
        Py_DECREF( pArgList );
        if( pResult != NULL ){
            Py_DECREF( pResult );
        }
    }
  }
}

PyObject* python_prg::setCallback( PyObject* self, PyObject* args )
{
    Q_UNUSED(self);

    PyObject *temp   = NULL;

    if( PyArg_ParseTuple( args, "O", &temp )){
        if( !PyCallable_Check( temp )){
            QString pyerr("pyError: setCallback: parameter must be callable\n");
            ErrorMsg errormsg(pyerr);
            return Py_BuildValue("");
        }
        Py_XINCREF( temp );                   // Ref the new call-back
        Py_XDECREF( update_pythonCallback );  // Unref the previous call-back
        update_pythonCallback = temp;         // Cache the new call-back
    }
/*
    Py_INCREF( Py_None );
    return Py_None;
*/
    return Py_BuildValue("");
}

bool python_prg::handleError()
{
  bool flag = false;
  if (PyErr_Occurred()) {
    PyErr_Print();
    PyErr_Clear();
    flag = true;
  }
  return flag;
}
