/***************************************************************************
                          qcphonon.cpp  -  description
                             -------------------
    begin                : Fri Sep 05 2008
    copyright            : (C) 2008 by Harald Krippel
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 * todo:                                                                   *
 *       make memberfunctins to get boxobjtrans and set boxobjtrans        *
 *       make memberfunctins to get snd and set snd                        *
 ***************************************************************************/

/**
 * @class qcPhonon
 * @brief The qcPhonon class set and manipulate an Phonon sound Object
 */
#include <QtGui>
#include "qcphonon.hpp"
#include "mediaplayer.hpp"
#include "listviews.hpp"
#include "main.h"

qcPhonon::qcPhonon(FolderListItem * parent)
{
  boxobjtrans = NULL;
  i=parent;
  player = new MediaPlayer("");
  connect(player, SIGNAL(sigFile(const QString &)),this , SLOT(getFile(const QString &)));
  connect(player, SIGNAL(sigUrl(const QString &)),this , SLOT(getUrl(const QString &)));
  connect(player, SIGNAL(sigVolume(int)),this , SLOT(getVolume(int)));
}

/*!
 play the sound
*/
int qcPhonon::Play()
{
    player->show();
    return 0;
}

/*!
 stop the sound
*/
int qcPhonon::Stop()
{
    player->pause();
    return 0;
}

/*!
 set the sound attribute flag loop
*/
void qcPhonon::Loop(int flag)
{
        Q_UNUSED(flag);
	// todo loop sound
}


/*!
 adjust the volume of the sound
*/
void qcPhonon::adjustVolume(float gain)
{
      player->setQCVolume((int) (gain ));
}

/*!
 load the sound file
*/
int qcPhonon::loadFile(const QString &file)
{
   player->setFile(file);
   return 0;
}

int qcPhonon::loadUrl(const QString & tmpurl)
{
   player->setUrl(tmpurl);
   return 0;
}

    
qcPhonon::~qcPhonon()
{
	delete player;
}

void qcPhonon::getVolume(int tmpvolume)
{
   QString strvolum = QString("%1").arg(tmpvolume);
   i->SetValue( "volume", strvolum);
   i->updateDialog();
}

void qcPhonon::getFile(const QString & tmpfile)
{  
   QString copy;

   if(!tmpfile.isEmpty()){
      QFileInfo f(tmpfile);
      QString sname = f.fileName();
      // delete the old sound file in the project folder
      QString oldfile=i->GetValue("file");
      if(!oldfile.isEmpty()){
        copy = "rm \"" + g_prjpath + "data/" + oldfile + "\"" ; 
        qWarning( copy.toAscii() );
        system (copy.toAscii().constData());
      }
      // copy the sound file in the project folder
      copy = "cp \"" + tmpfile + "\" " +  g_prjpath + "data/" ; 
      qWarning( copy.toAscii() );
      system (copy.toAscii().constData());
      i->SetValue("file",sname);
      i->setText( 0, sname);
    }
   i->updategl();
}

void qcPhonon::getUrl(const QString & tmpurl)
{
   i->SetValue( "url", tmpurl);
   i->updategl();
}
