/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include <QApplication>
#include <QResource>
#include <QModelIndex>
#include <QTextCharFormat>
#include <QHostAddress>
#include <QNetworkAddressEntry>

#if defined(Q_OS_WIN)
#  include <QPlastiqueStyle>
#endif

#include "qchat.h"

void myMessageOutput(QtMsgType type, const char *msg)
{
  switch (type)
  {
    case QtDebugMsg:
//       fprintf(stdout, "Debug: %s\n", msg);
      break;

    case QtWarningMsg:
      fprintf(stderr, "Warning: %s\n", msg);
      break;

    case QtCriticalMsg:
      fprintf(stderr, "Critical: %s\n", msg);
      break;

    case QtFatalMsg:
      fprintf(stderr, "Fatal: %s\n", msg);
  }
}

int main(int argc, char *argv[])
{

#if defined(Q_OS_WIN)
  bool custom_style = false;
  for(int i = 0; i < argc; i++)
  {
    if(!strcmp("-style", argv[i]))
    {
      custom_style = true;
      break;
    }
  }
#endif

  qInstallMsgHandler(myMessageOutput);

  QApplication app(argc, argv);

  Q_INIT_RESOURCE(images);

#if defined(Q_OS_WIN)
 if(!custom_style)
    QApplication::setStyle(new QPlastiqueStyle);
#endif

  qRegisterMetaType<unsigned long long>("unsigned long long");
  qRegisterMetaType<QHostAddress>      ("QHostAddress");
  qRegisterMetaType<quint8 >           ("quint8" );
  qRegisterMetaType<quint16>           ("quint16");
  qRegisterMetaType<quint32>           ("quint32");
  qRegisterMetaType<quint64>           ("quint64");
  qRegisterMetaType<quint64>           ("QTextCursor");
  qRegisterMetaType<QModelIndex>       ("QModelIndex");
  qRegisterMetaType<QTextCharFormat>   ("QTextCharFormat");
  qRegisterMetaType<QNetworkAddressEntry>("QNetworkAddressEntry");

  QChat chat;

  chat.start(argc, argv, &app);

  return app.exec();
}
