/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include "picturescrollarea.h"
#include "globals.h"

#include <QLabel>

PictureScrollArea::PictureScrollArea(QWidget *parent)
 : QScrollArea(parent)
{
  setWindowTitle(tr("Full size of picture"));
}
//\*****************************************************************************
void PictureScrollArea::resizeEvent (QResizeEvent * ev)
{
  if(widget())
  {
    if(frameSize().width()  >= widget()->width() && frameSize().height() >= widget()->height())
    {
      setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
      setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    }
    else
    {
      setHorizontalScrollBarPolicy(Qt::ScrollBarAsNeeded);
      setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);
    }
  }

  QScrollArea::resizeEvent(ev);
}
//\*****************************************************************************
void PictureScrollArea::mousePressEvent(QMouseEvent* ev)
{
  if(ev->button() == Qt::LeftButton)
  {
    m_lastX = ev->globalX();
    m_lastY = ev->globalY();
  }

  QScrollArea::mousePressEvent(ev);
}
//\*****************************************************************************
void PictureScrollArea::mouseMoveEvent(QMouseEvent* ev)
{
  int x   = ev->globalX();
  int y   = ev->globalY();
  int ver = m_lastY - y;
  int hor = m_lastX - x;

  m_lastX = x;
  m_lastY = y;

  verticalScrollBar()  ->setValue(ver + verticalScrollBar  ()->value());
  horizontalScrollBar()->setValue(hor + horizontalScrollBar()->value());

  QScrollArea::mouseMoveEvent(ev);
}
//\*****************************************************************************
void PictureScrollArea::mouseDoubleClickEvent(QMouseEvent* ev)
{
  if(windowState() == Qt::WindowFullScreen)
    setWindowState(Qt::WindowNoState);
  else
    setWindowState(Qt::WindowFullScreen);

  QScrollArea::mouseDoubleClickEvent(ev);
}
//\*****************************************************************************
