/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef SINGLEMESSAGEWGT_H
#define SINGLEMESSAGEWGT_H

#include <QDialog>
#include <QPushButton>
#include <QTextEdit>
#include <QWidget>
#include <QHostAddress>
#include <QCloseEvent>

class InputTextWgt;
class ChatTextWgt;
class Message;
/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class SingleMessageWgt : public QDialog
{
  Q_OBJECT
  private:
    bool          m_isIncoming;
    bool          m_quot;

    QHostAddress  m_destAddr;
    QString       m_title;
    QPushButton*  m_sendBtn;
    QPushButton*  m_closeBtn;
    QPushButton*  m_replyBtn;
    QPushButton*  m_replyQuotedBtn;
    ChatTextWgt*  m_messageIn;
    InputTextWgt* m_inputText;

  public:
    SingleMessageWgt(const QString &, const QString &, const QHostAddress &, bool isIncoming_ = false, QWidget *parent = 0);
    SingleMessageWgt(Message*, bool isIncoming_ = false, QWidget *parent = 0);
    ~SingleMessageWgt();

    void init(const QString &, const QString &, const QHostAddress &, bool isIncoming_);

    void retranslate();

  public slots:
    void slot_reply      ();
    void slot_replyQuoted();
    void slot_selfDestroy();
    void slot_sendMessage();

  signals:
    void singleMessage(QString, QHostAddress);

  protected:
    void closeEvent(QCloseEvent* ev){ev->ignore(); slot_selfDestroy();}
};

#endif
