/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "inputrichtextwgt.h"

#include <QToolBar>
#include <QTextList>

#include "colorchooser.h"

InputRichTextWgt::InputRichTextWgt(QWidget *parent)
 : QWidget(parent)
{
  m_inputText = new InputTextWgt(this);
  QGridLayout* grid = new QGridLayout(this);

  grid->addWidget(m_inputText, 0, 0);
  grid->setMargin(0);

  connect(m_inputText, SIGNAL(currentCharFormatChanged(const QTextCharFormat &)),
                 this, SIGNAL(currentCharFormatChanged(const QTextCharFormat &)));
  connect(m_inputText, SIGNAL(wantSend()), this, SIGNAL(wantSend()));
}

InputRichTextWgt::~InputRichTextWgt()
{
  qDebug("[~InputRichTextWgt]");
}

//\*****************************************************************************
void InputRichTextWgt::setBold(bool b)
{
  QTextCharFormat fmt;
  fmt.setFontWeight(b ? QFont::Bold : QFont::Normal);

  mergeFormat(fmt);
}

void InputRichTextWgt::setUnderline(bool b)
{
  QTextCharFormat fmt;
  fmt.setFontUnderline(b);

  mergeFormat(fmt);
}

void InputRichTextWgt::setItalic(bool b)
{
  QTextCharFormat fmt;
  fmt.setFontItalic(b);

  mergeFormat(fmt);
}

void InputRichTextWgt::setColor(const QColor & color)
{
  QTextCharFormat fmt;

  if(!color.isValid())
    return;

  fmt.setForeground(color);

  mergeFormat(fmt);
}

void InputRichTextWgt::mergeFormat(const QTextCharFormat & fmt)
{
  QTextCursor cursor = m_inputText->textCursor();

  if(!cursor.hasSelection())
    cursor.movePosition(cursor.position() == 0 ? QTextCursor::NextCharacter : QTextCursor::PreviousCharacter, QTextCursor::KeepAnchor);

  cursor.mergeCharFormat(fmt);
  m_inputText->mergeCurrentCharFormat(fmt);

  if(m_inputText->toPlainText().isEmpty())
  {
    cursor.setBlockCharFormat(m_inputText->currentCharFormat());
    cursor.clearSelection();
  }
}

void InputRichTextWgt::clear()
{
  QTextCharFormat fmt = m_inputText->currentCharFormat();

  m_inputText->clear();

  mergeFormat(fmt);
}

void InputRichTextWgt::setFontFamily(const QString & fam)
{
  QTextCharFormat fmt;
  fmt.setFontFamily(fam);
  mergeFormat(fmt);
}

void InputRichTextWgt::setFontSize(const QString & pnt)
{
  QTextCharFormat fmt;
  fmt.setFontPointSize(pnt.toFloat());
  mergeFormat(fmt);
}

// just copy-pasted frm qt4/demos/textedit
void InputRichTextWgt::setTextStyle(int styleIndex)
{
  QTextCursor cursor = m_inputText->textCursor();

  if(styleIndex != 0)
  {
    QTextListFormat::Style style = QTextListFormat::ListDisc;

    switch (styleIndex)
    {
      default:
      case 1:
        style = QTextListFormat::ListDisc;
        break;

      case 2:
        style = QTextListFormat::ListCircle;
        break;

      case 3:
        style = QTextListFormat::ListSquare;
        break;

      case 4:
        style = QTextListFormat::ListDecimal;
        break;

      case 5:
        style = QTextListFormat::ListLowerAlpha;
        break;

      case 6:
        style = QTextListFormat::ListUpperAlpha;
        break;
    }

    cursor.beginEditBlock();

    QTextBlockFormat blockFmt = cursor.blockFormat();

    QTextListFormat listFmt;

    if (cursor.currentList())
    {
      listFmt = cursor.currentList()->format();
    }
    else
    {
      listFmt.setIndent(blockFmt.indent() + 1);
      blockFmt.setIndent(0);
      cursor.setBlockFormat(blockFmt);
    }

    listFmt.setStyle(style);

    cursor.createList(listFmt);

    cursor.endEditBlock();
  }
  else
  {
  }
}

void InputRichTextWgt::createTable(uint rows, uint cols)
{
  QTextTableFormat fmt;

  fmt.setHeaderRowCount(rows);

  m_inputText->textCursor().insertTable(rows, cols, fmt);
}
