/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "pluginmanager.h"

#include <QDir>
#include <QPluginLoader>
#include <QCoreApplication>

#include "pluginsinterfaces.h"
#include "plugin.h"
#include "qchatsettings.h"

PluginManager::PluginManager(QObject *parent)
 : QObject(parent)
{
}

PluginManager::~PluginManager()
{
}

void PluginManager::getPlugins()
{
  QStringList dirs;
  QDir pluginsDir;

#if defined(Q_OS_LINUX)
  dirs.append(QCoreApplication::applicationDirPath() + "/../lib/qchat/plugins");
#else
  dirs.append(QCoreApplication::applicationDirPath() + "/plugins");
#endif
  dirs.append(QChatSettings::settings()->settingsDir() + "/plugins");

  QChatBasicPlugin* plug;
  QChatWidgetPlugin* wgt;

  qDebug("[PluginManager::getPlugins]: Loading plugins...\n");

  foreach(QString d, dirs)
  {
    pluginsDir.setPath(d);

    foreach(QString fileName, pluginsDir.entryList(QDir::Files))
    {
      QString        path   = pluginsDir.absoluteFilePath(fileName);
      QPluginLoader* loader = new QPluginLoader(path);
      Plugin*        info   = new Plugin;

      QObject* plugin = loader->instance();

      plug = qobject_cast<QChatBasicPlugin*>(plugin);
      wgt  = qobject_cast<QChatWidgetPlugin*>(plugin);

      qDebug("[PluginManager::getPlugins]: loading: %s\n", path.toLocal8Bit().data());

      if(wgt)
      {
        plug = wgt;
        info->setType(Plugin::Widget);
      }

      if(plug || wgt)
      {
        info->setPath(path);
        info->setName(plug->name());
        info->setPlugin(loader);
      connect(plugin,
              SIGNAL(sendData(const QString &, const QMap<QString, QByteArray> &, quint64,
                              AbstractChatCore::DataType, const QString &, uint, const QString &)),
              this,
              SIGNAL  (sendData(const QString &, const QMap<QString, QByteArray> &, quint64,
                              AbstractChatCore::DataType, const QString &, uint, const QString &)));

        qDebug("[PluginManager::getPlugins]: loaded: %s(%s)\n", fileName.toLocal8Bit().data(), plug->name().toLocal8Bit().data());

//         delete plugin;
//         loader->unload();

        m_plugins.append(info);
      }
    }
  }
}

Plugin * PluginManager::getPluginByPath(const QString & path)
{
  foreach(Plugin* pl, plugins())
    if(pl->path() == path)
      return pl;

  return NULL;
}

void PluginManager::load(const QString & path)
{
  Plugin* plugin = getPluginByPath(path);

  if(plugin)
    plugin->load();
}

void PluginManager::unload(const QString & path)
{
  Plugin* plugin = getPluginByPath(path);

  if(plugin)
    plugin->unload();
}
