/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef SINGLEMSGSHISTORYVIEW_H
#define SINGLEMSGSHISTORYVIEW_H

#include <QWidget>
#include <QTreeView>
#include <QModelIndex>
#include <QAbstractItemModel>
#include <QComboBox>
#include <QLabel>
#include <QToolButton>
#include <QCheckBox>
#include <QAction>

#include "singlemessagewgt.h"

class SingleMessage;
class SingleMsgsHistoryModel;

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class SingleMsgsHistoryView : public QWidget
{
  Q_OBJECT
  private:
    QTreeView*   m_treeView;
    QComboBox*   m_layoutCmbx;
    SingleMsgsHistoryModel* m_model;
    QLabel*      m_viewFormatLab;

    QToolButton* m_nextNewMessageBtn;
    QToolButton* m_prevNewMessageBtn;
    QToolButton* m_nextOpenedMessageBtn;
    QToolButton* m_prevOpenedMessageBtn;
    QToolButton* m_closeAllNewMessagesBtn;
    QToolButton* m_closeAllOpenedMessagesBtn;

    QCheckBox*   m_currentCloseChbx;

    QAction*     m_nextNewMessageAct;
    QAction*     m_prevNewMessageAct;
    QAction*     m_nextOpenedMessageAct;
    QAction*     m_prevOpenedMessageAct;
    QAction*     m_closeAllNewMessagesAct;
    QAction*     m_closeAllOpenedMessagesAct;

  public:
    SingleMsgsHistoryView(QWidget *parent = 0);
    ~SingleMsgsHistoryView();

    void resizeColumnToContents(int col){m_treeView->resizeColumnToContents(col);}
    void setModel(QAbstractItemModel* model);

    void retranslate();
    void updateShortcuts();

    void update();

  public slots:
    void setTreeLayout(int);
    void sort(int, Qt::SortOrder);

    void nextNewMessage()
    {SingleMessageWgt::nextPrevNewMessage(1, m_currentCloseChbx->checkState() == Qt::Checked); update();}

    void prevNewMessage()
    {SingleMessageWgt::nextPrevNewMessage(-1, m_currentCloseChbx->checkState() == Qt::Checked); update();}

    void nextOpenedMessage()
    {SingleMessageWgt::nextPrevOpenedMessage(1, m_currentCloseChbx->checkState() == Qt::Checked); update();}

    void prevOpenedMessage()
    {SingleMessageWgt::nextPrevOpenedMessage(-1, m_currentCloseChbx->checkState() == Qt::Checked); update();}

    void closeAllNewMessages()   {SingleMessageWgt::closeAllNewMessages(); update();}
    void closeAllOpenedMessages(){SingleMessageWgt::closeAllOpenedMessages(); update();}

  signals:
    void doubleClicked(const QModelIndex&);
};

#endif
