/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

/*	Carles Pina i Estany <carles@pinux.info> 2005, 2006
	GPL Licensed
*/

#include <qdialog.h> 
#include <qfiledialog.h>
#include <qsettings.h>
#include <qmessagebox.h>
#include "auxiliar.h"

int language;
int configurat;

void Configure::destroy()
{
	cancelaf();
}

void Configure::busca_fitxerf()
{
	QString workingDirectory;

       QFileDialog *dlg = new QFileDialog(directori->text() ,
                QString::null, 0, 0, TRUE );
	 
        dlg->setCaption( QFileDialog::tr( "Open" ) );
        dlg->setMode( QFileDialog::DirectoryOnly);
        QString result;
        if ( dlg->exec() == QDialog::Accepted ) {
            result = dlg->selectedFile();
            workingDirectory = dlg->url();
		directori->setText(result);
        }
	directori->setText(result);
        delete dlg;
      //  return result;

}

void Configure::okf()
{
    QSettings settings;
    settings.setPath("Dacco", "QDacco" );

    settings.writeEntry("/Dacco/directori", directori->text());
    settings.writeEntry("/Dacco/diccionari_per_defecte", traduccio_defecte->currentItem()+1);
    settings.writeEntry("/Dacco/idioma_per_defecte", idioma_defecte->currentItem());
    settings.writeEntry("/Dacco/configurat",1);

    if (language!=idioma_defecte->currentItem()) {
		    QMessageBox::information(this, "QDacco",
    "To change the default language, you will have to restart QDacco");
    }

    settings.writeEntry("/Dacco/name",nom->text());
    settings.writeEntry("/Dacco/email",email->text());

    //al acabar la funci, es destrueix l'objecte i queda guardat tot plegat
    this->close();
}

void Configure::cancelaf()
{
	QSettings settings;
	settings.setPath( "Dacco", "QDacco" );
    	settings.writeEntry("/Dacco/configurat",1);

	this->close();
}

void Configure::carregar_config()
{
	//static auxiliar AUX;
	QSettings qs;

	qs.setPath("Dacco","QDacco");

	directori->setText(qs.readEntry( "/dacco/directori", "" ));

	//printf("PATH d'auxiliar: %s\n",(const char*) PATH);
	
	if (directori->text()=="") {
		QDir dir("/usr/share/dacco-common/dictionaries/");
		if (dir.exists()) {
			directori->setText("/usr/share/dacco-common/dictionaries/");
		}
	}
	
	traduccio_defecte->setCurrentItem(qs.readNumEntry("/dacco/diccionari_per_defecte",1)-1);
	idioma_defecte->setCurrentItem(qs.readNumEntry("/dacco/idioma_per_defecte",1));
	language=idioma_defecte->currentItem();

	nom->setText(qs.readEntry("/dacco/name",""));
	email->setText(qs.readEntry("/dacco/email",""));
	

//	traduccio_defecte->setCount(qs.readNumEntry("/dacco/diccionari_per_defecte",2)-1);

}

void Configure::ajuda_s()
{
	QMessageBox::information(this,"QDacco help",tr("Select the \"dictionaries\" directory on your system"));
}

void Configure::ajudan_s()
{
	QMessageBox::information(this,"QDacco help",tr("If you send some suggestions or bug reports to Dacco,\nwe will know your name. This is not compulsory"));
}


void Configure::ajudae_s()
{
	QMessageBox::information(this,"QDacco help",tr("If you send some suggestions or bug reports to Dacco,\nwe will know your e-mail. This is not compulsory"));

}
